% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{equal1}
\alias{equal1}
\title{Non-symmetric version of EQUAL}
\usage{
equal1(X, lambda, err = 10^(-5), maxIter = 10^3L, rho = 1,
  diag = 0L)
}
\arguments{
\item{X}{data matrix of dimension n*p.}

\item{lambda}{user supplied tuning parameter;}

\item{err}{the precision used to stop the convergence. Default is 1e-5. 
Iterations stop when average absolute parameter change is less than \code{err}.}

\item{maxIter}{Maximum number of iterations. Default is 1000.}

\item{rho}{step parameter for the ADMM. Default is 1.}

\item{diag}{Should diagonal elements of the Matrix be thresholding? Default is FALSE.}
}
\value{
A list with components
\item{Omega}{a list of sparse p*p matrices corresponding to lambda.}
\item{lambda}{the used lambda for the solution path.}
\item{niter}{the number of iterations for each element of lambda.}
}
\description{
ADMM algorithm for high precision matrix estimation using asymmetic loss
}
