\name{mle_newton}
\alias{mle_newton}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Calculate the mle for covariance matrix in the PLN model.
}
\description{
Using the moment estimator for covariance matrix as initial value, this function use newton-raphson algorithm for maximizing the log likelihood of PLN model with respect to the parameters.
}
\usage{
mle_newton(data_use,S_depth,core_num = 1,k_max = 10)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{data_use}{
An abundance count matrix with Cell rows and Gene columns.
}
  \item{S_depth}{
  The estimated library size of cells.
  }
  \item{core_num}{
  The number of cores for parallel computation. Default 1.
  }
  \item{k_max}{
  The iteration steps of newton-raphson algorithm. Default 10.
  }
}

\value{
  \item{mlemu}{
  A list of length k_max + 1. The first element is the moment estimator of mean paramter, and the i th element is the (i-1) th step's estimation during the newton-raphson algorithm.
  }
    \item{mlesigmahat}{
  A list of length k_max + 1. The first element is the moment estimator of covariance matrix, and the i th element is the (i-1) th step's estimation during the newton-raphson algorithm.
  }
}

\examples{

library(MASS)
library(CVXR)
library(orthopolynom)

##--------------------------------------------------------------------------

cov_input<-mle_newton(data_use = PLNet::obs_mat,
                      S_depth = rowSums(PLNet::obs_mat),
                      k_max = 10,
                      core_num = 1)
                      
##--------------------------------------------------------------------------

}