##1. Package loading
##---------------------------------------------------------------------------
library(MASS)
library(glasso)
library(PLNmodels)
library(doParallel)
library(CVXR)
library(igraph)
library(EQUAL)
library(PLNet)
library(orthopolynom)
library(Rcpp)
library(RcppArmadillo)
##---------------------------------------------------------------------------

##2. Prepare function
##---------------------------------------------------------------------------
#trace
tr<-function(A){
  return(sum(diag(A)))
}

#sub_diagonal matrix construction
sub_diag<-function(p,diag_num){
  AAA<-matrix(0,nrow = p,ncol = p)
  for(j in 1:(p-1)){
    AAA[j,]<-(c(rep(0,j),rep(1,diag_num),rep(0,ifelse(p-j-diag_num>0,p-j-diag_num,0))))[1:p]
  }
  AAA_1<-AAA+t(AAA)+diag(p)
  return(AAA_1)
}

#network_generator
network_generator<-function(dim_use,graph_use,densy_use,nondiag_value = 0.3){
  if(graph_use == "Band-graph"){
    Pre_mat<-sub_diag(dim_use,densy_use) * nondiag_value
    diag(Pre_mat)<-1
    #positive definite
    eigen_res<-eigen(Pre_mat)
    if(min(eigen_res$values)<1e-5){
      diag(Pre_mat)<-diag(Pre_mat) + abs(min(eigen_res$values)) + 1e-1
    }
  }
  if(graph_use == "Erdos-Renyi-graph"){
    G_1<-matrix(rep(0,dim_use*dim_use),nrow = dim_use)
    G_1[upper.tri(G_1)][sample(1:(dim_use*(dim_use-1)/2),floor(densy_use*(dim_use*(dim_use-1)/2))+1,replace = FALSE)]<-1
    index_1<-G_1[upper.tri(G_1)]
    G_1<-t(G_1)+G_1
    diag(G_1)<-1
    bg_mat<-diag(dim_use)
    bg_mat[upper.tri(bg_mat)][index_1==1]<-ifelse(rbinom(sum(index_1==1),1,0.8)==0,(-1) * nondiag_value,nondiag_value)
    bg_mat<-bg_mat+t(bg_mat)-diag(dim_use)
    scalar_para<-0.1
    Pre_mat<-G_1*bg_mat+diag(rep(abs(min(eigen(G_1*bg_mat)$values))+scalar_para,dim_use))
    rm(G_1);rm(bg_mat)
  }
  
  if(graph_use == "Preferential-attachment-graph"){
    # ##random graph
    # G_1<-matrix(rep(0,dim_use*dim_use),nrow = dim_use)
    # G_1[upper.tri(G_1)][sample(1:(dim_use*(dim_use-1)/2),floor(densy_use*(dim_use*(dim_use-1)/2))+1,replace = FALSE)]<-1
    # index_1<-G_1[upper.tri(G_1)]
    # G_1<-t(G_1)+G_1
    # diag(G_1)<-1
    
    ##banded graph
    Pre_mat<-sub_diag(dim_use,2) * nondiag_value
    diag(Pre_mat)<-1
    G_1<-ifelse(Pre_mat!=0,1,0)
    diag(G_1)<-1
    ##
    start_graph<-igraph::graph.adjacency(adjmatrix = G_1,
                                         mode = "undirected")
    ##
    PA_graph<-barabasi.game(dim_use,power = 1,zero.appeal = 1,
                            directed = TRUE,
                            start.graph = start_graph,
                            out.pref = TRUE)
    # ##old
    # PA_graph<-barabasi.game(dim_use,power = 1,zero.appeal = 1,
    #                         directed = TRUE)
    
    ##------------------------
    adjoin_mat<-as.matrix(igraph::as_adjacency_matrix(PA_graph))
    adjoin_mat<-adjoin_mat + t(adjoin_mat) + diag(dim_use)
    adjoin_mat<-ifelse(adjoin_mat==0,0,1)
    index_1<-adjoin_mat[upper.tri(adjoin_mat)]
    bg_mat<-diag(dim_use)
    # bg_mat[upper.tri(bg_mat)][index_1==1]<-ifelse(rbinom(sum(index_1==1),1,0.8)==0,(-1) * nondiag_value,nondiag_value)
    bg_mat[upper.tri(bg_mat)][index_1==1]<-ifelse(rbinom(sum(index_1==1),1,0.5)==0,(-1) * nondiag_value,nondiag_value)
    bg_mat<-bg_mat+t(bg_mat)-diag(dim_use)
    # scalar_para<-0.1
    scalar_para<-0.1
    if(min(eigen(adjoin_mat*bg_mat)$values)<0){
      Pre_mat<-adjoin_mat*bg_mat+diag(rep(abs(min(eigen(adjoin_mat*bg_mat)$values))+scalar_para,dim_use)) 
    }else{
      Pre_mat<-adjoin_mat*bg_mat
    }
  }
  
  
  if(graph_use == "Affiliation-graph"){
    com_num<-5
    p_eachcom<-dim_use/com_num
    graph_dense0<-diag(dim_use)
    index_0<-1
    for(com_index in 1:com_num){
      graph_dense0[index_0:(index_0 + p_eachcom-1),index_0:(index_0 + p_eachcom-1)]<-1
      index_0<-index_0 + p_eachcom
    }
    index_edge0<-which(graph_dense0[upper.tri(graph_dense0)] == 1)
    index_1<-sample(index_edge0,floor(densy_use*(dim_use*(dim_use-1)/2))+1,replace = FALSE)
    
    G_1<-matrix(rep(0,dim_use*dim_use),nrow = dim_use)
    G_1[upper.tri(G_1)][index_1]<-1
    index_2<-G_1[upper.tri(G_1)]
    G_1<-t(G_1)+G_1
    diag(G_1)<-1
    bg_mat<-diag(dim_use)
    bg_mat[upper.tri(bg_mat)][index_2==1]<-ifelse(rbinom(sum(index_2==1),1,0.8)==0,(-1) * nondiag_value,nondiag_value)
    bg_mat<-bg_mat+t(bg_mat)-diag(dim_use)
    scalar_para<-0.1
    Pre_mat<-G_1*bg_mat+diag(rep(abs(min(eigen(G_1*bg_mat)$values))+scalar_para,dim_use))
    rm(G_1);rm(bg_mat)
  }
  ############
  return(Pre_mat)
}

##---------------------------------------------------------------------------

##3. Simulation settings design
##---------------------------------------------------------------------------
##sample size and dimension
dim_use_vec<-c(100,300,500)
sample_size_vec<-c(500,2000)
dim_sample_mat<-cbind(rep(dim_use_vec,each  = length(sample_size_vec)),rep(sample_size_vec,length(dim_use_vec)))

##graph structure
graph_vec<-c("Band-graph","Erdos-Renyi-graph","Preferential-attachment-graph","Affiliation-graph")

##Dropout levels
dropout_vec<-c("low","high")

##reptime
reptime<-100

#hyper-parameter setting
lambda_max0<-10

#run_index
##4 2 6
run_index<-c(1,1,1)
##with
graph_index<-run_index[1]
dropout_index<-run_index[2]
dim_sample_index<-run_index[3]
##---------------------------------------------------------------------------

##4. Simulation data generation
##---------------------------------------------------------------------------
##obs_mat & pre_mat
obs_mat_array<-array(NA,dim = c(reptime,dim_sample_mat[dim_sample_index,2],dim_sample_mat[dim_sample_index,1]))
Pre_mat_array<-array(NA,dim = c(reptime,dim_sample_mat[dim_sample_index,1],dim_sample_mat[dim_sample_index,1]))

##
set.seed(123)
##
for(rep_index in 1:reptime){
  ## 1.1 Network generation
  dim_use<-dim_sample_mat[dim_sample_index,1]
  if(graph_index == 1){
    Pre_mat<-network_generator(dim_use = dim_use, graph_use = graph_vec[graph_index],
                               densy_use = 2,nondiag_value = 0.3)
  }else{
    Pre_mat<-network_generator(dim_use = dim_use, graph_use = graph_vec[graph_index],
                               densy_use = (2*dim_use -3)/(dim_use * (dim_use - 1)/2),nondiag_value = 0.3)
  }
  
  Pre_mat_array[rep_index,,]<-Pre_mat
  
  
  ## 1.2 Sc-RNA-seq generation
  ## 1.2.1 sequencing depth
  sample_size<-dim_sample_mat[dim_sample_index,2]
  S_depth<-exp(rnorm(sample_size,mean = log(10),sd = 0.1))
  S_depth<-ifelse(S_depth==0,0.5,S_depth)
  
  ## 1.2.2 mu
  if(dropout_index == 1){
    mu_vec<-c(rep(-2.35,dim_use)) ##40% dropout
  }else{
    mu_vec<-c(rep(-3.2,dim_use)) ##60% dropout
  }
  
  
  ## 1.2.3 Y
  log_a<-mvrnorm(n=sample_size, mu_vec, solve(Pre_mat))
  log_a<-ifelse(log_a>50,50,log_a)
  a<-exp(log_a)
  b<-a * matrix(rep(S_depth,each=dim_use),nrow = sample_size,byrow = TRUE)
  Y<-matrix(NA,nrow = sample_size,ncol = dim_use)
  for(i in 1:sample_size){
    for(j in 1:dim_use){
      Y[i,j]<-rpois(1,b[i,j])
    }
  }
  rm(log_a);rm(a);rm(b)
  obs_mat_array[rep_index,,]<-Y
}
##---------------------------------------------------------------------------

##5. The training and evaluation of each method
##5.1 PLNet
##---------------------------------------------------------------------------
print("PLNet")
PLNet_res<-foreach (
  rep = 1:reptime,
  .combine = "rbind",
  .inorder = TRUE,
  .export = ls(.GlobalEnv),
  .packages = c('MASS', 'glasso','PLNmodels','doParallel','CVXR','igraph','EQUAL',"PLNet","orthopolynom","Rcpp","RcppArmadillo")
)%dopar%{
  ##load the data
  Y<-obs_mat_array[rep,,]
  Pre_mat<-Pre_mat_array[rep,,]
  
  ##Estimate the library size by total sum scaling.
  S_depth<-rowMeans(Y) 
  
  
  k_max<-10 ## The maximal iter for MLE calculation by newton-raphson algorithm
  
  ##MLE for convariance matrix
  cov_input<-mle_newton(data_use = Y,
                        S_depth = S_depth,
                        core_num = 1,
                        k_max = k_max)
  ##
  res_all_vec<-c()
  ##
  k_index<-k_max
  ##
  ##Use dtrace-loss for precision matrix's estimation
  PLNet_res<-PLNet_main(obs_mat = Y,
                        Sd_est = S_depth,
                        n_lambda = 100,
                        penalize.diagonal = FALSE,
                        cov_input = cov_input$mlesigmahat[[1 + k_index]],
                        weight_mat = NULL,zero_mat = NULL,
                        core_num = 1)
  lambda_vec1<-PLNet_res$lambda_vec
  
  ##Calculate the AUC and AUPR
  ROCXY<-matrix(0,nrow = 2,ncol = length(lambda_vec1))
  PRXY<-matrix(0,nrow = 2,ncol = length(lambda_vec1))

  
  for (i in 1:length(lambda_vec1)) {
    table1<-matrix(0,nrow = 2,ncol = 2)
    bb<-as.matrix(PLNet_res[[1]][[i]])
    table1[1,1]<-sum((bb[upper.tri(bb)]==0) & (Pre_mat[upper.tri(Pre_mat)]==0))
    table1[1,2]<-sum((bb[upper.tri(bb)]==0) & (Pre_mat[upper.tri(Pre_mat)]!=0))
    table1[2,1]<-sum((bb[upper.tri(bb)]!=0) & (Pre_mat[upper.tri(Pre_mat)]==0))
    table1[2,2]<-sum((bb[upper.tri(bb)]!=0) & (Pre_mat[upper.tri(Pre_mat)]!=0))
    ROCXY[,i]<-table1[2,]/colSums(table1)
    PRXY[1,i]<-table1[2,2]/sum(table1[,2])
    PRXY[2,i]<-ifelse(is.nan((table1[,2]/rowSums(table1))[2]),1,(table1[,2]/rowSums(table1))[2])
    rm(bb)
  }
  
  ROCXY_2<-cbind(matrix(c(1,1),nrow = 2),ROCXY)
  ROCXY_1<-as.data.frame(t(rbind(sort(ROCXY_2[1,]),ROCXY_2[2,order(ROCXY_2[1,])])))
  names(ROCXY_1)<-c("FPR","TPR")
  ROCXY_1<-rbind(c(0,0),ROCXY_1,c(1,1))
  
  PRXY_2<-cbind(matrix(1,colSums(table1)[2]/colSums(table1)[1],nrow = 2),PRXY)
  PRXY_1<-as.data.frame(t(rbind(sort(PRXY_2[1,]),PRXY_2[2,order(PRXY_2[1,])])))
  names(PRXY_1)<-c("Recall","Precison")
  PRXY_1<-rbind(c(0,1),PRXY_1,c(1,0))
  PRXY_1<-PRXY_1[which(rowSums(PRXY_1)!=0),]
  
  #AUC
  AUC_Dtrace<-sum(diff(ROCXY_1[,1])*(ROCXY_1[-nrow(ROCXY_1),2]+ROCXY_1[-1,2])/2)
  #AUPR
  AUPR_Dtrace<-sum(diff(PRXY_1[,1])*(PRXY_1[-nrow(PRXY_1),2]+PRXY_1[-1,2])/2)
  
  
  #choose lambda by BIC
  theta0_chooseD<-as.matrix(PLNet_res$Omega_chooseB)
  # base::save(theta0_chooseD,file = paste("./PLNet/BIC/PLNet_dim",dim_sample_mat[dim_sample_index,1],"_sam",dim_sample_mat[dim_sample_index,2],"_graph",graph_index,
  #                                       "_dropout",dropout_index,"_rep",rep,".Rdata",sep = ""))
  
  time_D<-PLNet_res$time_sigmamoment + PLNet_res$time_EQUAL
  time_sigmamoment<-PLNet_res$time_sigmamoment
  time_EQUAL<-PLNet_res$time_EQUAL
  
  ##
  rm(PLNet_res);
  rm(theta0_chooseD);
  
  gc()
  res_all_vec<-c(res_all_vec,(c(AUC_Dtrace,AUPR_Dtrace,time_D)))
  
  return(res_all_vec)
}
##---------------------------------------------------------------------------

##5.2 PLNet_MOM
##---------------------------------------------------------------------------
print("PLNet_MOM")
PLNet_MOM_res<-foreach (
  rep = 1:reptime,
  .combine = "rbind",
  .inorder = TRUE,
  .export = ls(.GlobalEnv),
  .packages = c('MASS', 'glasso','PLNmodels','doParallel','CVXR','igraph','EQUAL',"PLNet")
)%dopar%{
  ##load the data
  Y<-obs_mat_array[rep,,]
  Pre_mat<-Pre_mat_array[rep,,]
  
  ##Estimate the library size by total sum scaling.
  S_depth<-rowMeans(Y)

  ##Use dtrace-loss for precision matrix's estimation
  PLNet_res<-PLNet_main(obs_mat = Y,
                        Sd_est = S_depth,
                        n_lambda = 100,
                        penalize.diagonal = FALSE,
                        cov_input = NULL,
                        weight_mat = NULL,zero_mat = NULL,
                        core_num = 1)
  
  lambda_vec1<-PLNet_res$lambda_vec
  
  ##Calculate the AUC and AUPR
  ROCXY<-matrix(0,nrow = 2,ncol = length(lambda_vec1))
  PRXY<-matrix(0,nrow = 2,ncol = length(lambda_vec1))
  
  for (i in 1:length(lambda_vec1)) {
    table1<-matrix(0,nrow = 2,ncol = 2)
    bb<-as.matrix(PLNet_res[[1]][[i]])
    table1[1,1]<-sum((bb[upper.tri(bb)]==0) & (Pre_mat[upper.tri(Pre_mat)]==0))
    table1[1,2]<-sum((bb[upper.tri(bb)]==0) & (Pre_mat[upper.tri(Pre_mat)]!=0))
    table1[2,1]<-sum((bb[upper.tri(bb)]!=0) & (Pre_mat[upper.tri(Pre_mat)]==0))
    table1[2,2]<-sum((bb[upper.tri(bb)]!=0) & (Pre_mat[upper.tri(Pre_mat)]!=0))
    ROCXY[,i]<-table1[2,]/colSums(table1)
    PRXY[1,i]<-table1[2,2]/sum(table1[,2])
    PRXY[2,i]<-ifelse(is.nan((table1[,2]/rowSums(table1))[2]),1,(table1[,2]/rowSums(table1))[2])
    rm(bb)
  }
  
  ROCXY_2<-cbind(matrix(c(1,1),nrow = 2),ROCXY)
  ROCXY_1<-as.data.frame(t(rbind(sort(ROCXY_2[1,]),ROCXY_2[2,order(ROCXY_2[1,])])))
  names(ROCXY_1)<-c("FPR","TPR")
  ROCXY_1<-rbind(c(0,0),ROCXY_1,c(1,1))
  
  PRXY_2<-cbind(matrix(1,colSums(table1)[2]/colSums(table1)[1],nrow = 2),PRXY)
  PRXY_1<-as.data.frame(t(rbind(sort(PRXY_2[1,]),PRXY_2[2,order(PRXY_2[1,])])))
  names(PRXY_1)<-c("Recall","Precison")
  PRXY_1<-rbind(c(0,1),PRXY_1,c(1,0))
  PRXY_1<-PRXY_1[which(rowSums(PRXY_1)!=0),]
  
  #AUC
  AUC_Dtrace<-sum(diff(ROCXY_1[,1])*(ROCXY_1[-nrow(ROCXY_1),2]+ROCXY_1[-1,2])/2)
  #AUPR
  AUPR_Dtrace<-sum(diff(PRXY_1[,1])*(PRXY_1[-nrow(PRXY_1),2]+PRXY_1[-1,2])/2)
  
  
  #choose lambda by BIC
  theta0_chooseD<-as.matrix(PLNet_res$Omega_chooseB)
  # base::save(theta0_chooseD,file = paste("./PLNet/BIC/PLNet_MOM_dim",dim_sample_mat[dim_sample_index,1],"_sam",dim_sample_mat[dim_sample_index,2],"_graph",graph_index,
  #                                       "_dropout",dropout_index,"_rep",rep,".Rdata",sep = ""))
  
  
  time_D<-PLNet_res$time_sigmamoment + PLNet_res$time_EQUAL
  time_sigmamoment<-PLNet_res$time_sigmamoment
  time_EQUAL<-PLNet_res$time_EQUAL
  
  ##
  rm(PLNet_res);
  rm(theta0_chooseD);
  
  gc()
  return(c(AUC_Dtrace,AUPR_Dtrace,time_D))
}
##---------------------------------------------------------------------------

##5.3 VPLN
##---------------------------------------------------------------------------
print("VPLN")
VPLN_res<-foreach (
  rep = 1:reptime,
  .combine = "rbind",
  .inorder = TRUE,
  .export = ls(.GlobalEnv),
  .packages = c('MASS', 'glasso','PLNmodels','doParallel','CVXR','EQUAL',"PLNet")
)%dopar%{
  ##load the data
  Y<-obs_mat_array[rep,,]
  Pre_mat<-Pre_mat_array[rep,,]

  ##Estimate the library size by total sum scaling.
  S_depth<-rowMeans(Y)
  
  #Variational method
  
  original_list<-list(data_1=as.data.frame(Y),
                      Covariate=as.data.frame(matrix(rep(0,dim(Y)[1]),ncol = 1)))
  pre_data<-prepare_data(counts = original_list$data_1,covariates = original_list$Covariate,offset = "TSS")
  names(pre_data)[2]<-"covariates"
  time_1<-Sys.time()
  fits <- PLNnetwork(Abundance ~ 1 + offset(log(Offset)), data = pre_data,control_init = list(nPenalties=100,min.ratio=1e-4),control_main = list(xtol_rel = 1e-2))
  time_2<-Sys.time()
  time_V<-as.double(difftime(time_2,time_1,units = "hours"))
  
  rm(original_list);rm(pre_data)
  ROCXY_V<-matrix(0,nrow = 2,ncol = length(fits$penalties))
  PRXY_V<-matrix(0,nrow = 2,ncol = length(fits$penalties))
  bm<-fits$models
  
  pre_V_choose<-bm[[which.max(fits$criteria$BIC)]]$model_par$Omega
  # base::save(pre_V_choose,file = paste("./VPLN/BIC/pre_V_choose_dim",dim_sample_mat[dim_sample_index,1],"_sam",dim_sample_mat[dim_sample_index,2],"_graph",graph_index,
  #                            "_densy",densy_ratio_index,"_dropout",dropout_index,"_v",v_index,"_rep",rep,".Rdata",sep = ""))
  
  ##Calculate the AUC and AUPR
  
  for (l in 1:length(fits$penalties)) {
    pre_V<-bm[[l]]$model_par$Omega
    table2<-matrix(0,nrow = 2,ncol = 2)
    table2[1,1]<-sum((pre_V[upper.tri(pre_V)]==0) & (Pre_mat[upper.tri(Pre_mat)]==0))
    table2[1,2]<-sum((pre_V[upper.tri(pre_V)]==0) & (Pre_mat[upper.tri(Pre_mat)]!=0))
    table2[2,1]<-sum((pre_V[upper.tri(pre_V)]!=0) & (Pre_mat[upper.tri(Pre_mat)]==0))
    table2[2,2]<-sum((pre_V[upper.tri(pre_V)]!=0) & (Pre_mat[upper.tri(Pre_mat)]!=0))
    ROCXY_V[,l]<-table2[2,]/colSums(table2)
    PRXY_V[1,l]<-(table2[2,]/colSums(table2))[2]
    PRXY_V[2,l]<-ifelse(is.nan((table2[,2]/rowSums(table2))[2]),1,(table2[,2]/rowSums(table2))[2])
  }
  ROCXY_V1<-as.data.frame(t(rbind(sort(ROCXY_V[1,]),ROCXY_V[2,order(ROCXY_V[1,])])))
  names(ROCXY_V1)<-c("FPR","TPR")
  ROCXY_V1<-rbind(c(0,0),ROCXY_V1,c(1,1))
  PRXY_V1<-as.data.frame(t(rbind(sort(PRXY_V[1,]),PRXY_V[2,order(PRXY_V[1,])])))
  names(PRXY_V1)<-c("Recall","Precison")
  PRXY_V1<-rbind(c(0,1),PRXY_V1,c(1,0))
  PRXY_V1<-PRXY_V1[which(rowSums(PRXY_V1)!=0),]
  
  ##AUC
  AUC_VPLN<-sum(diff(ROCXY_V1[,1])*(ROCXY_V1[-nrow(ROCXY_V1),2]+ROCXY_V1[-1,2])/2)
  ##AUPR
  AUPR_VPLN<-sum(diff(PRXY_V1[,1])*(PRXY_V1[-nrow(PRXY_V1),2]+PRXY_V1[-1,2])/2)
  rm(fits);
  rm(bm);
  rm(pre_V_choose);
  rm(pre_V);
  
  gc()
  
  return(c(AUC_VPLN,AUPR_VPLN,time_V))
}
##---------------------------------------------------------------------------

##5.4 Glasso
##---------------------------------------------------------------------------
print("Glasso")
Glasso_res<-foreach (
  rep = 1:reptime,
  .combine = "rbind",
  .inorder = TRUE,
  .export = ls(.GlobalEnv),
  .packages = c('MASS', 'glasso','PLNmodels','doParallel','CVXR','EQUAL',"PLNet")
)%dopar%{
  ##load the data
  Y<-obs_mat_array[rep,,]
  Pre_mat<-Pre_mat_array[rep,,]
  
  ##Estimate the library size by total sum scaling.
  S_depth<-rowMeans(Y)
  
  Y_1<-Y+1
  Y_1<-Y_1/matrix(rep(S_depth,dim(Y)[2]),ncol = dim(Y)[2],byrow = FALSE)
  Y_1_log<-log(Y_1)
  rm(Y_1)
  lambda_valuemax<-lambda_max0
  con_1<-TRUE
  while (con_1) {
    aa<-as.matrix(glasso(cov(Y_1_log), rho=lambda_valuemax)$wi)
    nonzero_num <- length(which(aa[upper.tri(aa)]!=0))
    if(nonzero_num==0){
      lambda_valuemax<-lambda_valuemax*0.8
    }else{
      lambda_valuemax<-lambda_valuemax * 1.2
      con_1<-FALSE
    }
  }
  lambda_valuemin<-lambda_valuemax
  con_2<-TRUE
  while (con_2) {
    aa<-as.matrix(glasso(cov(Y_1_log), rho=lambda_valuemin)$wi)
    zero_num <- length(which(aa[upper.tri(aa)]==0))
    if(zero_num!=0){
      lambda_valuemin<-lambda_valuemin*0.8
    }else{
      con_2<-FALSE
    }
  }
  lambda_vec <- seq(from = lambda_valuemin,to=lambda_valuemax,length.out = 100)
  
  lambda_vec1<-lambda_vec
  ROCXY_G<-matrix(0,nrow = 2,ncol = length(lambda_vec1))
  PRXY_G<-matrix(0,nrow = 2,ncol = length(lambda_vec1))
  BIC_vecG<-c()
  Pre_mat_listG<-c()
  time_1<-Sys.time()
  for (l in 1:length(lambda_vec1)) {
    model_13<-glasso(cov(Y_1_log), rho=lambda_vec1[l])
    pre_G<-model_13$wi
    Pre_mat_listG[[l]]<-pre_G
    BIC_vecG<-c(BIC_vecG,sample_size*(-1*log(det(pre_G))+tr(cov(Y_1_log)%*%pre_G))+log(sample_size)*sum(ifelse(pre_G!=0,1,0)))
    table2<-matrix(0,nrow = 2,ncol = 2)
    table2[1,1]<-sum((pre_G[upper.tri(pre_G)]==0) & (Pre_mat[upper.tri(Pre_mat)]==0))
    table2[1,2]<-sum((pre_G[upper.tri(pre_G)]==0) & (Pre_mat[upper.tri(Pre_mat)]!=0))
    table2[2,1]<-sum((pre_G[upper.tri(pre_G)]!=0) & (Pre_mat[upper.tri(Pre_mat)]==0))
    table2[2,2]<-sum((pre_G[upper.tri(pre_G)]!=0) & (Pre_mat[upper.tri(Pre_mat)]!=0))
    ROCXY_G[,l]<-table2[2,]/colSums(table2)
    PRXY_G[1,l]<-(table2[2,]/colSums(table2))[2]
    PRXY_G[2,l]<-ifelse(is.nan((table2[,2]/rowSums(table2))[2]),1,(table2[,2]/rowSums(table2))[2])
    rm(model_13)
    rm(pre_G)
  }
  time_2<-Sys.time()
  time_G<-as.double(difftime(time_2,time_1,units = "hours"))
  
  ##BIC
  lambda_chooseG<-lambda_vec1[which.min(BIC_vecG)]
  pre_G_choose<-Pre_mat_listG[[which.min(BIC_vecG)]]
  # base::save(pre_G_choose,file = paste("./Glasso/BIC/pre_G_choose_dim",dim_sample_mat[dim_sample_index,1],"_sam",dim_sample_mat[dim_sample_index,2],"_graph",graph_index,
  #                                       "_densy",densy_ratio_index,"_dropout",dropout_index,"_v",v_index,"_rep",rep,".Rdata",sep = ""))
  rm(Pre_mat_listG)
  
  ##Calculate the AUC and AUPR
  ROCXY_G1<-as.data.frame(t(rbind(sort(ROCXY_G[1,]),ROCXY_G[2,order(ROCXY_G[1,])])))
  names(ROCXY_G1)<-c("FPR","TPR")
  ROCXY_G1<-rbind(c(0,0),ROCXY_G1,c(1,1))
  PRXY_G1<-as.data.frame(t(rbind(sort(PRXY_G[1,]),PRXY_G[2,order(PRXY_G[1,])])))
  names(PRXY_G1)<-c("Recall","Precison")
  PRXY_G1<-rbind(c(0,1),PRXY_G1,c(1,0))
  PRXY_G1<-PRXY_G1[which(rowSums(PRXY_G1)!=0),]
  ##AUC
  AUC_glasso<-sum(diff(ROCXY_G1[,1])*(ROCXY_G1[-nrow(ROCXY_G1),2]+ROCXY_G1[-1,2])/2)
  ##AUPR
  AUPR_glasso<-sum(diff(PRXY_G1[,1])*(PRXY_G1[-nrow(PRXY_G1),2]+PRXY_G1[-1,2])/2)

  rm(aa);
  rm(pre_G_choose)
  gc()
  return(c(AUC_glasso,AUPR_glasso,time_G))
}
##---------------------------------------------------------------------------

##6. Save the result of evaluation
##---------------------------------------------------------------------------
Whole_result<-list()
Whole_result[[1]]<-PLNet_res
Whole_result[[2]]<-PLNet_MOM_res
Whole_result[[3]]<-VPLN_res
Whole_result[[4]]<-Glasso_res
##Note: each returned object is a matrix with reptime rows and 3 columns, including AUC, AUPR and time cost.

base::save(Whole_result,file = paste("./Wholeresult_dim",dim_sample_mat[dim_sample_index,1],
                                     "_sam",dim_sample_mat[dim_sample_index,2],
                                     "_graph",graph_index,
                                     "_dropout",dropout_index,".Rdata",sep = ""))
##---------------------------------------------------------------------------







