import argparse

# Only returns arguments input by the user.
class CustomArgumentParser(argparse.ArgumentParser):
    def suppress_defaults(self):
        for action in self._actions:
            action.default = argparse.SUPPRESS

    def print_arg(self, args):
        output=""
        for action in self._actions:
            metavar = action.metavar
            arg_name = action.dest
            if metavar is not None:
                output += "{}{}_".format(metavar, getattr(args, arg_name))
        return output

def update_args(target, source):
    for key in source.__dict__:
        setattr(target, key, source.__dict__[key])

def str2bool(v):
    if isinstance(v, bool):
        return v
    if v.lower() in ('yes', 'true', 't', 'y', '1'):
        return True
    elif v.lower() in ('no', 'false', 'f', 'n', '0'):
        return False
    else:
        raise argparse.ArgumentTypeError('Boolean value expected.')
