using JLD2

@everywhere begin
    using LinearAlgebra, Random

    include("Muscada.jl")

    function run(μs, σs, πs, T)
        h = Muscada(σs, πs, H₂)
        K = length(σs)
        Rs = zeros(T)
        for t in 1:T
            ℓs = σs .* sign.(rand(K) - (σs.-μs)./2σs)
            incur!(h, ℓs)
            Rs[t] = maximum(h.Rs)
        end

        Rs
    end
end


function runset(μs, σs, πs, T, reps)
    pmap(1:reps) do i
        Random.seed!(i)
        run(μs, σs, πs, T)
    end
end


T = 10_000
reps = 2000
K = 50
σs = 1 ./ (1:K)
πs = ones(K)./K


μeasy = [zeros(2)
         -1/5
         zeros(K-3)
         ]
μhard = zeros(K)

data1 = runset(μeasy, σs, πs, T, reps)
data2 = runset(μhard, σs, πs, T, reps)

jldsave("bernstein.jld2"; T, reps, K, σs, πs, μeasy, μhard, data1, data2)

