"""Configurations for the mGLS experiments."""
import itertools

from scripts.classification.mgls import Config


def add_config(*, name, **kwargs):
    CONFIGS[name] = Config(name=name, **kwargs)


CONFIGS = {
    'fast': Config(
        name='fast',
        dataset='mnist49',
        n_components=8,
        m=4,
        N=350,
        max_steps=1024,
        random_subset=False,
    ),
}

_DATASETS = ['mnist49', 'fashion_mnist_pullover_coat']
_N_COMPONENTS = [8]
_M = [4, 8, 16, 32]
_N = [350]

for (dataset, n_components, m, N) in itertools.product(_DATASETS, _N_COMPONENTS, _M, _N):
    name = f'{dataset}_d{n_components}_m{m}_N{N}'
    add_config(
        name=name,
        dataset=dataset,
        n_components=n_components,
        m=m,
        N=N,
        max_steps=2048,
        random_subset=False,
    )
