from __future__ import absolute_import
from __future__ import division
from __future__ import print_function

import numpy as np
import scipy.stats as stat


def mean_lower_upper_confidence(data, confidece_percent=0.95):
    mean = np.mean(data)
    if len(data) <= 30:
        lower, upper = stat.t.interval(alpha=confidece_percent, df=len(data) - 1, loc=mean, scale=stat.sem(data))
    else:
        lower, upper = stat.norm.interval(alpha=confidece_percent, loc=mean, scale=stat.sem(data))
    return mean, lower, upper


def str_mean_confidence_interval(data, confidece_percent=0.95):
    m, l, u = mean_lower_upper_confidence(data, confidece_percent)
    return "{m}\t  $\pm$  {i}".format(m=m, i=u - m)


