clc;
clear all;
close all;

NumberofIterations=10;
eta_set=1e-5;
mu_set=1e-5;
Tau_design=1e-7;
Length_r_max_design=3;
Length_r_max_design1=5;
%% Given a full tensor %Full tensor %6-order
%
for ii_11=1:NumberofIterations

n_TT = [2, 2, 2, 2, 2, 2];%the unmber of n_TT equals to d_TT
d_TT=6;
r_TT=[1,2,2,2,2,2,1];%the unmber of rank=d_TT+1,rank_0=1,rank_N=1,we choose other positions
A_low_rank_TT_Tensor=tt_random(n_TT,d_TT,r_TT);
A_low_rank_TT_Tensor_vector=full(A_low_rank_TT_Tensor);
A=reshape(A_low_rank_TT_Tensor_vector,n_TT); %From TT-Tensor to original Tensor
B=reshape(A,[2,2^(d_TT-1)]);
B_value=norm(B,'fro');
A=A/B_value;
%
LowRankError_Tensor=randn(2, 2, 2, 2, 2, 2);
C=reshape(LowRankError_Tensor,[2,2^(d_TT-1)]);
C_value=norm(C,'fro');
LowRankError_Tensor=LowRankError_Tensor/C_value;

%
MeasurementError_Tensor=zeros(n_TT);
for i_1=1:n_TT(1);
for i_2=1:n_TT(2);
for i_3=1:n_TT(3);
for i_4=1:n_TT(4);
for i_5=1:n_TT(5);
for i_6=1:n_TT(6);
MeasurementError_Tensor(i_1,i_2,i_3,i_4,i_5,i_6)=mu_set*randn(1,1)/sqrt((d_TT-2)*8+2*4-4);
%
end
end
end
end
end
end


nswp=100; % Maximum Number of iterations
eta=eta_set;
Length_r_max=Length_r_max_design;% Estimated rank =Length_r_max-1
%

%
B=A+eta*LowRankError_Tensor;
C=B+MeasurementError_Tensor;
fun = @(ind) C(ind(1), ind(2), ind(3), ind(4), ind(5), ind(6) );
[y,Jyl,Jyr,ilocl,ilocr,evalcnt,Error_final]=greedy2_cross_Version_ZhenQin1(n_TT, fun, 1e-15, nswp, Length_r_max, []);

% Using Tau to truncate the diagonal matrix of SVD
tau=0;
tau1=Tau_design;
r_Length=zeros(length(ilocl)-2,1);
for iii=1:length(ilocl)-2
    r_Length(iii)=length(ilocl{iii+1});
end
Tensor=C;

[Y]=AddingTau(ilocl,ilocr,Tensor,n_TT,r_Length,tau);
[Y1]=AddingTau(ilocl,ilocr,Tensor,n_TT,r_Length,tau1);



MSE_CA_N=0;
MSE_CA_N1=0;
MSE_CA_D=0;
for i_1=1:n_TT(1);
for i_2=1:n_TT(2);
for i_3=1:n_TT(3);
for i_4=1:n_TT(4);
for i_5=1:n_TT(5);
for i_6=1:n_TT(6);
%
MSE_CA_D=MSE_CA_D+B(i_1,i_2,i_3,i_4,i_5,i_6)^2;
%
MSE_CA_N=MSE_CA_N+(B(i_1,i_2,i_3,i_4,i_5,i_6)-Y{1}(i_1,:)*reshape(Y{2}(:,i_2,:),[r_Length(1),r_Length(2)])*...
reshape(Y{3}(:,i_3,:),[r_Length(2),r_Length(3)])*reshape(Y{4}(:,i_4,:),[r_Length(3),r_Length(4)])*...
reshape(Y{5}(:,i_5,:),[r_Length(4),r_Length(5)])*Y{6}(:,i_6))^2;
%
MSE_CA_N1=MSE_CA_N1+(B(i_1,i_2,i_3,i_4,i_5,i_6)-Y1{1}(i_1,:)*reshape(Y1{2}(:,i_2,:),[r_Length(1),r_Length(2)])*...
reshape(Y1{3}(:,i_3,:),[r_Length(2),r_Length(3)])*reshape(Y1{4}(:,i_4,:),[r_Length(3),r_Length(4)])*...
reshape(Y1{5}(:,i_5,:),[r_Length(4),r_Length(5)])*Y1{6}(:,i_6))^2;
end
end
end
end
end
end

MSE(1,ii_11)=MSE_CA_N/MSE_CA_D;
MSE1(1,ii_11)=MSE_CA_N1/MSE_CA_D;
end

%% Given a full tensor %Full tensor %7-order
%
for ii_11=1:NumberofIterations

n_TT = [2, 2, 2, 2, 2, 2, 2];%the unmber of n_TT equals to d_TT
d_TT=7;
r_TT=[1,2,2,2,2,2,2,1];%the unmber of rank=d_TT+1,rank_0=1,rank_N=1,we choose other positions
A_low_rank_TT_Tensor=tt_random(n_TT,d_TT,r_TT);
A_low_rank_TT_Tensor_vector=full(A_low_rank_TT_Tensor);
A=reshape(A_low_rank_TT_Tensor_vector,n_TT); %From TT-Tensor to original Tensor
B=reshape(A,[2,2^(d_TT-1)]);
B_value=norm(B,'fro');
A=A/B_value;
%
LowRankError_Tensor=randn(2, 2, 2, 2, 2, 2,2);
C=reshape(LowRankError_Tensor,[2,2^(d_TT-1)]);
C_value=norm(C,'fro');
LowRankError_Tensor=LowRankError_Tensor/C_value;
%
MeasurementError_Tensor=zeros(n_TT);
for i_1=1:n_TT(1);
for i_2=1:n_TT(2);
for i_3=1:n_TT(3);
for i_4=1:n_TT(4);
for i_5=1:n_TT(5);
for i_6=1:n_TT(6);
for i_7=1:n_TT(7);    
MeasurementError_Tensor(i_1,i_2,i_3,i_4,i_5,i_6,i_7)=mu_set*randn(1,1)/sqrt((d_TT-2)*8+2*4-4);
end
end
end
end
end
end
end
%

nswp=100; % Maximum Number of iterations
eta=eta_set;
Length_r_max=Length_r_max_design;% Estimated rank =Length_r_max-1

%
B=A+eta*LowRankError_Tensor;
C=B+MeasurementError_Tensor;
fun = @(ind) C(ind(1), ind(2), ind(3), ind(4), ind(5), ind(6), ind(7) );
[y,Jyl,Jyr,ilocl,ilocr,evalcnt,Error_final]=greedy2_cross_Version_ZhenQin1(n_TT, fun, 1e-15, nswp, Length_r_max, []);

% Using Tau to truncate the diagonal matrix of SVD
tau=0;
tau1=Tau_design;
r_Length=zeros(length(ilocl)-2,1);
for iii=1:length(ilocl)-2
    r_Length(iii)=length(ilocl{iii+1});
end
Tensor=C;

[Y]=AddingTau(ilocl,ilocr,Tensor,n_TT,r_Length,tau);
[Y1]=AddingTau(ilocl,ilocr,Tensor,n_TT,r_Length,tau1);



MSE_CA_N=0;
MSE_CA_N1=0;
MSE_CA_D=0;
for i_1=1:n_TT(1);
for i_2=1:n_TT(2);
for i_3=1:n_TT(3);
for i_4=1:n_TT(4);
for i_5=1:n_TT(5);
for i_6=1:n_TT(6);
for i_7=1:n_TT(7);
%
MSE_CA_D=MSE_CA_D+B(i_1,i_2,i_3,i_4,i_5,i_6,i_7)^2;
%
MSE_CA_N=MSE_CA_N+(B(i_1,i_2,i_3,i_4,i_5,i_6,i_7)-Y{1}(i_1,:)*reshape(Y{2}(:,i_2,:),[r_Length(1),r_Length(2)])*...
reshape(Y{3}(:,i_3,:),[r_Length(2),r_Length(3)])*reshape(Y{4}(:,i_4,:),[r_Length(3),r_Length(4)])*...
reshape(Y{5}(:,i_5,:),[r_Length(4),r_Length(5)])*reshape(Y{6}(:,i_6,:),[r_Length(5),r_Length(6)])*Y{7}(:,i_7))^2;
%
MSE_CA_N1=MSE_CA_N1+(B(i_1,i_2,i_3,i_4,i_5,i_6,i_7)-Y1{1}(i_1,:)*reshape(Y1{2}(:,i_2,:),[r_Length(1),r_Length(2)])*...
reshape(Y1{3}(:,i_3,:),[r_Length(2),r_Length(3)])*reshape(Y1{4}(:,i_4,:),[r_Length(3),r_Length(4)])*...
reshape(Y1{5}(:,i_5,:),[r_Length(4),r_Length(5)])*reshape(Y1{6}(:,i_6,:),[r_Length(5),r_Length(6)])*Y1{7}(:,i_7))^2;
end
end
end
end
end
end
end

MSE(2,ii_11)=MSE_CA_N/MSE_CA_D;
MSE1(2,ii_11)=MSE_CA_N1/MSE_CA_D;

end

%% Given a full tensor %Full tensor %8-order

%
for ii_11=1:NumberofIterations

n_TT = [2, 2, 2, 2, 2, 2, 2, 2];%the unmber of n_TT equals to d_TT
d_TT=8;
r_TT=[1,2,2,2,2,2,2,2,1];%the unmber of rank=d_TT+1,rank_0=1,rank_N=1,we choose other positions
A_low_rank_TT_Tensor=tt_random(n_TT,d_TT,r_TT);
A_low_rank_TT_Tensor_vector=full(A_low_rank_TT_Tensor);
A=reshape(A_low_rank_TT_Tensor_vector,n_TT); %From TT-Tensor to original Tensor
B=reshape(A,[2,2^(d_TT-1)]);
B_value=norm(B,'fro');
A=A/B_value;
%
LowRankError_Tensor=randn(2, 2, 2, 2, 2, 2,2,2);
C=reshape(LowRankError_Tensor,[2,2^(d_TT-1)]);
C_value=norm(C,'fro');
LowRankError_Tensor=LowRankError_Tensor/C_value;
%
MeasurementError_Tensor=zeros(n_TT);
for i_1=1:n_TT(1);
for i_2=1:n_TT(2);
for i_3=1:n_TT(3);
for i_4=1:n_TT(4);
for i_5=1:n_TT(5);
for i_6=1:n_TT(6);
for i_7=1:n_TT(7);  
for i_8=1:n_TT(8);      
MeasurementError_Tensor(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8)=mu_set*randn(1,1)/sqrt((d_TT-2)*8+2*4-4);
end
end
end
end
end
end
end
end
%

nswp=100; % Maximum Number of iterations
eta=eta_set;
Length_r_max=Length_r_max_design;% Estimated rank =Length_r_max-1

%
B=A+eta*LowRankError_Tensor;
C=B+MeasurementError_Tensor;
fun = @(ind) C(ind(1), ind(2), ind(3), ind(4), ind(5), ind(6), ind(7), ind(8) );
[y,Jyl,Jyr,ilocl,ilocr,evalcnt,Error_final]=greedy2_cross_Version_ZhenQin1(n_TT, fun, 1e-15, nswp, Length_r_max, []);

% Using Tau to truncate the diagonal matrix of SVD
tau=0;
tau1=Tau_design;
r_Length=zeros(length(ilocl)-2,1);
for iii=1:length(ilocl)-2
    r_Length(iii)=length(ilocl{iii+1});
end
Tensor=C;

[Y]=AddingTau(ilocl,ilocr,Tensor,n_TT,r_Length,tau);
[Y1]=AddingTau(ilocl,ilocr,Tensor,n_TT,r_Length,tau1);



MSE_CA_N=0;
MSE_CA_N1=0;
MSE_CA_D=0;
for i_1=1:n_TT(1);
for i_2=1:n_TT(2);
for i_3=1:n_TT(3);
for i_4=1:n_TT(4);
for i_5=1:n_TT(5);
for i_6=1:n_TT(6);
for i_7=1:n_TT(7);
for i_8=1:n_TT(8);
%
MSE_CA_D=MSE_CA_D+B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8)^2;
%
MSE_CA_N=MSE_CA_N+(B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8)-Y{1}(i_1,:)*reshape(Y{2}(:,i_2,:),[r_Length(1),r_Length(2)])*...
reshape(Y{3}(:,i_3,:),[r_Length(2),r_Length(3)])*reshape(Y{4}(:,i_4,:),[r_Length(3),r_Length(4)])*...
reshape(Y{5}(:,i_5,:),[r_Length(4),r_Length(5)])*reshape(Y{6}(:,i_6,:),[r_Length(5),r_Length(6)])*...
reshape(Y{7}(:,i_7,:),[r_Length(6),r_Length(7)])*Y{8}(:,i_8))^2;
%
MSE_CA_N1=MSE_CA_N1+(B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8)-Y1{1}(i_1,:)*reshape(Y1{2}(:,i_2,:),[r_Length(1),r_Length(2)])*...
reshape(Y1{3}(:,i_3,:),[r_Length(2),r_Length(3)])*reshape(Y1{4}(:,i_4,:),[r_Length(3),r_Length(4)])*...
reshape(Y1{5}(:,i_5,:),[r_Length(4),r_Length(5)])*reshape(Y1{6}(:,i_6,:),[r_Length(5),r_Length(6)])*...
reshape(Y1{7}(:,i_7,:),[r_Length(6),r_Length(7)])*Y1{8}(:,i_8))^2;
end
end
end
end
end
end
end
end

MSE(3,ii_11)=MSE_CA_N/MSE_CA_D;
MSE1(3,ii_11)=MSE_CA_N1/MSE_CA_D;

end
%% Given a full tensor %Full tensor %9-order

for ii_11=1:NumberofIterations
%
n_TT = [2, 2, 2, 2, 2, 2, 2, 2,2];%the unmber of n_TT equals to d_TT
d_TT=9;
r_TT=[1,2,2,2,2,2,2,2,2,1];%the unmber of rank=d_TT+1,rank_0=1,rank_N=1,we choose other positions
A_low_rank_TT_Tensor=tt_random(n_TT,d_TT,r_TT);
A_low_rank_TT_Tensor_vector=full(A_low_rank_TT_Tensor);
A=reshape(A_low_rank_TT_Tensor_vector,n_TT); %From TT-Tensor to original Tensor
B=reshape(A,[2,2^(d_TT-1)]);
B_value=norm(B,'fro');
A=A/B_value;
%
LowRankError_Tensor=randn(2, 2, 2, 2, 2, 2,2,2,2);
C=reshape(LowRankError_Tensor,[2,2^(d_TT-1)]);
C_value=norm(C,'fro');
LowRankError_Tensor=LowRankError_Tensor/C_value;
%
MeasurementError_Tensor=zeros(n_TT);
for i_1=1:n_TT(1);
for i_2=1:n_TT(2);
for i_3=1:n_TT(3);
for i_4=1:n_TT(4);
for i_5=1:n_TT(5);
for i_6=1:n_TT(6);
for i_7=1:n_TT(7);  
for i_8=1:n_TT(8);   
for i_9=1:n_TT(9);  
MeasurementError_Tensor(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9)=mu_set*randn(1,1)/sqrt((d_TT-2)*8+2*4-4);
end
end
end
end
end
end
end
end
end
%

nswp=100; % Maximum Number of iterations
eta=eta_set;
Length_r_max=Length_r_max_design;% Estimated rank =Length_r_max-1

%
B=A+eta*LowRankError_Tensor;
C=B+MeasurementError_Tensor;
fun = @(ind) C(ind(1), ind(2), ind(3), ind(4), ind(5), ind(6), ind(7), ind(8), ind(9) );
[y,Jyl,Jyr,ilocl,ilocr,evalcnt,Error_final]=greedy2_cross_Version_ZhenQin1(n_TT, fun, 1e-15, nswp, Length_r_max, []);

% Using Tau to truncate the diagonal matrix of SVD
tau=0;
tau1=Tau_design;
r_Length=zeros(length(ilocl)-2,1);
for iii=1:length(ilocl)-2
    r_Length(iii)=length(ilocl{iii+1});
end
Tensor=C;

[Y]=AddingTau(ilocl,ilocr,Tensor,n_TT,r_Length,tau);
[Y1]=AddingTau(ilocl,ilocr,Tensor,n_TT,r_Length,tau1);



MSE_CA_N=0;
MSE_CA_N1=0;
MSE_CA_D=0;
for i_1=1:n_TT(1);
for i_2=1:n_TT(2);
for i_3=1:n_TT(3);
for i_4=1:n_TT(4);
for i_5=1:n_TT(5);
for i_6=1:n_TT(6);
for i_7=1:n_TT(7);
for i_8=1:n_TT(8);
for i_9=1:n_TT(9);
%
MSE_CA_D=MSE_CA_D+B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9)^2;
%
MSE_CA_N=MSE_CA_N+(B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9)-Y{1}(i_1,:)*reshape(Y{2}(:,i_2,:),[r_Length(1),r_Length(2)])*...
reshape(Y{3}(:,i_3,:),[r_Length(2),r_Length(3)])*reshape(Y{4}(:,i_4,:),[r_Length(3),r_Length(4)])*...
reshape(Y{5}(:,i_5,:),[r_Length(4),r_Length(5)])*reshape(Y{6}(:,i_6,:),[r_Length(5),r_Length(6)])*...
reshape(Y{7}(:,i_7,:),[r_Length(6),r_Length(7)])*reshape(Y{8}(:,i_8,:),[r_Length(7),r_Length(8)])*Y{9}(:,i_9))^2;
%
MSE_CA_N1=MSE_CA_N1+(B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9)-Y1{1}(i_1,:)*reshape(Y1{2}(:,i_2,:),[r_Length(1),r_Length(2)])*...
reshape(Y1{3}(:,i_3,:),[r_Length(2),r_Length(3)])*reshape(Y1{4}(:,i_4,:),[r_Length(3),r_Length(4)])*...
reshape(Y1{5}(:,i_5,:),[r_Length(4),r_Length(5)])*reshape(Y1{6}(:,i_6,:),[r_Length(5),r_Length(6)])*...
reshape(Y1{7}(:,i_7,:),[r_Length(6),r_Length(7)])*reshape(Y1{8}(:,i_8,:),[r_Length(7),r_Length(8)])*Y1{9}(:,i_9))^2;
end
end
end
end
end
end
end
end
end

MSE(4,ii_11)=MSE_CA_N/MSE_CA_D;
MSE1(4,ii_11)=MSE_CA_N1/MSE_CA_D;

end

%% Given a full tensor %Full tensor %10-order

for ii_11=1:NumberofIterations
%
n_TT = [2, 2, 2, 2, 2, 2, 2, 2,2,2];%the unmber of n_TT equals to d_TT
d_TT=10;
r_TT=[1,2,2,2,2,2,2,2,2,2,1];%the unmber of rank=d_TT+1,rank_0=1,rank_N=1,we choose other positions
A_low_rank_TT_Tensor=tt_random(n_TT,d_TT,r_TT);
A_low_rank_TT_Tensor_vector=full(A_low_rank_TT_Tensor);
A=reshape(A_low_rank_TT_Tensor_vector,n_TT); %From TT-Tensor to original Tensor
B=reshape(A,[2,2^(d_TT-1)]);
B_value=norm(B,'fro');
A=A/B_value;
%
LowRankError_Tensor=randn(2, 2, 2, 2, 2, 2,2,2,2,2);
C=reshape(LowRankError_Tensor,[2,2^(d_TT-1)]);
C_value=norm(C,'fro');
LowRankError_Tensor=LowRankError_Tensor/C_value;
%
MeasurementError_Tensor=zeros(n_TT);
for i_1=1:n_TT(1);
for i_2=1:n_TT(2);
for i_3=1:n_TT(3);
for i_4=1:n_TT(4);
for i_5=1:n_TT(5);
for i_6=1:n_TT(6);
for i_7=1:n_TT(7);  
for i_8=1:n_TT(8);   
for i_9=1:n_TT(9);  
for i_10=1:n_TT(10);  
MeasurementError_Tensor(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10)=mu_set*randn(1,1)/sqrt((d_TT-2)*8+2*4-4);
end
end
end
end
end
end
end
end
end
end
%

nswp=100; % Maximum Number of iterations
eta=eta_set;
Length_r_max=Length_r_max_design;% Estimated rank =Length_r_max-1

%
B=A+eta*LowRankError_Tensor;
C=B+MeasurementError_Tensor;
fun = @(ind) C(ind(1), ind(2), ind(3), ind(4), ind(5), ind(6), ind(7), ind(8), ind(9), ind(10) );
[y,Jyl,Jyr,ilocl,ilocr,evalcnt,Error_final]=greedy2_cross_Version_ZhenQin1(n_TT, fun, 1e-15, nswp, Length_r_max, []);

% Using Tau to truncate the diagonal matrix of SVD
tau=0;
tau1=Tau_design;
r_Length=zeros(length(ilocl)-2,1);
for iii=1:length(ilocl)-2
    r_Length(iii)=length(ilocl{iii+1});
end
Tensor=C;

[Y]=AddingTau(ilocl,ilocr,Tensor,n_TT,r_Length,tau);
[Y1]=AddingTau(ilocl,ilocr,Tensor,n_TT,r_Length,tau1);



MSE_CA_N=0;
MSE_CA_N1=0;
MSE_CA_D=0;
for i_1=1:n_TT(1);
for i_2=1:n_TT(2);
for i_3=1:n_TT(3);
for i_4=1:n_TT(4);
for i_5=1:n_TT(5);
for i_6=1:n_TT(6);
for i_7=1:n_TT(7);
for i_8=1:n_TT(8);
for i_9=1:n_TT(9);
for i_10=1:n_TT(10);
%
MSE_CA_D=MSE_CA_D+B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10)^2;
%
MSE_CA_N=MSE_CA_N+(B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10)-Y{1}(i_1,:)*reshape(Y{2}(:,i_2,:),[r_Length(1),r_Length(2)])*...
reshape(Y{3}(:,i_3,:),[r_Length(2),r_Length(3)])*reshape(Y{4}(:,i_4,:),[r_Length(3),r_Length(4)])*...
reshape(Y{5}(:,i_5,:),[r_Length(4),r_Length(5)])*reshape(Y{6}(:,i_6,:),[r_Length(5),r_Length(6)])*...
reshape(Y{7}(:,i_7,:),[r_Length(6),r_Length(7)])*reshape(Y{8}(:,i_8,:),[r_Length(7),r_Length(8)])*...
reshape(Y{9}(:,i_9,:),[r_Length(8),r_Length(9)])*Y{10}(:,i_10))^2;
%
MSE_CA_N1=MSE_CA_N1+(B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10)-Y1{1}(i_1,:)*reshape(Y1{2}(:,i_2,:),[r_Length(1),r_Length(2)])*...
reshape(Y1{3}(:,i_3,:),[r_Length(2),r_Length(3)])*reshape(Y1{4}(:,i_4,:),[r_Length(3),r_Length(4)])*...
reshape(Y1{5}(:,i_5,:),[r_Length(4),r_Length(5)])*reshape(Y1{6}(:,i_6,:),[r_Length(5),r_Length(6)])*...
reshape(Y1{7}(:,i_7,:),[r_Length(6),r_Length(7)])*reshape(Y1{8}(:,i_8,:),[r_Length(7),r_Length(8)])*...
reshape(Y1{9}(:,i_9,:),[r_Length(8),r_Length(9)])*Y1{10}(:,i_10))^2;
end
end
end
end
end
end
end
end
end
end

MSE(5,ii_11)=MSE_CA_N/MSE_CA_D;
MSE1(5,ii_11)=MSE_CA_N1/MSE_CA_D;

end

%% Given a full tensor %Full tensor %11-order

for ii_11=1:NumberofIterations

n_TT = [2, 2, 2, 2, 2, 2, 2, 2,2,2,2];%the unmber of n_TT equals to d_TT
d_TT=11;
r_TT=[1,2,2,2,2,2,2,2,2,2,2,1];%the unmber of rank=d_TT+1,rank_0=1,rank_N=1,we choose other positions
A_low_rank_TT_Tensor=tt_random(n_TT,d_TT,r_TT);
A_low_rank_TT_Tensor_vector=full(A_low_rank_TT_Tensor);
A=reshape(A_low_rank_TT_Tensor_vector,n_TT); %From TT-Tensor to original Tensor
B=reshape(A,[2,2^(d_TT-1)]);
B_value=norm(B,'fro');
A=A/B_value;
%
LowRankError_Tensor=randn(2, 2, 2, 2, 2, 2,2,2,2,2,2);
C=reshape(LowRankError_Tensor,[2,2^(d_TT-1)]);
C_value=norm(C,'fro');
LowRankError_Tensor=LowRankError_Tensor/C_value;
%
MeasurementError_Tensor=zeros(n_TT);
for i_1=1:n_TT(1);
for i_2=1:n_TT(2);
for i_3=1:n_TT(3);
for i_4=1:n_TT(4);
for i_5=1:n_TT(5);
for i_6=1:n_TT(6);
for i_7=1:n_TT(7);  
for i_8=1:n_TT(8);   
for i_9=1:n_TT(9);  
for i_10=1:n_TT(10);  
for i_11=1:n_TT(11);  
MeasurementError_Tensor(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11)=mu_set*randn(1,1)/sqrt((d_TT-2)*8+2*4-4);
end
end
end
end
end
end
end
end
end
end
end
%

nswp=100; % Maximum Number of iterations
eta=eta_set;
Length_r_max=Length_r_max_design;% Estimated rank =Length_r_max-1

%
B=A+eta*LowRankError_Tensor;
C=B+MeasurementError_Tensor;
fun = @(ind) C(ind(1), ind(2), ind(3), ind(4), ind(5), ind(6), ind(7), ind(8), ind(9), ind(10), ind(11) );
[y,Jyl,Jyr,ilocl,ilocr,evalcnt,Error_final]=greedy2_cross_Version_ZhenQin1(n_TT, fun, 1e-15, nswp, Length_r_max, []);

% Using Tau to truncate the diagonal matrix of SVD
tau=0;
tau1=Tau_design;
r_Length=zeros(length(ilocl)-2,1);
for iii=1:length(ilocl)-2
    r_Length(iii)=length(ilocl{iii+1});
end
Tensor=C;

[Y]=AddingTau(ilocl,ilocr,Tensor,n_TT,r_Length,tau);
[Y1]=AddingTau(ilocl,ilocr,Tensor,n_TT,r_Length,tau1);



MSE_CA_N=0;
MSE_CA_N1=0;
MSE_CA_D=0;
for i_1=1:n_TT(1);
for i_2=1:n_TT(2);
for i_3=1:n_TT(3);
for i_4=1:n_TT(4);
for i_5=1:n_TT(5);
for i_6=1:n_TT(6);
for i_7=1:n_TT(7);
for i_8=1:n_TT(8);
for i_9=1:n_TT(9);
for i_10=1:n_TT(10);
for i_11=1:n_TT(11);
%
MSE_CA_D=MSE_CA_D+B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11)^2;
%
MSE_CA_N=MSE_CA_N+(B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11)-Y{1}(i_1,:)*reshape(Y{2}(:,i_2,:),[r_Length(1),r_Length(2)])*...
reshape(Y{3}(:,i_3,:),[r_Length(2),r_Length(3)])*reshape(Y{4}(:,i_4,:),[r_Length(3),r_Length(4)])*...
reshape(Y{5}(:,i_5,:),[r_Length(4),r_Length(5)])*reshape(Y{6}(:,i_6,:),[r_Length(5),r_Length(6)])*...
reshape(Y{7}(:,i_7,:),[r_Length(6),r_Length(7)])*reshape(Y{8}(:,i_8,:),[r_Length(7),r_Length(8)])*...
reshape(Y{9}(:,i_9,:),[r_Length(8),r_Length(9)])*reshape(Y{10}(:,i_10,:),[r_Length(9),r_Length(10)])*Y{11}(:,i_11))^2;
%
MSE_CA_N1=MSE_CA_N1+(B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11)-Y1{1}(i_1,:)*reshape(Y1{2}(:,i_2,:),[r_Length(1),r_Length(2)])*...
reshape(Y1{3}(:,i_3,:),[r_Length(2),r_Length(3)])*reshape(Y1{4}(:,i_4,:),[r_Length(3),r_Length(4)])*...
reshape(Y1{5}(:,i_5,:),[r_Length(4),r_Length(5)])*reshape(Y1{6}(:,i_6,:),[r_Length(5),r_Length(6)])*...
reshape(Y1{7}(:,i_7,:),[r_Length(6),r_Length(7)])*reshape(Y1{8}(:,i_8,:),[r_Length(7),r_Length(8)])*...
reshape(Y1{9}(:,i_9,:),[r_Length(8),r_Length(9)])*reshape(Y1{10}(:,i_10,:),[r_Length(9),r_Length(10)])*Y1{11}(:,i_11))^2;
end
end
end
end
end
end
end
end
end
end
end

MSE(6,ii_11)=MSE_CA_N/MSE_CA_D;
MSE1(6,ii_11)=MSE_CA_N1/MSE_CA_D;

end

%% Given a full tensor %Full tensor %12-order

%
for ii_11=1:NumberofIterations
    
n_TT = [2, 2, 2, 2, 2, 2, 2, 2,2,2,2,2];%the unmber of n_TT equals to d_TT
d_TT=12;
r_TT=[1,2,2,2,2,2,2,2,2,2,2,2,1];%the unmber of rank=d_TT+1,rank_0=1,rank_N=1,we choose other positions
A_low_rank_TT_Tensor=tt_random(n_TT,d_TT,r_TT);
A_low_rank_TT_Tensor_vector=full(A_low_rank_TT_Tensor);
A=reshape(A_low_rank_TT_Tensor_vector,n_TT); %From TT-Tensor to original Tensor
B=reshape(A,[2,2^(d_TT-1)]);
B_value=norm(B,'fro');
A=A/B_value;
%
LowRankError_Tensor=randn(2, 2, 2, 2, 2, 2,2,2,2,2,2,2);
C=reshape(LowRankError_Tensor,[2,2^(d_TT-1)]);
C_value=norm(C,'fro');
LowRankError_Tensor=LowRankError_Tensor/C_value;
%
MeasurementError_Tensor=zeros(n_TT);
for i_1=1:n_TT(1);
for i_2=1:n_TT(2);
for i_3=1:n_TT(3);
for i_4=1:n_TT(4);
for i_5=1:n_TT(5);
for i_6=1:n_TT(6);
for i_7=1:n_TT(7);  
for i_8=1:n_TT(8);   
for i_9=1:n_TT(9);  
for i_10=1:n_TT(10);  
for i_11=1:n_TT(11);  
for i_12=1:n_TT(12);  
MeasurementError_Tensor(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12)=mu_set*randn(1,1)/sqrt((d_TT-2)*8+2*4-4);
end
end
end
end
end
end
end
end
end
end
end
end
%

nswp=100; % Maximum Number of iterations
eta=eta_set;
Length_r_max=Length_r_max_design;% Estimated rank =Length_r_max-1

%
B=A+eta*LowRankError_Tensor;
C=B+MeasurementError_Tensor;
fun = @(ind) C(ind(1), ind(2), ind(3), ind(4), ind(5), ind(6), ind(7), ind(8), ind(9), ind(10), ind(11), ind(12) );
[y,Jyl,Jyr,ilocl,ilocr,evalcnt,Error_final]=greedy2_cross_Version_ZhenQin1(n_TT, fun, 1e-15, nswp, Length_r_max, []);

% Using Tau to truncate the diagonal matrix of SVD
tau=0;
tau1=Tau_design;
r_Length=zeros(length(ilocl)-2,1);
for iii=1:length(ilocl)-2
    r_Length(iii)=length(ilocl{iii+1});
end
Tensor=C;

[Y]=AddingTau(ilocl,ilocr,Tensor,n_TT,r_Length,tau);
[Y1]=AddingTau(ilocl,ilocr,Tensor,n_TT,r_Length,tau1);



MSE_CA_N=0;
MSE_CA_N1=0;
MSE_CA_D=0;
for i_1=1:n_TT(1);
for i_2=1:n_TT(2);
for i_3=1:n_TT(3);
for i_4=1:n_TT(4);
for i_5=1:n_TT(5);
for i_6=1:n_TT(6);
for i_7=1:n_TT(7);
for i_8=1:n_TT(8);
for i_9=1:n_TT(9);
for i_10=1:n_TT(10);
for i_11=1:n_TT(11);
for i_12=1:n_TT(12);
%
MSE_CA_D=MSE_CA_D+B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12)^2;
%
MSE_CA_N=MSE_CA_N+(B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12)-Y{1}(i_1,:)*reshape(Y{2}(:,i_2,:),[r_Length(1),r_Length(2)])*...
reshape(Y{3}(:,i_3,:),[r_Length(2),r_Length(3)])*reshape(Y{4}(:,i_4,:),[r_Length(3),r_Length(4)])*...
reshape(Y{5}(:,i_5,:),[r_Length(4),r_Length(5)])*reshape(Y{6}(:,i_6,:),[r_Length(5),r_Length(6)])*...
reshape(Y{7}(:,i_7,:),[r_Length(6),r_Length(7)])*reshape(Y{8}(:,i_8,:),[r_Length(7),r_Length(8)])*...
reshape(Y{9}(:,i_9,:),[r_Length(8),r_Length(9)])*reshape(Y{10}(:,i_10,:),[r_Length(9),r_Length(10)])*...
reshape(Y{11}(:,i_11,:),[r_Length(10),r_Length(11)])*Y{12}(:,i_12))^2;
%
MSE_CA_N1=MSE_CA_N1+(B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12)-Y1{1}(i_1,:)*reshape(Y1{2}(:,i_2,:),[r_Length(1),r_Length(2)])*...
reshape(Y1{3}(:,i_3,:),[r_Length(2),r_Length(3)])*reshape(Y1{4}(:,i_4,:),[r_Length(3),r_Length(4)])*...
reshape(Y1{5}(:,i_5,:),[r_Length(4),r_Length(5)])*reshape(Y1{6}(:,i_6,:),[r_Length(5),r_Length(6)])*...
reshape(Y1{7}(:,i_7,:),[r_Length(6),r_Length(7)])*reshape(Y1{8}(:,i_8,:),[r_Length(7),r_Length(8)])*...
reshape(Y1{9}(:,i_9,:),[r_Length(8),r_Length(9)])*reshape(Y1{10}(:,i_10,:),[r_Length(9),r_Length(10)])*...
reshape(Y1{11}(:,i_11,:),[r_Length(10),r_Length(11)])*Y1{12}(:,i_12))^2;
end
end
end
end
end
end
end
end
end
end
end
end

MSE(7,ii_11)=MSE_CA_N/MSE_CA_D;
MSE1(7,ii_11)=MSE_CA_N1/MSE_CA_D;


end

%% Given a full tensor %Full tensor %13-order


for ii_11=1:NumberofIterations

%
n_TT = [2, 2, 2, 2, 2, 2, 2, 2,2,2,2,2,2];%the unmber of n_TT equals to d_TT
d_TT=13;
r_TT=[1,2,2,2,2,2,2,2,2,2,2,2,2,1];%the unmber of rank=d_TT+1,rank_0=1,rank_N=1,we choose other positions
A_low_rank_TT_Tensor=tt_random(n_TT,d_TT,r_TT);
A_low_rank_TT_Tensor_vector=full(A_low_rank_TT_Tensor);
A=reshape(A_low_rank_TT_Tensor_vector,n_TT); %From TT-Tensor to original Tensor
B=reshape(A,[2,2^(d_TT-1)]);
B_value=norm(B,'fro');
A=A/B_value;
%
LowRankError_Tensor=randn(2, 2, 2, 2, 2, 2,2,2,2,2,2,2,2);
C=reshape(LowRankError_Tensor,[2,2^(d_TT-1)]);
C_value=norm(C,'fro');
LowRankError_Tensor=LowRankError_Tensor/C_value;
%
MeasurementError_Tensor=zeros(n_TT);
for i_1=1:n_TT(1);
for i_2=1:n_TT(2);
for i_3=1:n_TT(3);
for i_4=1:n_TT(4);
for i_5=1:n_TT(5);
for i_6=1:n_TT(6);
for i_7=1:n_TT(7);  
for i_8=1:n_TT(8);   
for i_9=1:n_TT(9);  
for i_10=1:n_TT(10);  
for i_11=1:n_TT(11);  
for i_12=1:n_TT(12);  
for i_13=1:n_TT(13); 
MeasurementError_Tensor(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12,i_13)=mu_set*randn(1,1)/sqrt((d_TT-2)*8+2*4-4);
end
end
end
end
end
end
end
end
end
end
end
end
end
%

nswp=100; % Maximum Number of iterations
eta=eta_set;
Length_r_max=Length_r_max_design;% Estimated rank =Length_r_max-1

%
B=A+eta*LowRankError_Tensor;
C=B+MeasurementError_Tensor;
fun = @(ind) C(ind(1), ind(2), ind(3), ind(4), ind(5), ind(6), ind(7), ind(8), ind(9), ind(10), ind(11), ind(12), ind(13) );
[y,Jyl,Jyr,ilocl,ilocr,evalcnt,Error_final]=greedy2_cross_Version_ZhenQin1(n_TT, fun, 1e-15, nswp, Length_r_max, []);

% Using Tau to truncate the diagonal matrix of SVD
tau=0;
tau1=Tau_design;
r_Length=zeros(length(ilocl)-2,1);
for iii=1:length(ilocl)-2
    r_Length(iii)=length(ilocl{iii+1});
end
Tensor=C;

[Y]=AddingTau(ilocl,ilocr,Tensor,n_TT,r_Length,tau);
[Y1]=AddingTau(ilocl,ilocr,Tensor,n_TT,r_Length,tau1);



MSE_CA_N=0;
MSE_CA_N1=0;
MSE_CA_D=0;
for i_1=1:n_TT(1);
for i_2=1:n_TT(2);
for i_3=1:n_TT(3);
for i_4=1:n_TT(4);
for i_5=1:n_TT(5);
for i_6=1:n_TT(6);
for i_7=1:n_TT(7);
for i_8=1:n_TT(8);
for i_9=1:n_TT(9);
for i_10=1:n_TT(10);
for i_11=1:n_TT(11);
for i_12=1:n_TT(12);
for i_13=1:n_TT(13);
%
MSE_CA_D=MSE_CA_D+B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12,i_13)^2;
%
MSE_CA_N=MSE_CA_N+(B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12,i_13)-Y{1}(i_1,:)*reshape(Y{2}(:,i_2,:),[r_Length(1),r_Length(2)])*...
reshape(Y{3}(:,i_3,:),[r_Length(2),r_Length(3)])*reshape(Y{4}(:,i_4,:),[r_Length(3),r_Length(4)])*...
reshape(Y{5}(:,i_5,:),[r_Length(4),r_Length(5)])*reshape(Y{6}(:,i_6,:),[r_Length(5),r_Length(6)])*...
reshape(Y{7}(:,i_7,:),[r_Length(6),r_Length(7)])*reshape(Y{8}(:,i_8,:),[r_Length(7),r_Length(8)])*...
reshape(Y{9}(:,i_9,:),[r_Length(8),r_Length(9)])*reshape(Y{10}(:,i_10,:),[r_Length(9),r_Length(10)])*...
reshape(Y{11}(:,i_11,:),[r_Length(10),r_Length(11)])*reshape(Y{12}(:,i_12,:),[r_Length(11),r_Length(12)])*Y{13}(:,i_13))^2;
%
MSE_CA_N1=MSE_CA_N1+(B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12,i_13)-Y1{1}(i_1,:)*reshape(Y1{2}(:,i_2,:),[r_Length(1),r_Length(2)])*...
reshape(Y1{3}(:,i_3,:),[r_Length(2),r_Length(3)])*reshape(Y1{4}(:,i_4,:),[r_Length(3),r_Length(4)])*...
reshape(Y1{5}(:,i_5,:),[r_Length(4),r_Length(5)])*reshape(Y1{6}(:,i_6,:),[r_Length(5),r_Length(6)])*...
reshape(Y1{7}(:,i_7,:),[r_Length(6),r_Length(7)])*reshape(Y1{8}(:,i_8,:),[r_Length(7),r_Length(8)])*...
reshape(Y1{9}(:,i_9,:),[r_Length(8),r_Length(9)])*reshape(Y1{10}(:,i_10,:),[r_Length(9),r_Length(10)])*...
reshape(Y1{11}(:,i_11,:),[r_Length(10),r_Length(11)])*reshape(Y1{12}(:,i_12,:),[r_Length(11),r_Length(12)])*Y1{13}(:,i_13))^2;
end
end
end
end
end
end
end
end
end
end
end
end
end

MSE(8,ii_11)=MSE_CA_N/MSE_CA_D;
MSE1(8,ii_11)=MSE_CA_N1/MSE_CA_D;

end

%% Given a full tensor %Full tensor %14-order
%
for ii_11=1:NumberofIterations

n_TT = [2, 2, 2, 2, 2, 2, 2, 2,2,2,2,2,2,2];%the unmber of n_TT equals to d_TT
d_TT=14;
r_TT=[1,2,2,2,2,2,2,2,2,2,2,2,2,2,1];%the unmber of rank=d_TT+1,rank_0=1,rank_N=1,we choose other positions
A_low_rank_TT_Tensor=tt_random(n_TT,d_TT,r_TT);
A_low_rank_TT_Tensor_vector=full(A_low_rank_TT_Tensor);
A=reshape(A_low_rank_TT_Tensor_vector,n_TT); %From TT-Tensor to original Tensor
B=reshape(A,[2,2^(d_TT-1)]);
B_value=norm(B,'fro');
A=A/B_value;
%
LowRankError_Tensor=randn(2, 2, 2, 2, 2, 2,2,2,2,2,2,2,2,2);
C=reshape(LowRankError_Tensor,[2,2^(d_TT-1)]);
C_value=norm(C,'fro');
LowRankError_Tensor=LowRankError_Tensor/C_value;
%
MeasurementError_Tensor=zeros(n_TT);
for i_1=1:n_TT(1);
for i_2=1:n_TT(2);
for i_3=1:n_TT(3);
for i_4=1:n_TT(4);
for i_5=1:n_TT(5);
for i_6=1:n_TT(6);
for i_7=1:n_TT(7);  
for i_8=1:n_TT(8);   
for i_9=1:n_TT(9);  
for i_10=1:n_TT(10);  
for i_11=1:n_TT(11);  
for i_12=1:n_TT(12);  
for i_13=1:n_TT(13); 
for i_14=1:n_TT(14); 
MeasurementError_Tensor(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12,i_13,i_14)=mu_set*randn(1,1)/sqrt((d_TT-2)*8+2*4-4);
end
end
end
end
end
end
end
end
end
end
end
end
end
end
%

nswp=100; % Maximum Number of iterations
eta=eta_set;
Length_r_max=Length_r_max_design;% Estimated rank =Length_r_max-1

%
B=A+eta*LowRankError_Tensor;
C=B+MeasurementError_Tensor;
fun = @(ind) C(ind(1), ind(2), ind(3), ind(4), ind(5), ind(6), ind(7), ind(8), ind(9), ind(10), ind(11), ind(12), ind(13), ind(14) );
[y,Jyl,Jyr,ilocl,ilocr,evalcnt,Error_final]=greedy2_cross_Version_ZhenQin1(n_TT, fun, 1e-15, nswp, Length_r_max, []);

% Using Tau to truncate the diagonal matrix of SVD
tau=0;
tau1=Tau_design;
r_Length=zeros(length(ilocl)-2,1);
for iii=1:length(ilocl)-2
    r_Length(iii)=length(ilocl{iii+1});
end
Tensor=C;

[Y]=AddingTau(ilocl,ilocr,Tensor,n_TT,r_Length,tau);
[Y1]=AddingTau(ilocl,ilocr,Tensor,n_TT,r_Length,tau1);



MSE_CA_N=0;
MSE_CA_N1=0;
MSE_CA_D=0;
for i_1=1:n_TT(1);
for i_2=1:n_TT(2);
for i_3=1:n_TT(3);
for i_4=1:n_TT(4);
for i_5=1:n_TT(5);
for i_6=1:n_TT(6);
for i_7=1:n_TT(7);
for i_8=1:n_TT(8);
for i_9=1:n_TT(9);
for i_10=1:n_TT(10);
for i_11=1:n_TT(11);
for i_12=1:n_TT(12);
for i_13=1:n_TT(13);
for i_14=1:n_TT(14);
%
MSE_CA_D=MSE_CA_D+B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12,i_13,i_14)^2;
%
MSE_CA_N=MSE_CA_N+(B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12,i_13,i_14)-Y{1}(i_1,:)*reshape(Y{2}(:,i_2,:),[r_Length(1),r_Length(2)])*...
reshape(Y{3}(:,i_3,:),[r_Length(2),r_Length(3)])*reshape(Y{4}(:,i_4,:),[r_Length(3),r_Length(4)])*...
reshape(Y{5}(:,i_5,:),[r_Length(4),r_Length(5)])*reshape(Y{6}(:,i_6,:),[r_Length(5),r_Length(6)])*...
reshape(Y{7}(:,i_7,:),[r_Length(6),r_Length(7)])*reshape(Y{8}(:,i_8,:),[r_Length(7),r_Length(8)])*...
reshape(Y{9}(:,i_9,:),[r_Length(8),r_Length(9)])*reshape(Y{10}(:,i_10,:),[r_Length(9),r_Length(10)])*...
reshape(Y{11}(:,i_11,:),[r_Length(10),r_Length(11)])*reshape(Y{12}(:,i_12,:),[r_Length(11),r_Length(12)])*...
reshape(Y{13}(:,i_13,:),[r_Length(12),r_Length(13)])*Y{14}(:,i_14))^2;
%
MSE_CA_N1=MSE_CA_N1+(B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12,i_13,i_14)-Y1{1}(i_1,:)*reshape(Y1{2}(:,i_2,:),[r_Length(1),r_Length(2)])*...
reshape(Y1{3}(:,i_3,:),[r_Length(2),r_Length(3)])*reshape(Y1{4}(:,i_4,:),[r_Length(3),r_Length(4)])*...
reshape(Y1{5}(:,i_5,:),[r_Length(4),r_Length(5)])*reshape(Y1{6}(:,i_6,:),[r_Length(5),r_Length(6)])*...
reshape(Y1{7}(:,i_7,:),[r_Length(6),r_Length(7)])*reshape(Y1{8}(:,i_8,:),[r_Length(7),r_Length(8)])*...
reshape(Y1{9}(:,i_9,:),[r_Length(8),r_Length(9)])*reshape(Y1{10}(:,i_10,:),[r_Length(9),r_Length(10)])*...
reshape(Y1{11}(:,i_11,:),[r_Length(10),r_Length(11)])*reshape(Y1{12}(:,i_12,:),[r_Length(11),r_Length(12)])*...
reshape(Y1{13}(:,i_13,:),[r_Length(12),r_Length(13)])*Y1{14}(:,i_14))^2;
end
end
end
end
end
end
end
end
end
end
end
end
end
end

MSE(9,ii_11)=MSE_CA_N/MSE_CA_D;
MSE1(9,ii_11)=MSE_CA_N1/MSE_CA_D;

end

%% Given a full tensor %Full tensor %15-order

%
for ii_11=1:NumberofIterations


n_TT = [2, 2, 2, 2, 2, 2, 2, 2,2,2,2,2,2,2,2];%the unmber of n_TT equals to d_TT
d_TT=15;
r_TT=[1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1];%the unmber of rank=d_TT+1,rank_0=1,rank_N=1,we choose other positions
A_low_rank_TT_Tensor=tt_random(n_TT,d_TT,r_TT);
A_low_rank_TT_Tensor_vector=full(A_low_rank_TT_Tensor);
A=reshape(A_low_rank_TT_Tensor_vector,n_TT); %From TT-Tensor to original Tensor
B=reshape(A,[2,2^(d_TT-1)]);
B_value=norm(B,'fro');
A=A/B_value;
%
LowRankError_Tensor=randn(2, 2, 2, 2, 2, 2,2,2,2,2,2,2,2,2,2);
C=reshape(LowRankError_Tensor,[2,2^(d_TT-1)]);
C_value=norm(C,'fro');
LowRankError_Tensor=LowRankError_Tensor/C_value;
%
MeasurementError_Tensor=zeros(n_TT);
for i_1=1:n_TT(1);
for i_2=1:n_TT(2);
for i_3=1:n_TT(3);
for i_4=1:n_TT(4);
for i_5=1:n_TT(5);
for i_6=1:n_TT(6);
for i_7=1:n_TT(7);  
for i_8=1:n_TT(8);   
for i_9=1:n_TT(9);  
for i_10=1:n_TT(10);  
for i_11=1:n_TT(11);  
for i_12=1:n_TT(12);  
for i_13=1:n_TT(13); 
for i_14=1:n_TT(14); 
for i_15=1:n_TT(15);
MeasurementError_Tensor(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12,i_13,i_14,i_15)=mu_set*randn(1,1)/sqrt((d_TT-2)*8+2*4-4);
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
%

nswp=100; % Maximum Number of iterations
eta=eta_set;
Length_r_max=Length_r_max_design;% Estimated rank =Length_r_max-1

%
B=A+eta*LowRankError_Tensor;
C=B+MeasurementError_Tensor;
fun = @(ind) C(ind(1), ind(2), ind(3), ind(4), ind(5), ind(6), ind(7), ind(8), ind(9), ind(10), ind(11), ind(12), ind(13), ind(14), ind(15) );
[y,Jyl,Jyr,ilocl,ilocr,evalcnt,Error_final]=greedy2_cross_Version_ZhenQin1(n_TT, fun, 1e-15, nswp, Length_r_max, []);

% Using Tau to truncate the diagonal matrix of SVD
tau=0;
tau1=Tau_design;
r_Length=zeros(length(ilocl)-2,1);
for iii=1:length(ilocl)-2
    r_Length(iii)=length(ilocl{iii+1});
end
Tensor=C;

[Y]=AddingTau(ilocl,ilocr,Tensor,n_TT,r_Length,tau);
[Y1]=AddingTau(ilocl,ilocr,Tensor,n_TT,r_Length,tau1);



MSE_CA_N=0;
MSE_CA_N1=0;
MSE_CA_D=0;
for i_1=1:n_TT(1);
for i_2=1:n_TT(2);
for i_3=1:n_TT(3);
for i_4=1:n_TT(4);
for i_5=1:n_TT(5);
for i_6=1:n_TT(6);
for i_7=1:n_TT(7);
for i_8=1:n_TT(8);
for i_9=1:n_TT(9);
for i_10=1:n_TT(10);
for i_11=1:n_TT(11);
for i_12=1:n_TT(12);
for i_13=1:n_TT(13);
for i_14=1:n_TT(14);
for i_15=1:n_TT(15);
%
MSE_CA_D=MSE_CA_D+B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12,i_13,i_14,i_15)^2;
%
MSE_CA_N=MSE_CA_N+(B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12,i_13,i_14,i_15)-Y{1}(i_1,:)*reshape(Y{2}(:,i_2,:),[r_Length(1),r_Length(2)])*...
reshape(Y{3}(:,i_3,:),[r_Length(2),r_Length(3)])*reshape(Y{4}(:,i_4,:),[r_Length(3),r_Length(4)])*...
reshape(Y{5}(:,i_5,:),[r_Length(4),r_Length(5)])*reshape(Y{6}(:,i_6,:),[r_Length(5),r_Length(6)])*...
reshape(Y{7}(:,i_7,:),[r_Length(6),r_Length(7)])*reshape(Y{8}(:,i_8,:),[r_Length(7),r_Length(8)])*...
reshape(Y{9}(:,i_9,:),[r_Length(8),r_Length(9)])*reshape(Y{10}(:,i_10,:),[r_Length(9),r_Length(10)])*...
reshape(Y{11}(:,i_11,:),[r_Length(10),r_Length(11)])*reshape(Y{12}(:,i_12,:),[r_Length(11),r_Length(12)])*...
reshape(Y{13}(:,i_13,:),[r_Length(12),r_Length(13)])*reshape(Y{14}(:,i_14,:),[r_Length(13),r_Length(14)])*Y{15}(:,i_15))^2;
%
MSE_CA_N1=MSE_CA_N1+(B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12,i_13,i_14,i_15)-Y1{1}(i_1,:)*reshape(Y1{2}(:,i_2,:),[r_Length(1),r_Length(2)])*...
reshape(Y1{3}(:,i_3,:),[r_Length(2),r_Length(3)])*reshape(Y1{4}(:,i_4,:),[r_Length(3),r_Length(4)])*...
reshape(Y1{5}(:,i_5,:),[r_Length(4),r_Length(5)])*reshape(Y1{6}(:,i_6,:),[r_Length(5),r_Length(6)])*...
reshape(Y1{7}(:,i_7,:),[r_Length(6),r_Length(7)])*reshape(Y1{8}(:,i_8,:),[r_Length(7),r_Length(8)])*...
reshape(Y1{9}(:,i_9,:),[r_Length(8),r_Length(9)])*reshape(Y1{10}(:,i_10,:),[r_Length(9),r_Length(10)])*...
reshape(Y1{11}(:,i_11,:),[r_Length(10),r_Length(11)])*reshape(Y1{12}(:,i_12,:),[r_Length(11),r_Length(12)])*...
reshape(Y1{13}(:,i_13,:),[r_Length(12),r_Length(13)])*reshape(Y1{14}(:,i_14,:),[r_Length(13),r_Length(14)])*Y1{15}(:,i_15))^2;
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end

MSE(10,ii_11)=MSE_CA_N/MSE_CA_D;
MSE1(10,ii_11)=MSE_CA_N1/MSE_CA_D;

end

%% Given a full tensor %Full tensor %16-order

for ii_11=1:NumberofIterations

%
n_TT = [2, 2, 2, 2, 2, 2, 2, 2,2,2,2,2,2,2,2,2];%the unmber of n_TT equals to d_TT
d_TT=16;
r_TT=[1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1];%the unmber of rank=d_TT+1,rank_0=1,rank_N=1,we choose other positions
A_low_rank_TT_Tensor=tt_random(n_TT,d_TT,r_TT);
A_low_rank_TT_Tensor_vector=full(A_low_rank_TT_Tensor);
A=reshape(A_low_rank_TT_Tensor_vector,n_TT); %From TT-Tensor to original Tensor
B=reshape(A,[2,2^(d_TT-1)]);
B_value=norm(B,'fro');
A=A/B_value;
%
LowRankError_Tensor=randn(2, 2, 2, 2, 2, 2,2,2,2,2,2,2,2,2,2,2);
C=reshape(LowRankError_Tensor,[2,2^(d_TT-1)]);
C_value=norm(C,'fro');
LowRankError_Tensor=LowRankError_Tensor/C_value;
%
MeasurementError_Tensor=zeros(n_TT);
for i_1=1:n_TT(1);
for i_2=1:n_TT(2);
for i_3=1:n_TT(3);
for i_4=1:n_TT(4);
for i_5=1:n_TT(5);
for i_6=1:n_TT(6);
for i_7=1:n_TT(7);  
for i_8=1:n_TT(8);   
for i_9=1:n_TT(9);  
for i_10=1:n_TT(10);  
for i_11=1:n_TT(11);  
for i_12=1:n_TT(12);  
for i_13=1:n_TT(13); 
for i_14=1:n_TT(14); 
for i_15=1:n_TT(15);
for i_16=1:n_TT(16);
MeasurementError_Tensor(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12,i_13,i_14,i_15,i_16)=mu_set*randn(1,1)/sqrt((d_TT-2)*8+2*4-4);
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
%

nswp=100; % Maximum Number of iterations
eta=eta_set;
Length_r_max=Length_r_max_design;% Estimated rank =Length_r_max-1

%
B=A+eta*LowRankError_Tensor;
C=B+MeasurementError_Tensor;
fun = @(ind) C(ind(1), ind(2), ind(3), ind(4), ind(5), ind(6), ind(7), ind(8), ind(9), ind(10), ind(11), ind(12), ind(13), ind(14), ind(15), ind(16) );
[y,Jyl,Jyr,ilocl,ilocr,evalcnt,Error_final]=greedy2_cross_Version_ZhenQin1(n_TT, fun, 1e-15, nswp, Length_r_max, []);

% Using Tau to truncate the diagonal matrix of SVD
tau=0;
tau1=Tau_design;
r_Length=zeros(length(ilocl)-2,1);
for iii=1:length(ilocl)-2
    r_Length(iii)=length(ilocl{iii+1});
end
Tensor=C;

[Y]=AddingTau(ilocl,ilocr,Tensor,n_TT,r_Length,tau);
[Y1]=AddingTau(ilocl,ilocr,Tensor,n_TT,r_Length,tau1);



MSE_CA_N=0;
MSE_CA_N1=0;
MSE_CA_D=0;
for i_1=1:n_TT(1);
for i_2=1:n_TT(2);
for i_3=1:n_TT(3);
for i_4=1:n_TT(4);
for i_5=1:n_TT(5);
for i_6=1:n_TT(6);
for i_7=1:n_TT(7);
for i_8=1:n_TT(8);
for i_9=1:n_TT(9);
for i_10=1:n_TT(10);
for i_11=1:n_TT(11);
for i_12=1:n_TT(12);
for i_13=1:n_TT(13);
for i_14=1:n_TT(14);
for i_15=1:n_TT(15);
for i_16=1:n_TT(16);
%
MSE_CA_D=MSE_CA_D+B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12,i_13,i_14,i_15,i_16)^2;
%
MSE_CA_N=MSE_CA_N+(B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12,i_13,i_14,i_15,i_16)-Y{1}(i_1,:)*reshape(Y{2}(:,i_2,:),[r_Length(1),r_Length(2)])*...
reshape(Y{3}(:,i_3,:),[r_Length(2),r_Length(3)])*reshape(Y{4}(:,i_4,:),[r_Length(3),r_Length(4)])*...
reshape(Y{5}(:,i_5,:),[r_Length(4),r_Length(5)])*reshape(Y{6}(:,i_6,:),[r_Length(5),r_Length(6)])*...
reshape(Y{7}(:,i_7,:),[r_Length(6),r_Length(7)])*reshape(Y{8}(:,i_8,:),[r_Length(7),r_Length(8)])*...
reshape(Y{9}(:,i_9,:),[r_Length(8),r_Length(9)])*reshape(Y{10}(:,i_10,:),[r_Length(9),r_Length(10)])*...
reshape(Y{11}(:,i_11,:),[r_Length(10),r_Length(11)])*reshape(Y{12}(:,i_12,:),[r_Length(11),r_Length(12)])*...
reshape(Y{13}(:,i_13,:),[r_Length(12),r_Length(13)])*reshape(Y{14}(:,i_14,:),[r_Length(13),r_Length(14)])*...
reshape(Y{15}(:,i_15,:),[r_Length(14),r_Length(15)])*Y{16}(:,i_16))^2;
%
MSE_CA_N1=MSE_CA_N1+(B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12,i_13,i_14,i_15,i_16)-Y1{1}(i_1,:)*reshape(Y1{2}(:,i_2,:),[r_Length(1),r_Length(2)])*...
reshape(Y1{3}(:,i_3,:),[r_Length(2),r_Length(3)])*reshape(Y1{4}(:,i_4,:),[r_Length(3),r_Length(4)])*...
reshape(Y1{5}(:,i_5,:),[r_Length(4),r_Length(5)])*reshape(Y1{6}(:,i_6,:),[r_Length(5),r_Length(6)])*...
reshape(Y1{7}(:,i_7,:),[r_Length(6),r_Length(7)])*reshape(Y1{8}(:,i_8,:),[r_Length(7),r_Length(8)])*...
reshape(Y1{9}(:,i_9,:),[r_Length(8),r_Length(9)])*reshape(Y1{10}(:,i_10,:),[r_Length(9),r_Length(10)])*...
reshape(Y1{11}(:,i_11,:),[r_Length(10),r_Length(11)])*reshape(Y1{12}(:,i_12,:),[r_Length(11),r_Length(12)])*...
reshape(Y1{13}(:,i_13,:),[r_Length(12),r_Length(13)])*reshape(Y1{14}(:,i_14,:),[r_Length(13),r_Length(14)])*...
reshape(Y1{15}(:,i_15,:),[r_Length(14),r_Length(15)])*Y1{16}(:,i_16))^2;
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end

MSE(11,ii_11)=MSE_CA_N/MSE_CA_D;
MSE1(11,ii_11)=MSE_CA_N1/MSE_CA_D;

end

%% Given a full tensor %Full tensor %17-order

for ii_11=1:NumberofIterations

%
n_TT = [2, 2, 2, 2, 2, 2, 2, 2,2,2,2,2,2,2,2,2,2];%the unmber of n_TT equals to d_TT
d_TT=17;
r_TT=[1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1];%the unmber of rank=d_TT+1,rank_0=1,rank_N=1,we choose other positions
A_low_rank_TT_Tensor=tt_random(n_TT,d_TT,r_TT);
A_low_rank_TT_Tensor_vector=full(A_low_rank_TT_Tensor);
A=reshape(A_low_rank_TT_Tensor_vector,n_TT); %From TT-Tensor to original Tensor
B=reshape(A,[2,2^(d_TT-1)]);
B_value=norm(B,'fro');
A=A/B_value;
%
LowRankError_Tensor=randn(2, 2, 2, 2, 2, 2,2,2,2,2,2,2,2,2,2,2,2);
C=reshape(LowRankError_Tensor,[2,2^(d_TT-1)]);
C_value=norm(C,'fro');
LowRankError_Tensor=LowRankError_Tensor/C_value;
%
MeasurementError_Tensor=zeros(n_TT);
for i_1=1:n_TT(1);
for i_2=1:n_TT(2);
for i_3=1:n_TT(3);
for i_4=1:n_TT(4);
for i_5=1:n_TT(5);
for i_6=1:n_TT(6);
for i_7=1:n_TT(7);  
for i_8=1:n_TT(8);   
for i_9=1:n_TT(9);  
for i_10=1:n_TT(10);  
for i_11=1:n_TT(11);  
for i_12=1:n_TT(12);  
for i_13=1:n_TT(13); 
for i_14=1:n_TT(14); 
for i_15=1:n_TT(15);
for i_16=1:n_TT(16);
for i_17=1:n_TT(17);
MeasurementError_Tensor(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12,i_13,i_14,i_15,i_16,i_17)=mu_set*randn(1,1)/sqrt((d_TT-2)*8+2*4-4);
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
%

nswp=100; % Maximum Number of iterations
eta=eta_set;
Length_r_max=Length_r_max_design;% Estimated rank =Length_r_max-1

%
B=A+eta*LowRankError_Tensor;
C=B+MeasurementError_Tensor;
fun = @(ind) C(ind(1), ind(2), ind(3), ind(4), ind(5), ind(6), ind(7), ind(8), ind(9), ind(10), ind(11), ind(12), ind(13), ind(14), ind(15), ind(16), ind(17) );
[y,Jyl,Jyr,ilocl,ilocr,evalcnt,Error_final]=greedy2_cross_Version_ZhenQin1(n_TT, fun, 1e-15, nswp, Length_r_max, []);

% Using Tau to truncate the diagonal matrix of SVD
tau=0;
tau1=Tau_design;
r_Length=zeros(length(ilocl)-2,1);
for iii=1:length(ilocl)-2
    r_Length(iii)=length(ilocl{iii+1});
end
Tensor=C;

[Y]=AddingTau(ilocl,ilocr,Tensor,n_TT,r_Length,tau);
[Y1]=AddingTau(ilocl,ilocr,Tensor,n_TT,r_Length,tau1);



MSE_CA_N=0;
MSE_CA_N1=0;
MSE_CA_D=0;
for i_1=1:n_TT(1);
for i_2=1:n_TT(2);
for i_3=1:n_TT(3);
for i_4=1:n_TT(4);
for i_5=1:n_TT(5);
for i_6=1:n_TT(6);
for i_7=1:n_TT(7);
for i_8=1:n_TT(8);
for i_9=1:n_TT(9);
for i_10=1:n_TT(10);
for i_11=1:n_TT(11);
for i_12=1:n_TT(12);
for i_13=1:n_TT(13);
for i_14=1:n_TT(14);
for i_15=1:n_TT(15);
for i_16=1:n_TT(16);
for i_17=1:n_TT(17);
%
MSE_CA_D=MSE_CA_D+B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12,i_13,i_14,i_15,i_16,i_17)^2;
%
MSE_CA_N=MSE_CA_N+(B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12,i_13,i_14,i_15,i_16,i_17)-Y{1}(i_1,:)*reshape(Y{2}(:,i_2,:),[r_Length(1),r_Length(2)])*...
reshape(Y{3}(:,i_3,:),[r_Length(2),r_Length(3)])*reshape(Y{4}(:,i_4,:),[r_Length(3),r_Length(4)])*...
reshape(Y{5}(:,i_5,:),[r_Length(4),r_Length(5)])*reshape(Y{6}(:,i_6,:),[r_Length(5),r_Length(6)])*...
reshape(Y{7}(:,i_7,:),[r_Length(6),r_Length(7)])*reshape(Y{8}(:,i_8,:),[r_Length(7),r_Length(8)])*...
reshape(Y{9}(:,i_9,:),[r_Length(8),r_Length(9)])*reshape(Y{10}(:,i_10,:),[r_Length(9),r_Length(10)])*...
reshape(Y{11}(:,i_11,:),[r_Length(10),r_Length(11)])*reshape(Y{12}(:,i_12,:),[r_Length(11),r_Length(12)])*...
reshape(Y{13}(:,i_13,:),[r_Length(12),r_Length(13)])*reshape(Y{14}(:,i_14,:),[r_Length(13),r_Length(14)])*...
reshape(Y{15}(:,i_15,:),[r_Length(14),r_Length(15)])*reshape(Y{16}(:,i_16,:),[r_Length(15),r_Length(16)])*Y{17}(:,i_17))^2;
%
MSE_CA_N1=MSE_CA_N1+(B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12,i_13,i_14,i_15,i_16,i_17)-Y1{1}(i_1,:)*reshape(Y1{2}(:,i_2,:),[r_Length(1),r_Length(2)])*...
reshape(Y1{3}(:,i_3,:),[r_Length(2),r_Length(3)])*reshape(Y1{4}(:,i_4,:),[r_Length(3),r_Length(4)])*...
reshape(Y1{5}(:,i_5,:),[r_Length(4),r_Length(5)])*reshape(Y1{6}(:,i_6,:),[r_Length(5),r_Length(6)])*...
reshape(Y1{7}(:,i_7,:),[r_Length(6),r_Length(7)])*reshape(Y1{8}(:,i_8,:),[r_Length(7),r_Length(8)])*...
reshape(Y1{9}(:,i_9,:),[r_Length(8),r_Length(9)])*reshape(Y1{10}(:,i_10,:),[r_Length(9),r_Length(10)])*...
reshape(Y1{11}(:,i_11,:),[r_Length(10),r_Length(11)])*reshape(Y1{12}(:,i_12,:),[r_Length(11),r_Length(12)])*...
reshape(Y1{13}(:,i_13,:),[r_Length(12),r_Length(13)])*reshape(Y1{14}(:,i_14,:),[r_Length(13),r_Length(14)])*...
reshape(Y1{15}(:,i_15,:),[r_Length(14),r_Length(15)])*reshape(Y1{16}(:,i_16,:),[r_Length(15),r_Length(16)])*Y1{17}(:,i_17))^2;
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end

MSE(12,ii_11)=MSE_CA_N/MSE_CA_D;
MSE1(12,ii_11)=MSE_CA_N1/MSE_CA_D;


end
%% Given a full tensor %Full tensor %18-order

for ii_11=1:NumberofIterations
%
n_TT = [2, 2, 2, 2, 2,2, 2, 2, 2,2, 2, 2, 2, 2,2, 2, 2, 2];%the unmber of n_TT equals to d_TT
d_TT=18;
r_TT=[1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1];%the unmber of rank=d_TT+1,rank_0=1,rank_N=1,we choose other positions
A_low_rank_TT_Tensor=tt_random(n_TT,d_TT,r_TT);
A_low_rank_TT_Tensor_vector=full(A_low_rank_TT_Tensor);
A=reshape(A_low_rank_TT_Tensor_vector,n_TT); %From TT-Tensor to original Tensor
B=reshape(A,[2,2^(d_TT-1)]);
B_value=norm(B,'fro');
A=A/B_value;
%
LowRankError_Tensor=randn(2, 2, 2, 2, 2,2, 2, 2, 2,2, 2, 2, 2, 2,2, 2, 2, 2 );
C=reshape(LowRankError_Tensor,[2,2^(d_TT-1)]);
C_value=norm(C,'fro');
LowRankError_Tensor=LowRankError_Tensor/C_value;
%
MeasurementError_Tensor=zeros(n_TT);
for i_1=1:n_TT(1);
for i_2=1:n_TT(2);
for i_3=1:n_TT(3);
for i_4=1:n_TT(4);
for i_5=1:n_TT(5);
for i_6=1:n_TT(6);
for i_7=1:n_TT(7);  
for i_8=1:n_TT(8);   
for i_9=1:n_TT(9);  
for i_10=1:n_TT(10);  
for i_11=1:n_TT(11);  
for i_12=1:n_TT(12);  
for i_13=1:n_TT(13); 
for i_14=1:n_TT(14); 
for i_15=1:n_TT(15);
for i_16=1:n_TT(16);
for i_17=1:n_TT(17);
for i_18=1:n_TT(18);
MeasurementError_Tensor(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12,i_13,i_14,i_15,i_16,i_17,i_18)=mu_set*randn(1,1)/sqrt((d_TT-2)*8+2*4-4);
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
%

nswp=100; % Maximum Number of iterations
eta=eta_set;
Length_r_max=Length_r_max_design;% Estimated rank =Length_r_max-1

%
B=A+eta*LowRankError_Tensor;
C=B+MeasurementError_Tensor;
fun = @(ind) C(ind(1), ind(2), ind(3), ind(4), ind(5), ind(6), ind(7), ind(8), ind(9), ind(10), ind(11), ind(12), ind(13), ind(14), ind(15), ind(16), ind(17), ind(18) );
[y,Jyl,Jyr,ilocl,ilocr,evalcnt,Error_final]=greedy2_cross_Version_ZhenQin1(n_TT, fun, 1e-15, nswp, Length_r_max, []);

% Using Tau to truncate the diagonal matrix of SVD
tau=0;
tau1=Tau_design;
r_Length=zeros(length(ilocl)-2,1);
for iii=1:length(ilocl)-2
    r_Length(iii)=length(ilocl{iii+1});
end
Tensor=C;

[Y]=AddingTau(ilocl,ilocr,Tensor,n_TT,r_Length,tau);
[Y1]=AddingTau(ilocl,ilocr,Tensor,n_TT,r_Length,tau1);



MSE_CA_N=0;
MSE_CA_N1=0;
MSE_CA_D=0;
for i_1=1:n_TT(1);
for i_2=1:n_TT(2);
for i_3=1:n_TT(3);
for i_4=1:n_TT(4);
for i_5=1:n_TT(5);
for i_6=1:n_TT(6);
for i_7=1:n_TT(7);
for i_8=1:n_TT(8);
for i_9=1:n_TT(9);
for i_10=1:n_TT(10);
for i_11=1:n_TT(11);
for i_12=1:n_TT(12);
for i_13=1:n_TT(13);
for i_14=1:n_TT(14);
for i_15=1:n_TT(15);
for i_16=1:n_TT(16);
for i_17=1:n_TT(17);
for i_18=1:n_TT(18);
%
MSE_CA_D=MSE_CA_D+B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12,i_13,i_14,i_15,i_16,i_17,i_18)^2;
%
MSE_CA_N=MSE_CA_N+(B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12,i_13,i_14,i_15,i_16,i_17,i_18)-Y{1}(i_1,:)*reshape(Y{2}(:,i_2,:),[r_Length(1),r_Length(2)])*...
reshape(Y{3}(:,i_3,:),[r_Length(2),r_Length(3)])*reshape(Y{4}(:,i_4,:),[r_Length(3),r_Length(4)])*...
reshape(Y{5}(:,i_5,:),[r_Length(4),r_Length(5)])*reshape(Y{6}(:,i_6,:),[r_Length(5),r_Length(6)])*...
reshape(Y{7}(:,i_7,:),[r_Length(6),r_Length(7)])*reshape(Y{8}(:,i_8,:),[r_Length(7),r_Length(8)])*...
reshape(Y{9}(:,i_9,:),[r_Length(8),r_Length(9)])*reshape(Y{10}(:,i_10,:),[r_Length(9),r_Length(10)])*...
reshape(Y{11}(:,i_11,:),[r_Length(10),r_Length(11)])*reshape(Y{12}(:,i_12,:),[r_Length(11),r_Length(12)])*...
reshape(Y{13}(:,i_13,:),[r_Length(12),r_Length(13)])*reshape(Y{14}(:,i_14,:),[r_Length(13),r_Length(14)])*...
reshape(Y{15}(:,i_15,:),[r_Length(14),r_Length(15)])*reshape(Y{16}(:,i_16,:),[r_Length(15),r_Length(16)])*...
reshape(Y{17}(:,i_17,:),[r_Length(16),r_Length(17)])*Y{18}(:,i_18))^2;
%
MSE_CA_N1=MSE_CA_N1+(B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12,i_13,i_14,i_15,i_16,i_17,i_18)-Y1{1}(i_1,:)*reshape(Y1{2}(:,i_2,:),[r_Length(1),r_Length(2)])*...
reshape(Y1{3}(:,i_3,:),[r_Length(2),r_Length(3)])*reshape(Y1{4}(:,i_4,:),[r_Length(3),r_Length(4)])*...
reshape(Y1{5}(:,i_5,:),[r_Length(4),r_Length(5)])*reshape(Y1{6}(:,i_6,:),[r_Length(5),r_Length(6)])*...
reshape(Y1{7}(:,i_7,:),[r_Length(6),r_Length(7)])*reshape(Y1{8}(:,i_8,:),[r_Length(7),r_Length(8)])*...
reshape(Y1{9}(:,i_9,:),[r_Length(8),r_Length(9)])*reshape(Y1{10}(:,i_10,:),[r_Length(9),r_Length(10)])*...
reshape(Y1{11}(:,i_11,:),[r_Length(10),r_Length(11)])*reshape(Y1{12}(:,i_12,:),[r_Length(11),r_Length(12)])*...
reshape(Y1{13}(:,i_13,:),[r_Length(12),r_Length(13)])*reshape(Y1{14}(:,i_14,:),[r_Length(13),r_Length(14)])*...
reshape(Y1{15}(:,i_15,:),[r_Length(14),r_Length(15)])*reshape(Y1{16}(:,i_16,:),[r_Length(15),r_Length(16)])*...
reshape(Y1{17}(:,i_17,:),[r_Length(16),r_Length(17)])*Y1{18}(:,i_18))^2;
%                                     MSE_CA_N=MSE_CA_N+(A(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9)-Y{1}(i_1,:)*reshape(Y{2}(:,i_2,:),[r_TT(2),r_TT(3)])*...
% reshape(Y{3}(:,i_3,:),[r_TT(3),r_TT(4)])*reshape(Y{4}(:,i_4,:),[r_TT(4),r_TT(5)])*...
% reshape(Y{5}(:,i_5,:),[r_TT(5),r_TT(6)])*reshape(Y{6}(:,i_6,:),[r_TT(6),r_TT(7)])*...
% reshape(Y{7}(:,i_7,:),[r_TT(7),r_TT(8)])*reshape(Y{8}(:,i_8,:),[r_TT(8),r_TT(9)])*Y{9}(:,i_9))^2;
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end

MSE(13,ii_11)=MSE_CA_N/MSE_CA_D;
MSE1(13,ii_11)=MSE_CA_N1/MSE_CA_D;

end

%% Given a full tensor %Full tensor %19-order
%
for ii_11=1:NumberofIterations

n_TT = [2, 2, 2, 2, 2,2, 2, 2, 2,2, 2, 2, 2, 2,2, 2, 2, 2,2];%the unmber of n_TT equals to d_TT
d_TT=19;
r_TT=[1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1];%the unmber of rank=d_TT+1,rank_0=1,rank_N=1,we choose other positions
A_low_rank_TT_Tensor=tt_random(n_TT,d_TT,r_TT);
A_low_rank_TT_Tensor_vector=full(A_low_rank_TT_Tensor);
A=reshape(A_low_rank_TT_Tensor_vector,n_TT); %From TT-Tensor to original Tensor
B=reshape(A,[2,2^(d_TT-1)]);
B_value=norm(B,'fro');
A=A/B_value;
%
LowRankError_Tensor=randn(2, 2, 2, 2, 2,2, 2, 2, 2,2, 2, 2, 2, 2,2, 2, 2, 2,2 );
C=reshape(LowRankError_Tensor,[2,2^(d_TT-1)]);
C_value=norm(C,'fro');
LowRankError_Tensor=LowRankError_Tensor/C_value;
%
MeasurementError_Tensor=zeros(n_TT);
for i_1=1:n_TT(1);
for i_2=1:n_TT(2);
for i_3=1:n_TT(3);
for i_4=1:n_TT(4);
for i_5=1:n_TT(5);
for i_6=1:n_TT(6);
for i_7=1:n_TT(7);  
for i_8=1:n_TT(8);   
for i_9=1:n_TT(9);  
for i_10=1:n_TT(10);  
for i_11=1:n_TT(11);  
for i_12=1:n_TT(12);  
for i_13=1:n_TT(13); 
for i_14=1:n_TT(14); 
for i_15=1:n_TT(15);
for i_16=1:n_TT(16);
for i_17=1:n_TT(17);
for i_18=1:n_TT(18);
for i_19=1:n_TT(19);
MeasurementError_Tensor(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12,i_13,i_14,i_15,i_16,i_17,i_18,i_19)=mu_set*randn(1,1)/sqrt((d_TT-2)*8+2*4-4);
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
%

nswp=100; % Maximum Number of iterations
eta=eta_set;
Length_r_max=Length_r_max_design;% Estimated rank =Length_r_max-1

%
B=A+eta*LowRankError_Tensor;
C=B+MeasurementError_Tensor;
fun = @(ind) C(ind(1), ind(2), ind(3), ind(4), ind(5), ind(6), ind(7), ind(8), ind(9), ind(10), ind(11), ind(12), ind(13), ind(14), ind(15), ind(16), ind(17), ind(18), ind(19) );
[y,Jyl,Jyr,ilocl,ilocr,evalcnt,Error_final]=greedy2_cross_Version_ZhenQin1(n_TT, fun, 1e-15, nswp, Length_r_max, []);

% Using Tau to truncate the diagonal matrix of SVD
tau=0;
tau1=Tau_design;
r_Length=zeros(length(ilocl)-2,1);
for iii=1:length(ilocl)-2
    r_Length(iii)=length(ilocl{iii+1});
end
Tensor=C;

[Y]=AddingTau(ilocl,ilocr,Tensor,n_TT,r_Length,tau);
[Y1]=AddingTau(ilocl,ilocr,Tensor,n_TT,r_Length,tau1);



MSE_CA_N=0;
MSE_CA_N1=0;
MSE_CA_D=0;
for i_1=1:n_TT(1);
for i_2=1:n_TT(2);
for i_3=1:n_TT(3);
for i_4=1:n_TT(4);
for i_5=1:n_TT(5);
for i_6=1:n_TT(6);
for i_7=1:n_TT(7);
for i_8=1:n_TT(8);
for i_9=1:n_TT(9);
for i_10=1:n_TT(10);
for i_11=1:n_TT(11);
for i_12=1:n_TT(12);
for i_13=1:n_TT(13);
for i_14=1:n_TT(14);
for i_15=1:n_TT(15);
for i_16=1:n_TT(16);
for i_17=1:n_TT(17);
for i_18=1:n_TT(18);
for i_19=1:n_TT(19);
%
MSE_CA_D=MSE_CA_D+B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12,i_13,i_14,i_15,i_16,i_17,i_18,i_19)^2;
%
MSE_CA_N=MSE_CA_N+(B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12,i_13,i_14,i_15,i_16,i_17,i_18,i_19)-Y{1}(i_1,:)*reshape(Y{2}(:,i_2,:),[r_Length(1),r_Length(2)])*...
reshape(Y{3}(:,i_3,:),[r_Length(2),r_Length(3)])*reshape(Y{4}(:,i_4,:),[r_Length(3),r_Length(4)])*...
reshape(Y{5}(:,i_5,:),[r_Length(4),r_Length(5)])*reshape(Y{6}(:,i_6,:),[r_Length(5),r_Length(6)])*...
reshape(Y{7}(:,i_7,:),[r_Length(6),r_Length(7)])*reshape(Y{8}(:,i_8,:),[r_Length(7),r_Length(8)])*...
reshape(Y{9}(:,i_9,:),[r_Length(8),r_Length(9)])*reshape(Y{10}(:,i_10,:),[r_Length(9),r_Length(10)])*...
reshape(Y{11}(:,i_11,:),[r_Length(10),r_Length(11)])*reshape(Y{12}(:,i_12,:),[r_Length(11),r_Length(12)])*...
reshape(Y{13}(:,i_13,:),[r_Length(12),r_Length(13)])*reshape(Y{14}(:,i_14,:),[r_Length(13),r_Length(14)])*...
reshape(Y{15}(:,i_15,:),[r_Length(14),r_Length(15)])*reshape(Y{16}(:,i_16,:),[r_Length(15),r_Length(16)])*...
reshape(Y{17}(:,i_17,:),[r_Length(16),r_Length(17)])*reshape(Y{18}(:,i_18,:),[r_Length(17),r_Length(18)])*Y{19}(:,i_19))^2;
%
MSE_CA_N1=MSE_CA_N1+(B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12,i_13,i_14,i_15,i_16,i_17,i_18,i_19)-Y1{1}(i_1,:)*reshape(Y1{2}(:,i_2,:),[r_Length(1),r_Length(2)])*...
reshape(Y1{3}(:,i_3,:),[r_Length(2),r_Length(3)])*reshape(Y1{4}(:,i_4,:),[r_Length(3),r_Length(4)])*...
reshape(Y1{5}(:,i_5,:),[r_Length(4),r_Length(5)])*reshape(Y1{6}(:,i_6,:),[r_Length(5),r_Length(6)])*...
reshape(Y1{7}(:,i_7,:),[r_Length(6),r_Length(7)])*reshape(Y1{8}(:,i_8,:),[r_Length(7),r_Length(8)])*...
reshape(Y1{9}(:,i_9,:),[r_Length(8),r_Length(9)])*reshape(Y1{10}(:,i_10,:),[r_Length(9),r_Length(10)])*...
reshape(Y1{11}(:,i_11,:),[r_Length(10),r_Length(11)])*reshape(Y1{12}(:,i_12,:),[r_Length(11),r_Length(12)])*...
reshape(Y1{13}(:,i_13,:),[r_Length(12),r_Length(13)])*reshape(Y1{14}(:,i_14,:),[r_Length(13),r_Length(14)])*...
reshape(Y1{15}(:,i_15,:),[r_Length(14),r_Length(15)])*reshape(Y1{16}(:,i_16,:),[r_Length(15),r_Length(16)])*...
reshape(Y1{17}(:,i_17,:),[r_Length(16),r_Length(17)])*reshape(Y1{18}(:,i_18,:),[r_Length(17),r_Length(18)])*Y1{19}(:,i_19))^2;
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end

MSE(14,ii_11)=MSE_CA_N/MSE_CA_D;
MSE1(14,ii_11)=MSE_CA_N1/MSE_CA_D;

end

%% Given a full tensor %Full tensor %20-order

for ii_11=1:NumberofIterations

%
n_TT = [2, 2, 2, 2, 2,2, 2, 2, 2,2, 2, 2, 2, 2,2, 2, 2, 2,2,2];%the unmber of n_TT equals to d_TT
d_TT=20;
r_TT=[1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1];%the unmber of rank=d_TT+1,rank_0=1,rank_N=1,we choose other positions
A_low_rank_TT_Tensor=tt_random(n_TT,d_TT,r_TT);
A_low_rank_TT_Tensor_vector=full(A_low_rank_TT_Tensor);
A=reshape(A_low_rank_TT_Tensor_vector,n_TT); %From TT-Tensor to original Tensor
B=reshape(A,[2,2^(d_TT-1)]);
B_value=norm(B,'fro');
A=A/B_value;
%
LowRankError_Tensor=randn(2, 2, 2, 2, 2,2, 2, 2, 2,2, 2, 2, 2, 2,2, 2, 2, 2,2,2 );
C=reshape(LowRankError_Tensor,[2,2^(d_TT-1)]);
C_value=norm(C,'fro');
LowRankError_Tensor=LowRankError_Tensor/C_value;
%
MeasurementError_Tensor=zeros(n_TT);
for i_1=1:n_TT(1);
for i_2=1:n_TT(2);
for i_3=1:n_TT(3);
for i_4=1:n_TT(4);
for i_5=1:n_TT(5);
for i_6=1:n_TT(6);
for i_7=1:n_TT(7);  
for i_8=1:n_TT(8);   
for i_9=1:n_TT(9);  
for i_10=1:n_TT(10);  
for i_11=1:n_TT(11);  
for i_12=1:n_TT(12);  
for i_13=1:n_TT(13); 
for i_14=1:n_TT(14); 
for i_15=1:n_TT(15);
for i_16=1:n_TT(16);
for i_17=1:n_TT(17);
for i_18=1:n_TT(18);
for i_19=1:n_TT(19);
for i_20=1:n_TT(20);
MeasurementError_Tensor(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12,i_13,i_14,i_15,i_16,i_17,i_18,i_19,i_20)=mu_set*randn(1,1)/sqrt((d_TT-2)*8+2*4-4);
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
%

nswp=100; % Maximum Number of iterations
eta=eta_set;
Length_r_max=Length_r_max_design;% Estimated rank =Length_r_max-1

%
B=A+eta*LowRankError_Tensor;
C=B+MeasurementError_Tensor;
fun = @(ind) C(ind(1), ind(2), ind(3), ind(4), ind(5), ind(6), ind(7), ind(8), ind(9), ind(10), ind(11), ind(12), ind(13), ind(14), ind(15), ind(16), ind(17), ind(18), ind(19), ind(20) );
[y,Jyl,Jyr,ilocl,ilocr,evalcnt,Error_final]=greedy2_cross_Version_ZhenQin1(n_TT, fun, 1e-15, nswp, Length_r_max, []);

% Using Tau to truncate the diagonal matrix of SVD
tau=0;
tau1=Tau_design;
r_Length=zeros(length(ilocl)-2,1);
for iii=1:length(ilocl)-2
    r_Length(iii)=length(ilocl{iii+1});
end
Tensor=C;

[Y]=AddingTau(ilocl,ilocr,Tensor,n_TT,r_Length,tau);
[Y1]=AddingTau(ilocl,ilocr,Tensor,n_TT,r_Length,tau1);



MSE_CA_N=0;
MSE_CA_N1=0;
MSE_CA_D=0;
for i_1=1:n_TT(1);
for i_2=1:n_TT(2);
for i_3=1:n_TT(3);
for i_4=1:n_TT(4);
for i_5=1:n_TT(5);
for i_6=1:n_TT(6);
for i_7=1:n_TT(7);
for i_8=1:n_TT(8);
for i_9=1:n_TT(9);
for i_10=1:n_TT(10);
for i_11=1:n_TT(11);
for i_12=1:n_TT(12);
for i_13=1:n_TT(13);
for i_14=1:n_TT(14);
for i_15=1:n_TT(15);
for i_16=1:n_TT(16);
for i_17=1:n_TT(17);
for i_18=1:n_TT(18);
for i_19=1:n_TT(19);
for i_20=1:n_TT(20);
%
MSE_CA_D=MSE_CA_D+B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12,i_13,i_14,i_15,i_16,i_17,i_18,i_19,i_20)^2;
%
MSE_CA_N=MSE_CA_N+(B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12,i_13,i_14,i_15,i_16,i_17,i_18,i_19,i_20)-Y{1}(i_1,:)*reshape(Y{2}(:,i_2,:),[r_Length(1),r_Length(2)])*...
reshape(Y{3}(:,i_3,:),[r_Length(2),r_Length(3)])*reshape(Y{4}(:,i_4,:),[r_Length(3),r_Length(4)])*...
reshape(Y{5}(:,i_5,:),[r_Length(4),r_Length(5)])*reshape(Y{6}(:,i_6,:),[r_Length(5),r_Length(6)])*...
reshape(Y{7}(:,i_7,:),[r_Length(6),r_Length(7)])*reshape(Y{8}(:,i_8,:),[r_Length(7),r_Length(8)])*...
reshape(Y{9}(:,i_9,:),[r_Length(8),r_Length(9)])*reshape(Y{10}(:,i_10,:),[r_Length(9),r_Length(10)])*...
reshape(Y{11}(:,i_11,:),[r_Length(10),r_Length(11)])*reshape(Y{12}(:,i_12,:),[r_Length(11),r_Length(12)])*...
reshape(Y{13}(:,i_13,:),[r_Length(12),r_Length(13)])*reshape(Y{14}(:,i_14,:),[r_Length(13),r_Length(14)])*...
reshape(Y{15}(:,i_15,:),[r_Length(14),r_Length(15)])*reshape(Y{16}(:,i_16,:),[r_Length(15),r_Length(16)])*...
reshape(Y{17}(:,i_17,:),[r_Length(16),r_Length(17)])*reshape(Y{18}(:,i_18,:),[r_Length(17),r_Length(18)])*...
reshape(Y{19}(:,i_19,:),[r_Length(18),r_Length(19)])*Y{20}(:,i_20))^2;
%
MSE_CA_N1=MSE_CA_N1+(B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12,i_13,i_14,i_15,i_16,i_17,i_18,i_19,i_20)-Y1{1}(i_1,:)*reshape(Y1{2}(:,i_2,:),[r_Length(1),r_Length(2)])*...
reshape(Y1{3}(:,i_3,:),[r_Length(2),r_Length(3)])*reshape(Y1{4}(:,i_4,:),[r_Length(3),r_Length(4)])*...
reshape(Y1{5}(:,i_5,:),[r_Length(4),r_Length(5)])*reshape(Y1{6}(:,i_6,:),[r_Length(5),r_Length(6)])*...
reshape(Y1{7}(:,i_7,:),[r_Length(6),r_Length(7)])*reshape(Y1{8}(:,i_8,:),[r_Length(7),r_Length(8)])*...
reshape(Y1{9}(:,i_9,:),[r_Length(8),r_Length(9)])*reshape(Y1{10}(:,i_10,:),[r_Length(9),r_Length(10)])*...
reshape(Y1{11}(:,i_11,:),[r_Length(10),r_Length(11)])*reshape(Y1{12}(:,i_12,:),[r_Length(11),r_Length(12)])*...
reshape(Y1{13}(:,i_13,:),[r_Length(12),r_Length(13)])*reshape(Y1{14}(:,i_14,:),[r_Length(13),r_Length(14)])*...
reshape(Y1{15}(:,i_15,:),[r_Length(14),r_Length(15)])*reshape(Y1{16}(:,i_16,:),[r_Length(15),r_Length(16)])*...
reshape(Y1{17}(:,i_17,:),[r_Length(16),r_Length(17)])*reshape(Y1{18}(:,i_18,:),[r_Length(17),r_Length(18)])*...
reshape(Y1{19}(:,i_19,:),[r_Length(18),r_Length(19)])*Y1{20}(:,i_20))^2;
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end

MSE(15,ii_11)=MSE_CA_N/MSE_CA_D;
MSE1(15,ii_11)=MSE_CA_N1/MSE_CA_D;

end

%% Given a full tensor %Full tensor %21-order

for ii_11=1:NumberofIterations

%
n_TT = [2, 2, 2, 2, 2,2, 2, 2, 2,2, 2, 2, 2, 2,2, 2, 2, 2,2,2,2];%the unmber of n_TT equals to d_TT
d_TT=21;
r_TT=[1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1];%the unmber of rank=d_TT+1,rank_0=1,rank_N=1,we choose other positions
A_low_rank_TT_Tensor=tt_random(n_TT,d_TT,r_TT);
A_low_rank_TT_Tensor_vector=full(A_low_rank_TT_Tensor);
A=reshape(A_low_rank_TT_Tensor_vector,n_TT); %From TT-Tensor to original Tensor
B=reshape(A,[2,2^(d_TT-1)]);
B_value=norm(B,'fro');
A=A/B_value;
%
LowRankError_Tensor=randn(2, 2, 2, 2, 2,2, 2, 2, 2,2, 2, 2, 2, 2,2, 2, 2, 2,2,2,2 );
C=reshape(LowRankError_Tensor,[2,2^(d_TT-1)]);
C_value=norm(C,'fro');
LowRankError_Tensor=LowRankError_Tensor/C_value;
%
MeasurementError_Tensor=zeros(n_TT);
for i_1=1:n_TT(1);
for i_2=1:n_TT(2);
for i_3=1:n_TT(3);
for i_4=1:n_TT(4);
for i_5=1:n_TT(5);
for i_6=1:n_TT(6);
for i_7=1:n_TT(7);  
for i_8=1:n_TT(8);   
for i_9=1:n_TT(9);  
for i_10=1:n_TT(10);  
for i_11=1:n_TT(11);  
for i_12=1:n_TT(12);  
for i_13=1:n_TT(13); 
for i_14=1:n_TT(14); 
for i_15=1:n_TT(15);
for i_16=1:n_TT(16);
for i_17=1:n_TT(17);
for i_18=1:n_TT(18);
for i_19=1:n_TT(19);
for i_20=1:n_TT(20);
for i_21=1:n_TT(21);
MeasurementError_Tensor(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12,i_13,i_14,i_15,i_16,i_17,i_18,i_19,i_20,i_21)=mu_set*randn(1,1)/sqrt((d_TT-2)*8+2*4-4);
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
%

nswp=100; % Maximum Number of iterations
eta=eta_set;
Length_r_max=Length_r_max_design;% Estimated rank =Length_r_max-1

%
B=A+eta*LowRankError_Tensor;
C=B+MeasurementError_Tensor;
fun = @(ind) C(ind(1), ind(2), ind(3), ind(4), ind(5), ind(6), ind(7), ind(8), ind(9), ind(10), ind(11), ind(12), ind(13), ind(14), ind(15), ind(16), ind(17), ind(18), ind(19), ind(20), ind(21) );
[y,Jyl,Jyr,ilocl,ilocr,evalcnt,Error_final]=greedy2_cross_Version_ZhenQin1(n_TT, fun, 1e-15, nswp, Length_r_max, []);

% Using Tau to truncate the diagonal matrix of SVD
tau=0;
tau1=Tau_design;
r_Length=zeros(length(ilocl)-2,1);
for iii=1:length(ilocl)-2
    r_Length(iii)=length(ilocl{iii+1});
end
Tensor=C;

[Y]=AddingTau(ilocl,ilocr,Tensor,n_TT,r_Length,tau);
[Y1]=AddingTau(ilocl,ilocr,Tensor,n_TT,r_Length,tau1);



MSE_CA_N=0;
MSE_CA_N1=0;
MSE_CA_D=0;
for i_1=1:n_TT(1);
for i_2=1:n_TT(2);
for i_3=1:n_TT(3);
for i_4=1:n_TT(4);
for i_5=1:n_TT(5);
for i_6=1:n_TT(6);
for i_7=1:n_TT(7);
for i_8=1:n_TT(8);
for i_9=1:n_TT(9);
for i_10=1:n_TT(10);
for i_11=1:n_TT(11);
for i_12=1:n_TT(12);
for i_13=1:n_TT(13);
for i_14=1:n_TT(14);
for i_15=1:n_TT(15);
for i_16=1:n_TT(16);
for i_17=1:n_TT(17);
for i_18=1:n_TT(18);
for i_19=1:n_TT(19);
for i_20=1:n_TT(20);
for i_21=1:n_TT(21);
%
MSE_CA_D=MSE_CA_D+B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12,i_13,i_14,i_15,i_16,i_17,i_18,i_19,i_20,i_21)^2;
%
MSE_CA_N=MSE_CA_N+(B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12,i_13,i_14,i_15,i_16,i_17,i_18,i_19,i_20,i_21)-Y{1}(i_1,:)*reshape(Y{2}(:,i_2,:),[r_Length(1),r_Length(2)])*...
reshape(Y{3}(:,i_3,:),[r_Length(2),r_Length(3)])*reshape(Y{4}(:,i_4,:),[r_Length(3),r_Length(4)])*...
reshape(Y{5}(:,i_5,:),[r_Length(4),r_Length(5)])*reshape(Y{6}(:,i_6,:),[r_Length(5),r_Length(6)])*...
reshape(Y{7}(:,i_7,:),[r_Length(6),r_Length(7)])*reshape(Y{8}(:,i_8,:),[r_Length(7),r_Length(8)])*...
reshape(Y{9}(:,i_9,:),[r_Length(8),r_Length(9)])*reshape(Y{10}(:,i_10,:),[r_Length(9),r_Length(10)])*...
reshape(Y{11}(:,i_11,:),[r_Length(10),r_Length(11)])*reshape(Y{12}(:,i_12,:),[r_Length(11),r_Length(12)])*...
reshape(Y{13}(:,i_13,:),[r_Length(12),r_Length(13)])*reshape(Y{14}(:,i_14,:),[r_Length(13),r_Length(14)])*...
reshape(Y{15}(:,i_15,:),[r_Length(14),r_Length(15)])*reshape(Y{16}(:,i_16,:),[r_Length(15),r_Length(16)])*...
reshape(Y{17}(:,i_17,:),[r_Length(16),r_Length(17)])*reshape(Y{18}(:,i_18,:),[r_Length(17),r_Length(18)])*...
reshape(Y{19}(:,i_19,:),[r_Length(18),r_Length(19)])*reshape(Y{20}(:,i_20,:),[r_Length(19),r_Length(20)])*Y{21}(:,i_21))^2;
%
MSE_CA_N1=MSE_CA_N1+(B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12,i_13,i_14,i_15,i_16,i_17,i_18,i_19,i_20,i_21)-Y1{1}(i_1,:)*reshape(Y1{2}(:,i_2,:),[r_Length(1),r_Length(2)])*...
reshape(Y1{3}(:,i_3,:),[r_Length(2),r_Length(3)])*reshape(Y1{4}(:,i_4,:),[r_Length(3),r_Length(4)])*...
reshape(Y1{5}(:,i_5,:),[r_Length(4),r_Length(5)])*reshape(Y1{6}(:,i_6,:),[r_Length(5),r_Length(6)])*...
reshape(Y1{7}(:,i_7,:),[r_Length(6),r_Length(7)])*reshape(Y1{8}(:,i_8,:),[r_Length(7),r_Length(8)])*...
reshape(Y1{9}(:,i_9,:),[r_Length(8),r_Length(9)])*reshape(Y1{10}(:,i_10,:),[r_Length(9),r_Length(10)])*...
reshape(Y1{11}(:,i_11,:),[r_Length(10),r_Length(11)])*reshape(Y1{12}(:,i_12,:),[r_Length(11),r_Length(12)])*...
reshape(Y1{13}(:,i_13,:),[r_Length(12),r_Length(13)])*reshape(Y1{14}(:,i_14,:),[r_Length(13),r_Length(14)])*...
reshape(Y1{15}(:,i_15,:),[r_Length(14),r_Length(15)])*reshape(Y1{16}(:,i_16,:),[r_Length(15),r_Length(16)])*...
reshape(Y1{17}(:,i_17,:),[r_Length(16),r_Length(17)])*reshape(Y1{18}(:,i_18,:),[r_Length(17),r_Length(18)])*...
reshape(Y1{19}(:,i_19,:),[r_Length(18),r_Length(19)])*reshape(Y1{20}(:,i_20,:),[r_Length(19),r_Length(20)])*Y1{21}(:,i_21))^2;
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end

MSE(16,ii_11)=MSE_CA_N/MSE_CA_D;
MSE1(16,ii_11)=MSE_CA_N1/MSE_CA_D;

end

%% Given a full tensor %Full tensor %22-order

for ii_11=1:NumberofIterations
%
n_TT = [2, 2, 2, 2, 2,2, 2, 2, 2,2, 2, 2, 2, 2,2, 2, 2, 2,2,2,2,2];%the unmber of n_TT equals to d_TT
d_TT=22;
r_TT=[1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1];%the unmber of rank=d_TT+1,rank_0=1,rank_N=1,we choose other positions
A_low_rank_TT_Tensor=tt_random(n_TT,d_TT,r_TT);
A_low_rank_TT_Tensor_vector=full(A_low_rank_TT_Tensor);
A=reshape(A_low_rank_TT_Tensor_vector,n_TT); %From TT-Tensor to original Tensor
B=reshape(A,[2,2^(d_TT-1)]);
B_value=norm(B,'fro');
A=A/B_value;
%
LowRankError_Tensor=randn(2, 2, 2, 2, 2,2, 2, 2, 2,2, 2, 2, 2, 2,2, 2, 2, 2,2,2,2,2 );
C=reshape(LowRankError_Tensor,[2,2^(d_TT-1)]);
C_value=norm(C,'fro');
LowRankError_Tensor=LowRankError_Tensor/C_value;
%
MeasurementError_Tensor=zeros(n_TT);
for i_1=1:n_TT(1);
for i_2=1:n_TT(2);
for i_3=1:n_TT(3);
for i_4=1:n_TT(4);
for i_5=1:n_TT(5);
for i_6=1:n_TT(6);
for i_7=1:n_TT(7);  
for i_8=1:n_TT(8);   
for i_9=1:n_TT(9);  
for i_10=1:n_TT(10);  
for i_11=1:n_TT(11);  
for i_12=1:n_TT(12);  
for i_13=1:n_TT(13); 
for i_14=1:n_TT(14); 
for i_15=1:n_TT(15);
for i_16=1:n_TT(16);
for i_17=1:n_TT(17);
for i_18=1:n_TT(18);
for i_19=1:n_TT(19);
for i_20=1:n_TT(20);
for i_21=1:n_TT(21);
for i_22=1:n_TT(22);
MeasurementError_Tensor(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12,i_13,i_14,i_15,i_16,i_17,i_18,i_19,i_20,i_21,i_22)=mu_set*randn(1,1)/sqrt((d_TT-2)*8+2*4-4);
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
%

nswp=100; % Maximum Number of iterations
eta=eta_set;
Length_r_max=Length_r_max_design;% Estimated rank =Length_r_max-1

%
B=A+eta*LowRankError_Tensor;
C=B+MeasurementError_Tensor;
fun = @(ind) C(ind(1), ind(2), ind(3), ind(4), ind(5), ind(6), ind(7), ind(8), ind(9), ind(10), ind(11), ind(12), ind(13), ind(14), ind(15), ind(16), ind(17), ind(18), ind(19), ind(20),...
    ind(21),ind(22) );
[y,Jyl,Jyr,ilocl,ilocr,evalcnt,Error_final]=greedy2_cross_Version_ZhenQin1(n_TT, fun, 1e-15, nswp, Length_r_max, []);

% Using Tau to truncate the diagonal matrix of SVD
tau=0;
tau1=Tau_design;
r_Length=zeros(length(ilocl)-2,1);
for iii=1:length(ilocl)-2
    r_Length(iii)=length(ilocl{iii+1});
end
Tensor=C;

[Y]=AddingTau(ilocl,ilocr,Tensor,n_TT,r_Length,tau);
[Y1]=AddingTau(ilocl,ilocr,Tensor,n_TT,r_Length,tau1);



MSE_CA_N=0;
MSE_CA_N1=0;
MSE_CA_D=0;
for i_1=1:n_TT(1);
for i_2=1:n_TT(2);
for i_3=1:n_TT(3);
for i_4=1:n_TT(4);
for i_5=1:n_TT(5);
for i_6=1:n_TT(6);
for i_7=1:n_TT(7);
for i_8=1:n_TT(8);
for i_9=1:n_TT(9);
for i_10=1:n_TT(10);
for i_11=1:n_TT(11);
for i_12=1:n_TT(12);
for i_13=1:n_TT(13);
for i_14=1:n_TT(14);
for i_15=1:n_TT(15);
for i_16=1:n_TT(16);
for i_17=1:n_TT(17);
for i_18=1:n_TT(18);
for i_19=1:n_TT(19);
for i_20=1:n_TT(20);
for i_21=1:n_TT(21);
for i_22=1:n_TT(22);
%
MSE_CA_D=MSE_CA_D+B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12,i_13,i_14,i_15,i_16,i_17,i_18,i_19,i_20,i_21,i_22)^2;
%
MSE_CA_N=MSE_CA_N+(B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12,i_13,i_14,i_15,i_16,i_17,i_18,i_19,i_20,i_21,i_22)...
    -Y{1}(i_1,:)*reshape(Y{2}(:,i_2,:),[r_Length(1),r_Length(2)])*...
reshape(Y{3}(:,i_3,:),[r_Length(2),r_Length(3)])*reshape(Y{4}(:,i_4,:),[r_Length(3),r_Length(4)])*...
reshape(Y{5}(:,i_5,:),[r_Length(4),r_Length(5)])*reshape(Y{6}(:,i_6,:),[r_Length(5),r_Length(6)])*...
reshape(Y{7}(:,i_7,:),[r_Length(6),r_Length(7)])*reshape(Y{8}(:,i_8,:),[r_Length(7),r_Length(8)])*...
reshape(Y{9}(:,i_9,:),[r_Length(8),r_Length(9)])*reshape(Y{10}(:,i_10,:),[r_Length(9),r_Length(10)])*...
reshape(Y{11}(:,i_11,:),[r_Length(10),r_Length(11)])*reshape(Y{12}(:,i_12,:),[r_Length(11),r_Length(12)])*...
reshape(Y{13}(:,i_13,:),[r_Length(12),r_Length(13)])*reshape(Y{14}(:,i_14,:),[r_Length(13),r_Length(14)])*...
reshape(Y{15}(:,i_15,:),[r_Length(14),r_Length(15)])*reshape(Y{16}(:,i_16,:),[r_Length(15),r_Length(16)])*...
reshape(Y{17}(:,i_17,:),[r_Length(16),r_Length(17)])*reshape(Y{18}(:,i_18,:),[r_Length(17),r_Length(18)])*...
reshape(Y{19}(:,i_19,:),[r_Length(18),r_Length(19)])*reshape(Y{20}(:,i_20,:),[r_Length(19),r_Length(20)])*...
reshape(Y{21}(:,i_21,:),[r_Length(20),r_Length(21)])*Y{22}(:,i_22))^2;
%
MSE_CA_N1=MSE_CA_N1+(B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12,i_13,i_14,i_15,i_16,i_17,i_18,i_19,i_20,i_21,i_22)...
    -Y1{1}(i_1,:)*reshape(Y1{2}(:,i_2,:),[r_Length(1),r_Length(2)])*...
reshape(Y1{3}(:,i_3,:),[r_Length(2),r_Length(3)])*reshape(Y1{4}(:,i_4,:),[r_Length(3),r_Length(4)])*...
reshape(Y1{5}(:,i_5,:),[r_Length(4),r_Length(5)])*reshape(Y1{6}(:,i_6,:),[r_Length(5),r_Length(6)])*...
reshape(Y1{7}(:,i_7,:),[r_Length(6),r_Length(7)])*reshape(Y1{8}(:,i_8,:),[r_Length(7),r_Length(8)])*...
reshape(Y1{9}(:,i_9,:),[r_Length(8),r_Length(9)])*reshape(Y1{10}(:,i_10,:),[r_Length(9),r_Length(10)])*...
reshape(Y1{11}(:,i_11,:),[r_Length(10),r_Length(11)])*reshape(Y1{12}(:,i_12,:),[r_Length(11),r_Length(12)])*...
reshape(Y1{13}(:,i_13,:),[r_Length(12),r_Length(13)])*reshape(Y1{14}(:,i_14,:),[r_Length(13),r_Length(14)])*...
reshape(Y1{15}(:,i_15,:),[r_Length(14),r_Length(15)])*reshape(Y1{16}(:,i_16,:),[r_Length(15),r_Length(16)])*...
reshape(Y1{17}(:,i_17,:),[r_Length(16),r_Length(17)])*reshape(Y1{18}(:,i_18,:),[r_Length(17),r_Length(18)])*...
reshape(Y1{19}(:,i_19,:),[r_Length(18),r_Length(19)])*reshape(Y1{20}(:,i_20,:),[r_Length(19),r_Length(20)])*...
reshape(Y1{21}(:,i_21,:),[r_Length(20),r_Length(21)])*Y1{22}(:,i_22))^2;
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end

MSE(17,ii_11)=MSE_CA_N/MSE_CA_D;
MSE1(17,ii_11)=MSE_CA_N1/MSE_CA_D;

end



%% Estimated rank=8
Length_r_max_design=Length_r_max_design1;
%% Given a full tensor %Full tensor %6-order
%
for ii_11=1:NumberofIterations

n_TT = [2, 2, 2, 2, 2, 2];%the unmber of n_TT equals to d_TT
d_TT=6;
r_TT=[1,2,2,2,2,2,1];%the unmber of rank=d_TT+1,rank_0=1,rank_N=1,we choose other positions
A_low_rank_TT_Tensor=tt_random(n_TT,d_TT,r_TT);
A_low_rank_TT_Tensor_vector=full(A_low_rank_TT_Tensor);
A=reshape(A_low_rank_TT_Tensor_vector,n_TT); %From TT-Tensor to original Tensor
B=reshape(A,[2,2^(d_TT-1)]);
B_value=norm(B,'fro');
A=A/B_value;
%
LowRankError_Tensor=randn(2, 2, 2, 2, 2, 2);
C=reshape(LowRankError_Tensor,[2,2^(d_TT-1)]);
C_value=norm(C,'fro');
LowRankError_Tensor=LowRankError_Tensor/C_value;

%
MeasurementError_Tensor=zeros(n_TT);
for i_1=1:n_TT(1);
for i_2=1:n_TT(2);
for i_3=1:n_TT(3);
for i_4=1:n_TT(4);
for i_5=1:n_TT(5);
for i_6=1:n_TT(6);
MeasurementError_Tensor(i_1,i_2,i_3,i_4,i_5,i_6)=mu_set*randn(1,1)/sqrt((d_TT-2)*32+2*8-16);
%
end
end
end
end
end
end


nswp=100; % Maximum Number of iterations
eta=eta_set;
Length_r_max=Length_r_max_design;% Estimated rank =Length_r_max-1
%

%
B=A+eta*LowRankError_Tensor;
C=B+MeasurementError_Tensor;
fun = @(ind) C(ind(1), ind(2), ind(3), ind(4), ind(5), ind(6) );
[y,Jyl,Jyr,ilocl,ilocr,evalcnt,Error_final]=greedy2_cross_Version_ZhenQin1(n_TT, fun, 1e-15, nswp, Length_r_max, []);

% Using Tau to truncate the diagonal matrix of SVD
tau=0;
tau1=Tau_design;
r_Length=zeros(length(ilocl)-2,1);
for iii=1:length(ilocl)-2
    r_Length(iii)=length(ilocl{iii+1});
end
Tensor=C;

[Y]=AddingTau(ilocl,ilocr,Tensor,n_TT,r_Length,tau);
[Y1]=AddingTau(ilocl,ilocr,Tensor,n_TT,r_Length,tau1);



MSE_CA_N=0;
MSE_CA_N1=0;
MSE_CA_D=0;
for i_1=1:n_TT(1);
for i_2=1:n_TT(2);
for i_3=1:n_TT(3);
for i_4=1:n_TT(4);
for i_5=1:n_TT(5);
for i_6=1:n_TT(6);
%
MSE_CA_D=MSE_CA_D+B(i_1,i_2,i_3,i_4,i_5,i_6)^2;
%
MSE_CA_N=MSE_CA_N+(B(i_1,i_2,i_3,i_4,i_5,i_6)-Y{1}(i_1,:)*reshape(Y{2}(:,i_2,:),[r_Length(1),r_Length(2)])*...
reshape(Y{3}(:,i_3,:),[r_Length(2),r_Length(3)])*reshape(Y{4}(:,i_4,:),[r_Length(3),r_Length(4)])*...
reshape(Y{5}(:,i_5,:),[r_Length(4),r_Length(5)])*Y{6}(:,i_6))^2;
%
MSE_CA_N1=MSE_CA_N1+(B(i_1,i_2,i_3,i_4,i_5,i_6)-Y1{1}(i_1,:)*reshape(Y1{2}(:,i_2,:),[r_Length(1),r_Length(2)])*...
reshape(Y1{3}(:,i_3,:),[r_Length(2),r_Length(3)])*reshape(Y1{4}(:,i_4,:),[r_Length(3),r_Length(4)])*...
reshape(Y1{5}(:,i_5,:),[r_Length(4),r_Length(5)])*Y1{6}(:,i_6))^2;
end
end
end
end
end
end

MSE2(1,ii_11)=MSE_CA_N/MSE_CA_D;
MSE3(1,ii_11)=MSE_CA_N1/MSE_CA_D;
end

%% Given a full tensor %Full tensor %7-order
%
for ii_11=1:NumberofIterations

n_TT = [2, 2, 2, 2, 2, 2, 2];%the unmber of n_TT equals to d_TT
d_TT=7;
r_TT=[1,2,2,2,2,2,2,1];%the unmber of rank=d_TT+1,rank_0=1,rank_N=1,we choose other positions
A_low_rank_TT_Tensor=tt_random(n_TT,d_TT,r_TT);
A_low_rank_TT_Tensor_vector=full(A_low_rank_TT_Tensor);
A=reshape(A_low_rank_TT_Tensor_vector,n_TT); %From TT-Tensor to original Tensor
B=reshape(A,[2,2^(d_TT-1)]);
B_value=norm(B,'fro');
A=A/B_value;
%
LowRankError_Tensor=randn(2, 2, 2, 2, 2, 2,2);
C=reshape(LowRankError_Tensor,[2,2^(d_TT-1)]);
C_value=norm(C,'fro');
LowRankError_Tensor=LowRankError_Tensor/C_value;
%
MeasurementError_Tensor=zeros(n_TT);
for i_1=1:n_TT(1);
for i_2=1:n_TT(2);
for i_3=1:n_TT(3);
for i_4=1:n_TT(4);
for i_5=1:n_TT(5);
for i_6=1:n_TT(6);
for i_7=1:n_TT(7);    
MeasurementError_Tensor(i_1,i_2,i_3,i_4,i_5,i_6,i_7)=mu_set*randn(1,1)/sqrt((d_TT-2)*32+2*8-16);
end
end
end
end
end
end
end
%

nswp=100; % Maximum Number of iterations
eta=eta_set;
Length_r_max=Length_r_max_design;% Estimated rank =Length_r_max-1

%
B=A+eta*LowRankError_Tensor;
C=B+MeasurementError_Tensor;
fun = @(ind) C(ind(1), ind(2), ind(3), ind(4), ind(5), ind(6), ind(7) );
[y,Jyl,Jyr,ilocl,ilocr,evalcnt,Error_final]=greedy2_cross_Version_ZhenQin1(n_TT, fun, 1e-15, nswp, Length_r_max, []);

% Using Tau to truncate the diagonal matrix of SVD
tau=0;
tau1=Tau_design;
r_Length=zeros(length(ilocl)-2,1);
for iii=1:length(ilocl)-2
    r_Length(iii)=length(ilocl{iii+1});
end
Tensor=C;

[Y]=AddingTau(ilocl,ilocr,Tensor,n_TT,r_Length,tau);
[Y1]=AddingTau(ilocl,ilocr,Tensor,n_TT,r_Length,tau1);



MSE_CA_N=0;
MSE_CA_N1=0;
MSE_CA_D=0;
for i_1=1:n_TT(1);
for i_2=1:n_TT(2);
for i_3=1:n_TT(3);
for i_4=1:n_TT(4);
for i_5=1:n_TT(5);
for i_6=1:n_TT(6);
for i_7=1:n_TT(7);
%
MSE_CA_D=MSE_CA_D+B(i_1,i_2,i_3,i_4,i_5,i_6,i_7)^2;
%
MSE_CA_N=MSE_CA_N+(B(i_1,i_2,i_3,i_4,i_5,i_6,i_7)-Y{1}(i_1,:)*reshape(Y{2}(:,i_2,:),[r_Length(1),r_Length(2)])*...
reshape(Y{3}(:,i_3,:),[r_Length(2),r_Length(3)])*reshape(Y{4}(:,i_4,:),[r_Length(3),r_Length(4)])*...
reshape(Y{5}(:,i_5,:),[r_Length(4),r_Length(5)])*reshape(Y{6}(:,i_6,:),[r_Length(5),r_Length(6)])*Y{7}(:,i_7))^2;
%
MSE_CA_N1=MSE_CA_N1+(B(i_1,i_2,i_3,i_4,i_5,i_6,i_7)-Y1{1}(i_1,:)*reshape(Y1{2}(:,i_2,:),[r_Length(1),r_Length(2)])*...
reshape(Y1{3}(:,i_3,:),[r_Length(2),r_Length(3)])*reshape(Y1{4}(:,i_4,:),[r_Length(3),r_Length(4)])*...
reshape(Y1{5}(:,i_5,:),[r_Length(4),r_Length(5)])*reshape(Y1{6}(:,i_6,:),[r_Length(5),r_Length(6)])*Y1{7}(:,i_7))^2;
end
end
end
end
end
end
end

MSE2(2,ii_11)=MSE_CA_N/MSE_CA_D;
MSE3(2,ii_11)=MSE_CA_N1/MSE_CA_D;

end

%% Given a full tensor %Full tensor %8-order

%
for ii_11=1:NumberofIterations

n_TT = [2, 2, 2, 2, 2, 2, 2, 2];%the unmber of n_TT equals to d_TT
d_TT=8;
r_TT=[1,2,2,2,2,2,2,2,1];%the unmber of rank=d_TT+1,rank_0=1,rank_N=1,we choose other positions
A_low_rank_TT_Tensor=tt_random(n_TT,d_TT,r_TT);
A_low_rank_TT_Tensor_vector=full(A_low_rank_TT_Tensor);
A=reshape(A_low_rank_TT_Tensor_vector,n_TT); %From TT-Tensor to original Tensor
B=reshape(A,[2,2^(d_TT-1)]);
B_value=norm(B,'fro');
A=A/B_value;
%
LowRankError_Tensor=randn(2, 2, 2, 2, 2, 2,2,2);
C=reshape(LowRankError_Tensor,[2,2^(d_TT-1)]);
C_value=norm(C,'fro');
LowRankError_Tensor=LowRankError_Tensor/C_value;
%
MeasurementError_Tensor=zeros(n_TT);
for i_1=1:n_TT(1);
for i_2=1:n_TT(2);
for i_3=1:n_TT(3);
for i_4=1:n_TT(4);
for i_5=1:n_TT(5);
for i_6=1:n_TT(6);
for i_7=1:n_TT(7);  
for i_8=1:n_TT(8);      
MeasurementError_Tensor(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8)=mu_set*randn(1,1)/sqrt((d_TT-2)*32+2*8-16);
end
end
end
end
end
end
end
end
%

nswp=100; % Maximum Number of iterations
eta=eta_set;
Length_r_max=Length_r_max_design;% Estimated rank =Length_r_max-1

%
B=A+eta*LowRankError_Tensor;
C=B+MeasurementError_Tensor;
fun = @(ind) C(ind(1), ind(2), ind(3), ind(4), ind(5), ind(6), ind(7), ind(8) );
[y,Jyl,Jyr,ilocl,ilocr,evalcnt,Error_final]=greedy2_cross_Version_ZhenQin1(n_TT, fun, 1e-15, nswp, Length_r_max, []);

% Using Tau to truncate the diagonal matrix of SVD
tau=0;
tau1=Tau_design;
r_Length=zeros(length(ilocl)-2,1);
for iii=1:length(ilocl)-2
    r_Length(iii)=length(ilocl{iii+1});
end
Tensor=C;

[Y]=AddingTau(ilocl,ilocr,Tensor,n_TT,r_Length,tau);
[Y1]=AddingTau(ilocl,ilocr,Tensor,n_TT,r_Length,tau1);



MSE_CA_N=0;
MSE_CA_N1=0;
MSE_CA_D=0;
for i_1=1:n_TT(1);
for i_2=1:n_TT(2);
for i_3=1:n_TT(3);
for i_4=1:n_TT(4);
for i_5=1:n_TT(5);
for i_6=1:n_TT(6);
for i_7=1:n_TT(7);
for i_8=1:n_TT(8);
%
MSE_CA_D=MSE_CA_D+B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8)^2;
%
MSE_CA_N=MSE_CA_N+(B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8)-Y{1}(i_1,:)*reshape(Y{2}(:,i_2,:),[r_Length(1),r_Length(2)])*...
reshape(Y{3}(:,i_3,:),[r_Length(2),r_Length(3)])*reshape(Y{4}(:,i_4,:),[r_Length(3),r_Length(4)])*...
reshape(Y{5}(:,i_5,:),[r_Length(4),r_Length(5)])*reshape(Y{6}(:,i_6,:),[r_Length(5),r_Length(6)])*...
reshape(Y{7}(:,i_7,:),[r_Length(6),r_Length(7)])*Y{8}(:,i_8))^2;
%
MSE_CA_N1=MSE_CA_N1+(B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8)-Y1{1}(i_1,:)*reshape(Y1{2}(:,i_2,:),[r_Length(1),r_Length(2)])*...
reshape(Y1{3}(:,i_3,:),[r_Length(2),r_Length(3)])*reshape(Y1{4}(:,i_4,:),[r_Length(3),r_Length(4)])*...
reshape(Y1{5}(:,i_5,:),[r_Length(4),r_Length(5)])*reshape(Y1{6}(:,i_6,:),[r_Length(5),r_Length(6)])*...
reshape(Y1{7}(:,i_7,:),[r_Length(6),r_Length(7)])*Y1{8}(:,i_8))^2;
end
end
end
end
end
end
end
end

MSE2(3,ii_11)=MSE_CA_N/MSE_CA_D;
MSE3(3,ii_11)=MSE_CA_N1/MSE_CA_D;

end
%% Given a full tensor %Full tensor %9-order

for ii_11=1:NumberofIterations
%
n_TT = [2, 2, 2, 2, 2, 2, 2, 2,2];%the unmber of n_TT equals to d_TT
d_TT=9;
r_TT=[1,2,2,2,2,2,2,2,2,1];%the unmber of rank=d_TT+1,rank_0=1,rank_N=1,we choose other positions
A_low_rank_TT_Tensor=tt_random(n_TT,d_TT,r_TT);
A_low_rank_TT_Tensor_vector=full(A_low_rank_TT_Tensor);
A=reshape(A_low_rank_TT_Tensor_vector,n_TT); %From TT-Tensor to original Tensor
B=reshape(A,[2,2^(d_TT-1)]);
B_value=norm(B,'fro');
A=A/B_value;
%
LowRankError_Tensor=randn(2, 2, 2, 2, 2, 2,2,2,2);
C=reshape(LowRankError_Tensor,[2,2^(d_TT-1)]);
C_value=norm(C,'fro');
LowRankError_Tensor=LowRankError_Tensor/C_value;
%
MeasurementError_Tensor=zeros(n_TT);
for i_1=1:n_TT(1);
for i_2=1:n_TT(2);
for i_3=1:n_TT(3);
for i_4=1:n_TT(4);
for i_5=1:n_TT(5);
for i_6=1:n_TT(6);
for i_7=1:n_TT(7);  
for i_8=1:n_TT(8);   
for i_9=1:n_TT(9);  
MeasurementError_Tensor(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9)=mu_set*randn(1,1)/sqrt((d_TT-2)*32+2*8-16);
end
end
end
end
end
end
end
end
end
%

nswp=100; % Maximum Number of iterations
eta=eta_set;
Length_r_max=Length_r_max_design;% Estimated rank =Length_r_max-1

%
B=A+eta*LowRankError_Tensor;
C=B+MeasurementError_Tensor;
fun = @(ind) C(ind(1), ind(2), ind(3), ind(4), ind(5), ind(6), ind(7), ind(8), ind(9) );
[y,Jyl,Jyr,ilocl,ilocr,evalcnt,Error_final]=greedy2_cross_Version_ZhenQin1(n_TT, fun, 1e-15, nswp, Length_r_max, []);

% Using Tau to truncate the diagonal matrix of SVD
tau=0;
tau1=Tau_design;
r_Length=zeros(length(ilocl)-2,1);
for iii=1:length(ilocl)-2
    r_Length(iii)=length(ilocl{iii+1});
end
Tensor=C;

[Y]=AddingTau(ilocl,ilocr,Tensor,n_TT,r_Length,tau);
[Y1]=AddingTau(ilocl,ilocr,Tensor,n_TT,r_Length,tau1);



MSE_CA_N=0;
MSE_CA_N1=0;
MSE_CA_D=0;
for i_1=1:n_TT(1);
for i_2=1:n_TT(2);
for i_3=1:n_TT(3);
for i_4=1:n_TT(4);
for i_5=1:n_TT(5);
for i_6=1:n_TT(6);
for i_7=1:n_TT(7);
for i_8=1:n_TT(8);
for i_9=1:n_TT(9);
%
MSE_CA_D=MSE_CA_D+B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9)^2;
%
MSE_CA_N=MSE_CA_N+(B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9)-Y{1}(i_1,:)*reshape(Y{2}(:,i_2,:),[r_Length(1),r_Length(2)])*...
reshape(Y{3}(:,i_3,:),[r_Length(2),r_Length(3)])*reshape(Y{4}(:,i_4,:),[r_Length(3),r_Length(4)])*...
reshape(Y{5}(:,i_5,:),[r_Length(4),r_Length(5)])*reshape(Y{6}(:,i_6,:),[r_Length(5),r_Length(6)])*...
reshape(Y{7}(:,i_7,:),[r_Length(6),r_Length(7)])*reshape(Y{8}(:,i_8,:),[r_Length(7),r_Length(8)])*Y{9}(:,i_9))^2;
%
MSE_CA_N1=MSE_CA_N1+(B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9)-Y1{1}(i_1,:)*reshape(Y1{2}(:,i_2,:),[r_Length(1),r_Length(2)])*...
reshape(Y1{3}(:,i_3,:),[r_Length(2),r_Length(3)])*reshape(Y1{4}(:,i_4,:),[r_Length(3),r_Length(4)])*...
reshape(Y1{5}(:,i_5,:),[r_Length(4),r_Length(5)])*reshape(Y1{6}(:,i_6,:),[r_Length(5),r_Length(6)])*...
reshape(Y1{7}(:,i_7,:),[r_Length(6),r_Length(7)])*reshape(Y1{8}(:,i_8,:),[r_Length(7),r_Length(8)])*Y1{9}(:,i_9))^2;
end
end
end
end
end
end
end
end
end

MSE2(4,ii_11)=MSE_CA_N/MSE_CA_D;
MSE3(4,ii_11)=MSE_CA_N1/MSE_CA_D;

end

%% Given a full tensor %Full tensor %10-order

for ii_11=1:NumberofIterations
%
n_TT = [2, 2, 2, 2, 2, 2, 2, 2,2,2];%the unmber of n_TT equals to d_TT
d_TT=10;
r_TT=[1,2,2,2,2,2,2,2,2,2,1];%the unmber of rank=d_TT+1,rank_0=1,rank_N=1,we choose other positions
A_low_rank_TT_Tensor=tt_random(n_TT,d_TT,r_TT);
A_low_rank_TT_Tensor_vector=full(A_low_rank_TT_Tensor);
A=reshape(A_low_rank_TT_Tensor_vector,n_TT); %From TT-Tensor to original Tensor
B=reshape(A,[2,2^(d_TT-1)]);
B_value=norm(B,'fro');
A=A/B_value;
%
LowRankError_Tensor=randn(2, 2, 2, 2, 2, 2,2,2,2,2);
C=reshape(LowRankError_Tensor,[2,2^(d_TT-1)]);
C_value=norm(C,'fro');
LowRankError_Tensor=LowRankError_Tensor/C_value;
%
MeasurementError_Tensor=zeros(n_TT);
for i_1=1:n_TT(1);
for i_2=1:n_TT(2);
for i_3=1:n_TT(3);
for i_4=1:n_TT(4);
for i_5=1:n_TT(5);
for i_6=1:n_TT(6);
for i_7=1:n_TT(7);  
for i_8=1:n_TT(8);   
for i_9=1:n_TT(9);  
for i_10=1:n_TT(10);  
MeasurementError_Tensor(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10)=mu_set*randn(1,1)/sqrt((d_TT-2)*32+2*8-16);
end
end
end
end
end
end
end
end
end
end
%

nswp=100; % Maximum Number of iterations
eta=eta_set;
Length_r_max=Length_r_max_design;% Estimated rank =Length_r_max-1

%
B=A+eta*LowRankError_Tensor;
C=B+MeasurementError_Tensor;
fun = @(ind) C(ind(1), ind(2), ind(3), ind(4), ind(5), ind(6), ind(7), ind(8), ind(9), ind(10) );
[y,Jyl,Jyr,ilocl,ilocr,evalcnt,Error_final]=greedy2_cross_Version_ZhenQin1(n_TT, fun, 1e-15, nswp, Length_r_max, []);

% Using Tau to truncate the diagonal matrix of SVD
tau=0;
tau1=Tau_design;
r_Length=zeros(length(ilocl)-2,1);
for iii=1:length(ilocl)-2
    r_Length(iii)=length(ilocl{iii+1});
end
Tensor=C;

[Y]=AddingTau(ilocl,ilocr,Tensor,n_TT,r_Length,tau);
[Y1]=AddingTau(ilocl,ilocr,Tensor,n_TT,r_Length,tau1);



MSE_CA_N=0;
MSE_CA_N1=0;
MSE_CA_D=0;
for i_1=1:n_TT(1);
for i_2=1:n_TT(2);
for i_3=1:n_TT(3);
for i_4=1:n_TT(4);
for i_5=1:n_TT(5);
for i_6=1:n_TT(6);
for i_7=1:n_TT(7);
for i_8=1:n_TT(8);
for i_9=1:n_TT(9);
for i_10=1:n_TT(10);
%
MSE_CA_D=MSE_CA_D+B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10)^2;
%
MSE_CA_N=MSE_CA_N+(B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10)-Y{1}(i_1,:)*reshape(Y{2}(:,i_2,:),[r_Length(1),r_Length(2)])*...
reshape(Y{3}(:,i_3,:),[r_Length(2),r_Length(3)])*reshape(Y{4}(:,i_4,:),[r_Length(3),r_Length(4)])*...
reshape(Y{5}(:,i_5,:),[r_Length(4),r_Length(5)])*reshape(Y{6}(:,i_6,:),[r_Length(5),r_Length(6)])*...
reshape(Y{7}(:,i_7,:),[r_Length(6),r_Length(7)])*reshape(Y{8}(:,i_8,:),[r_Length(7),r_Length(8)])*...
reshape(Y{9}(:,i_9,:),[r_Length(8),r_Length(9)])*Y{10}(:,i_10))^2;
%
MSE_CA_N1=MSE_CA_N1+(B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10)-Y1{1}(i_1,:)*reshape(Y1{2}(:,i_2,:),[r_Length(1),r_Length(2)])*...
reshape(Y1{3}(:,i_3,:),[r_Length(2),r_Length(3)])*reshape(Y1{4}(:,i_4,:),[r_Length(3),r_Length(4)])*...
reshape(Y1{5}(:,i_5,:),[r_Length(4),r_Length(5)])*reshape(Y1{6}(:,i_6,:),[r_Length(5),r_Length(6)])*...
reshape(Y1{7}(:,i_7,:),[r_Length(6),r_Length(7)])*reshape(Y1{8}(:,i_8,:),[r_Length(7),r_Length(8)])*...
reshape(Y1{9}(:,i_9,:),[r_Length(8),r_Length(9)])*Y1{10}(:,i_10))^2;
end
end
end
end
end
end
end
end
end
end

MSE2(5,ii_11)=MSE_CA_N/MSE_CA_D;
MSE3(5,ii_11)=MSE_CA_N1/MSE_CA_D;

end

%% Given a full tensor %Full tensor %11-order

for ii_11=1:NumberofIterations

n_TT = [2, 2, 2, 2, 2, 2, 2, 2,2,2,2];%the unmber of n_TT equals to d_TT
d_TT=11;
r_TT=[1,2,2,2,2,2,2,2,2,2,2,1];%the unmber of rank=d_TT+1,rank_0=1,rank_N=1,we choose other positions
A_low_rank_TT_Tensor=tt_random(n_TT,d_TT,r_TT);
A_low_rank_TT_Tensor_vector=full(A_low_rank_TT_Tensor);
A=reshape(A_low_rank_TT_Tensor_vector,n_TT); %From TT-Tensor to original Tensor
B=reshape(A,[2,2^(d_TT-1)]);
B_value=norm(B,'fro');
A=A/B_value;
%
LowRankError_Tensor=randn(2, 2, 2, 2, 2, 2,2,2,2,2,2);
C=reshape(LowRankError_Tensor,[2,2^(d_TT-1)]);
C_value=norm(C,'fro');
LowRankError_Tensor=LowRankError_Tensor/C_value;
%
MeasurementError_Tensor=zeros(n_TT);
for i_1=1:n_TT(1);
for i_2=1:n_TT(2);
for i_3=1:n_TT(3);
for i_4=1:n_TT(4);
for i_5=1:n_TT(5);
for i_6=1:n_TT(6);
for i_7=1:n_TT(7);  
for i_8=1:n_TT(8);   
for i_9=1:n_TT(9);  
for i_10=1:n_TT(10);  
for i_11=1:n_TT(11);  
MeasurementError_Tensor(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11)=mu_set*randn(1,1)/sqrt((d_TT-2)*32+2*8-16);
end
end
end
end
end
end
end
end
end
end
end
%

nswp=100; % Maximum Number of iterations
eta=eta_set;
Length_r_max=Length_r_max_design;% Estimated rank =Length_r_max-1

%
B=A+eta*LowRankError_Tensor;
C=B+MeasurementError_Tensor;
fun = @(ind) C(ind(1), ind(2), ind(3), ind(4), ind(5), ind(6), ind(7), ind(8), ind(9), ind(10), ind(11) );
[y,Jyl,Jyr,ilocl,ilocr,evalcnt,Error_final]=greedy2_cross_Version_ZhenQin1(n_TT, fun, 1e-15, nswp, Length_r_max, []);

% Using Tau to truncate the diagonal matrix of SVD
tau=0;
tau1=Tau_design;
r_Length=zeros(length(ilocl)-2,1);
for iii=1:length(ilocl)-2
    r_Length(iii)=length(ilocl{iii+1});
end
Tensor=C;

[Y]=AddingTau(ilocl,ilocr,Tensor,n_TT,r_Length,tau);
[Y1]=AddingTau(ilocl,ilocr,Tensor,n_TT,r_Length,tau1);



MSE_CA_N=0;
MSE_CA_N1=0;
MSE_CA_D=0;
for i_1=1:n_TT(1);
for i_2=1:n_TT(2);
for i_3=1:n_TT(3);
for i_4=1:n_TT(4);
for i_5=1:n_TT(5);
for i_6=1:n_TT(6);
for i_7=1:n_TT(7);
for i_8=1:n_TT(8);
for i_9=1:n_TT(9);
for i_10=1:n_TT(10);
for i_11=1:n_TT(11);
%
MSE_CA_D=MSE_CA_D+B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11)^2;
%
MSE_CA_N=MSE_CA_N+(B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11)-Y{1}(i_1,:)*reshape(Y{2}(:,i_2,:),[r_Length(1),r_Length(2)])*...
reshape(Y{3}(:,i_3,:),[r_Length(2),r_Length(3)])*reshape(Y{4}(:,i_4,:),[r_Length(3),r_Length(4)])*...
reshape(Y{5}(:,i_5,:),[r_Length(4),r_Length(5)])*reshape(Y{6}(:,i_6,:),[r_Length(5),r_Length(6)])*...
reshape(Y{7}(:,i_7,:),[r_Length(6),r_Length(7)])*reshape(Y{8}(:,i_8,:),[r_Length(7),r_Length(8)])*...
reshape(Y{9}(:,i_9,:),[r_Length(8),r_Length(9)])*reshape(Y{10}(:,i_10,:),[r_Length(9),r_Length(10)])*Y{11}(:,i_11))^2;
%
MSE_CA_N1=MSE_CA_N1+(B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11)-Y1{1}(i_1,:)*reshape(Y1{2}(:,i_2,:),[r_Length(1),r_Length(2)])*...
reshape(Y1{3}(:,i_3,:),[r_Length(2),r_Length(3)])*reshape(Y1{4}(:,i_4,:),[r_Length(3),r_Length(4)])*...
reshape(Y1{5}(:,i_5,:),[r_Length(4),r_Length(5)])*reshape(Y1{6}(:,i_6,:),[r_Length(5),r_Length(6)])*...
reshape(Y1{7}(:,i_7,:),[r_Length(6),r_Length(7)])*reshape(Y1{8}(:,i_8,:),[r_Length(7),r_Length(8)])*...
reshape(Y1{9}(:,i_9,:),[r_Length(8),r_Length(9)])*reshape(Y1{10}(:,i_10,:),[r_Length(9),r_Length(10)])*Y1{11}(:,i_11))^2;
end
end
end
end
end
end
end
end
end
end
end

MSE2(6,ii_11)=MSE_CA_N/MSE_CA_D;
MSE3(6,ii_11)=MSE_CA_N1/MSE_CA_D;

end

%% Given a full tensor %Full tensor %12-order

%
for ii_11=1:NumberofIterations
    
n_TT = [2, 2, 2, 2, 2, 2, 2, 2,2,2,2,2];%the unmber of n_TT equals to d_TT
d_TT=12;
r_TT=[1,2,2,2,2,2,2,2,2,2,2,2,1];%the unmber of rank=d_TT+1,rank_0=1,rank_N=1,we choose other positions
A_low_rank_TT_Tensor=tt_random(n_TT,d_TT,r_TT);
A_low_rank_TT_Tensor_vector=full(A_low_rank_TT_Tensor);
A=reshape(A_low_rank_TT_Tensor_vector,n_TT); %From TT-Tensor to original Tensor
B=reshape(A,[2,2^(d_TT-1)]);
B_value=norm(B,'fro');
A=A/B_value;
%
LowRankError_Tensor=randn(2, 2, 2, 2, 2, 2,2,2,2,2,2,2);
C=reshape(LowRankError_Tensor,[2,2^(d_TT-1)]);
C_value=norm(C,'fro');
LowRankError_Tensor=LowRankError_Tensor/C_value;
%
MeasurementError_Tensor=zeros(n_TT);
for i_1=1:n_TT(1);
for i_2=1:n_TT(2);
for i_3=1:n_TT(3);
for i_4=1:n_TT(4);
for i_5=1:n_TT(5);
for i_6=1:n_TT(6);
for i_7=1:n_TT(7);  
for i_8=1:n_TT(8);   
for i_9=1:n_TT(9);  
for i_10=1:n_TT(10);  
for i_11=1:n_TT(11);  
for i_12=1:n_TT(12);  
MeasurementError_Tensor(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12)=mu_set*randn(1,1)/sqrt((d_TT-2)*32+2*8-16);
end
end
end
end
end
end
end
end
end
end
end
end
%

nswp=100; % Maximum Number of iterations
eta=eta_set;
Length_r_max=Length_r_max_design;% Estimated rank =Length_r_max-1

%
B=A+eta*LowRankError_Tensor;
C=B+MeasurementError_Tensor;
fun = @(ind) C(ind(1), ind(2), ind(3), ind(4), ind(5), ind(6), ind(7), ind(8), ind(9), ind(10), ind(11), ind(12) );
[y,Jyl,Jyr,ilocl,ilocr,evalcnt,Error_final]=greedy2_cross_Version_ZhenQin1(n_TT, fun, 1e-15, nswp, Length_r_max, []);

% Using Tau to truncate the diagonal matrix of SVD
tau=0;
tau1=Tau_design;
r_Length=zeros(length(ilocl)-2,1);
for iii=1:length(ilocl)-2
    r_Length(iii)=length(ilocl{iii+1});
end
Tensor=C;

[Y]=AddingTau(ilocl,ilocr,Tensor,n_TT,r_Length,tau);
[Y1]=AddingTau(ilocl,ilocr,Tensor,n_TT,r_Length,tau1);



MSE_CA_N=0;
MSE_CA_N1=0;
MSE_CA_D=0;
for i_1=1:n_TT(1);
for i_2=1:n_TT(2);
for i_3=1:n_TT(3);
for i_4=1:n_TT(4);
for i_5=1:n_TT(5);
for i_6=1:n_TT(6);
for i_7=1:n_TT(7);
for i_8=1:n_TT(8);
for i_9=1:n_TT(9);
for i_10=1:n_TT(10);
for i_11=1:n_TT(11);
for i_12=1:n_TT(12);
%
MSE_CA_D=MSE_CA_D+B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12)^2;
%
MSE_CA_N=MSE_CA_N+(B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12)-Y{1}(i_1,:)*reshape(Y{2}(:,i_2,:),[r_Length(1),r_Length(2)])*...
reshape(Y{3}(:,i_3,:),[r_Length(2),r_Length(3)])*reshape(Y{4}(:,i_4,:),[r_Length(3),r_Length(4)])*...
reshape(Y{5}(:,i_5,:),[r_Length(4),r_Length(5)])*reshape(Y{6}(:,i_6,:),[r_Length(5),r_Length(6)])*...
reshape(Y{7}(:,i_7,:),[r_Length(6),r_Length(7)])*reshape(Y{8}(:,i_8,:),[r_Length(7),r_Length(8)])*...
reshape(Y{9}(:,i_9,:),[r_Length(8),r_Length(9)])*reshape(Y{10}(:,i_10,:),[r_Length(9),r_Length(10)])*...
reshape(Y{11}(:,i_11,:),[r_Length(10),r_Length(11)])*Y{12}(:,i_12))^2;
%
MSE_CA_N1=MSE_CA_N1+(B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12)-Y1{1}(i_1,:)*reshape(Y1{2}(:,i_2,:),[r_Length(1),r_Length(2)])*...
reshape(Y1{3}(:,i_3,:),[r_Length(2),r_Length(3)])*reshape(Y1{4}(:,i_4,:),[r_Length(3),r_Length(4)])*...
reshape(Y1{5}(:,i_5,:),[r_Length(4),r_Length(5)])*reshape(Y1{6}(:,i_6,:),[r_Length(5),r_Length(6)])*...
reshape(Y1{7}(:,i_7,:),[r_Length(6),r_Length(7)])*reshape(Y1{8}(:,i_8,:),[r_Length(7),r_Length(8)])*...
reshape(Y1{9}(:,i_9,:),[r_Length(8),r_Length(9)])*reshape(Y1{10}(:,i_10,:),[r_Length(9),r_Length(10)])*...
reshape(Y1{11}(:,i_11,:),[r_Length(10),r_Length(11)])*Y1{12}(:,i_12))^2;
end
end
end
end
end
end
end
end
end
end
end
end

MSE2(7,ii_11)=MSE_CA_N/MSE_CA_D;
MSE3(7,ii_11)=MSE_CA_N1/MSE_CA_D;


end

%% Given a full tensor %Full tensor %13-order


for ii_11=1:NumberofIterations

%
n_TT = [2, 2, 2, 2, 2, 2, 2, 2,2,2,2,2,2];%the unmber of n_TT equals to d_TT
d_TT=13;
r_TT=[1,2,2,2,2,2,2,2,2,2,2,2,2,1];%the unmber of rank=d_TT+1,rank_0=1,rank_N=1,we choose other positions
A_low_rank_TT_Tensor=tt_random(n_TT,d_TT,r_TT);
A_low_rank_TT_Tensor_vector=full(A_low_rank_TT_Tensor);
A=reshape(A_low_rank_TT_Tensor_vector,n_TT); %From TT-Tensor to original Tensor
B=reshape(A,[2,2^(d_TT-1)]);
B_value=norm(B,'fro');
A=A/B_value;
%
LowRankError_Tensor=randn(2, 2, 2, 2, 2, 2,2,2,2,2,2,2,2);
C=reshape(LowRankError_Tensor,[2,2^(d_TT-1)]);
C_value=norm(C,'fro');
LowRankError_Tensor=LowRankError_Tensor/C_value;
%
MeasurementError_Tensor=zeros(n_TT);
for i_1=1:n_TT(1);
for i_2=1:n_TT(2);
for i_3=1:n_TT(3);
for i_4=1:n_TT(4);
for i_5=1:n_TT(5);
for i_6=1:n_TT(6);
for i_7=1:n_TT(7);  
for i_8=1:n_TT(8);   
for i_9=1:n_TT(9);  
for i_10=1:n_TT(10);  
for i_11=1:n_TT(11);  
for i_12=1:n_TT(12);  
for i_13=1:n_TT(13); 
MeasurementError_Tensor(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12,i_13)=mu_set*randn(1,1)/sqrt((d_TT-2)*32+2*8-16);
end
end
end
end
end
end
end
end
end
end
end
end
end
%

nswp=100; % Maximum Number of iterations
eta=eta_set;
Length_r_max=Length_r_max_design;% Estimated rank =Length_r_max-1

%
B=A+eta*LowRankError_Tensor;
C=B+MeasurementError_Tensor;
fun = @(ind) C(ind(1), ind(2), ind(3), ind(4), ind(5), ind(6), ind(7), ind(8), ind(9), ind(10), ind(11), ind(12), ind(13) );
[y,Jyl,Jyr,ilocl,ilocr,evalcnt,Error_final]=greedy2_cross_Version_ZhenQin1(n_TT, fun, 1e-15, nswp, Length_r_max, []);

% Using Tau to truncate the diagonal matrix of SVD
tau=0;
tau1=Tau_design;
r_Length=zeros(length(ilocl)-2,1);
for iii=1:length(ilocl)-2
    r_Length(iii)=length(ilocl{iii+1});
end
Tensor=C;

[Y]=AddingTau(ilocl,ilocr,Tensor,n_TT,r_Length,tau);
[Y1]=AddingTau(ilocl,ilocr,Tensor,n_TT,r_Length,tau1);



MSE_CA_N=0;
MSE_CA_N1=0;
MSE_CA_D=0;
for i_1=1:n_TT(1);
for i_2=1:n_TT(2);
for i_3=1:n_TT(3);
for i_4=1:n_TT(4);
for i_5=1:n_TT(5);
for i_6=1:n_TT(6);
for i_7=1:n_TT(7);
for i_8=1:n_TT(8);
for i_9=1:n_TT(9);
for i_10=1:n_TT(10);
for i_11=1:n_TT(11);
for i_12=1:n_TT(12);
for i_13=1:n_TT(13);
%
MSE_CA_D=MSE_CA_D+B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12,i_13)^2;
%
MSE_CA_N=MSE_CA_N+(B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12,i_13)-Y{1}(i_1,:)*reshape(Y{2}(:,i_2,:),[r_Length(1),r_Length(2)])*...
reshape(Y{3}(:,i_3,:),[r_Length(2),r_Length(3)])*reshape(Y{4}(:,i_4,:),[r_Length(3),r_Length(4)])*...
reshape(Y{5}(:,i_5,:),[r_Length(4),r_Length(5)])*reshape(Y{6}(:,i_6,:),[r_Length(5),r_Length(6)])*...
reshape(Y{7}(:,i_7,:),[r_Length(6),r_Length(7)])*reshape(Y{8}(:,i_8,:),[r_Length(7),r_Length(8)])*...
reshape(Y{9}(:,i_9,:),[r_Length(8),r_Length(9)])*reshape(Y{10}(:,i_10,:),[r_Length(9),r_Length(10)])*...
reshape(Y{11}(:,i_11,:),[r_Length(10),r_Length(11)])*reshape(Y{12}(:,i_12,:),[r_Length(11),r_Length(12)])*Y{13}(:,i_13))^2;
%
MSE_CA_N1=MSE_CA_N1+(B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12,i_13)-Y1{1}(i_1,:)*reshape(Y1{2}(:,i_2,:),[r_Length(1),r_Length(2)])*...
reshape(Y1{3}(:,i_3,:),[r_Length(2),r_Length(3)])*reshape(Y1{4}(:,i_4,:),[r_Length(3),r_Length(4)])*...
reshape(Y1{5}(:,i_5,:),[r_Length(4),r_Length(5)])*reshape(Y1{6}(:,i_6,:),[r_Length(5),r_Length(6)])*...
reshape(Y1{7}(:,i_7,:),[r_Length(6),r_Length(7)])*reshape(Y1{8}(:,i_8,:),[r_Length(7),r_Length(8)])*...
reshape(Y1{9}(:,i_9,:),[r_Length(8),r_Length(9)])*reshape(Y1{10}(:,i_10,:),[r_Length(9),r_Length(10)])*...
reshape(Y1{11}(:,i_11,:),[r_Length(10),r_Length(11)])*reshape(Y1{12}(:,i_12,:),[r_Length(11),r_Length(12)])*Y1{13}(:,i_13))^2;
end
end
end
end
end
end
end
end
end
end
end
end
end

MSE2(8,ii_11)=MSE_CA_N/MSE_CA_D;
MSE3(8,ii_11)=MSE_CA_N1/MSE_CA_D;

end

%% Given a full tensor %Full tensor %14-order
%
for ii_11=1:NumberofIterations

n_TT = [2, 2, 2, 2, 2, 2, 2, 2,2,2,2,2,2,2];%the unmber of n_TT equals to d_TT
d_TT=14;
r_TT=[1,2,2,2,2,2,2,2,2,2,2,2,2,2,1];%the unmber of rank=d_TT+1,rank_0=1,rank_N=1,we choose other positions
A_low_rank_TT_Tensor=tt_random(n_TT,d_TT,r_TT);
A_low_rank_TT_Tensor_vector=full(A_low_rank_TT_Tensor);
A=reshape(A_low_rank_TT_Tensor_vector,n_TT); %From TT-Tensor to original Tensor
B=reshape(A,[2,2^(d_TT-1)]);
B_value=norm(B,'fro');
A=A/B_value;
%
LowRankError_Tensor=randn(2, 2, 2, 2, 2, 2,2,2,2,2,2,2,2,2);
C=reshape(LowRankError_Tensor,[2,2^(d_TT-1)]);
C_value=norm(C,'fro');
LowRankError_Tensor=LowRankError_Tensor/C_value;
%
MeasurementError_Tensor=zeros(n_TT);
for i_1=1:n_TT(1);
for i_2=1:n_TT(2);
for i_3=1:n_TT(3);
for i_4=1:n_TT(4);
for i_5=1:n_TT(5);
for i_6=1:n_TT(6);
for i_7=1:n_TT(7);  
for i_8=1:n_TT(8);   
for i_9=1:n_TT(9);  
for i_10=1:n_TT(10);  
for i_11=1:n_TT(11);  
for i_12=1:n_TT(12);  
for i_13=1:n_TT(13); 
for i_14=1:n_TT(14); 
MeasurementError_Tensor(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12,i_13,i_14)=mu_set*randn(1,1)/sqrt((d_TT-2)*32+2*8-16);
end
end
end
end
end
end
end
end
end
end
end
end
end
end
%

nswp=100; % Maximum Number of iterations
eta=eta_set;
Length_r_max=Length_r_max_design;% Estimated rank =Length_r_max-1

%
B=A+eta*LowRankError_Tensor;
C=B+MeasurementError_Tensor;
fun = @(ind) C(ind(1), ind(2), ind(3), ind(4), ind(5), ind(6), ind(7), ind(8), ind(9), ind(10), ind(11), ind(12), ind(13), ind(14) );
[y,Jyl,Jyr,ilocl,ilocr,evalcnt,Error_final]=greedy2_cross_Version_ZhenQin1(n_TT, fun, 1e-15, nswp, Length_r_max, []);

% Using Tau to truncate the diagonal matrix of SVD
tau=0;
tau1=Tau_design;
r_Length=zeros(length(ilocl)-2,1);
for iii=1:length(ilocl)-2
    r_Length(iii)=length(ilocl{iii+1});
end
Tensor=C;

[Y]=AddingTau(ilocl,ilocr,Tensor,n_TT,r_Length,tau);
[Y1]=AddingTau(ilocl,ilocr,Tensor,n_TT,r_Length,tau1);



MSE_CA_N=0;
MSE_CA_N1=0;
MSE_CA_D=0;
for i_1=1:n_TT(1);
for i_2=1:n_TT(2);
for i_3=1:n_TT(3);
for i_4=1:n_TT(4);
for i_5=1:n_TT(5);
for i_6=1:n_TT(6);
for i_7=1:n_TT(7);
for i_8=1:n_TT(8);
for i_9=1:n_TT(9);
for i_10=1:n_TT(10);
for i_11=1:n_TT(11);
for i_12=1:n_TT(12);
for i_13=1:n_TT(13);
for i_14=1:n_TT(14);
%
MSE_CA_D=MSE_CA_D+B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12,i_13,i_14)^2;
%
MSE_CA_N=MSE_CA_N+(B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12,i_13,i_14)-Y{1}(i_1,:)*reshape(Y{2}(:,i_2,:),[r_Length(1),r_Length(2)])*...
reshape(Y{3}(:,i_3,:),[r_Length(2),r_Length(3)])*reshape(Y{4}(:,i_4,:),[r_Length(3),r_Length(4)])*...
reshape(Y{5}(:,i_5,:),[r_Length(4),r_Length(5)])*reshape(Y{6}(:,i_6,:),[r_Length(5),r_Length(6)])*...
reshape(Y{7}(:,i_7,:),[r_Length(6),r_Length(7)])*reshape(Y{8}(:,i_8,:),[r_Length(7),r_Length(8)])*...
reshape(Y{9}(:,i_9,:),[r_Length(8),r_Length(9)])*reshape(Y{10}(:,i_10,:),[r_Length(9),r_Length(10)])*...
reshape(Y{11}(:,i_11,:),[r_Length(10),r_Length(11)])*reshape(Y{12}(:,i_12,:),[r_Length(11),r_Length(12)])*...
reshape(Y{13}(:,i_13,:),[r_Length(12),r_Length(13)])*Y{14}(:,i_14))^2;
%
MSE_CA_N1=MSE_CA_N1+(B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12,i_13,i_14)-Y1{1}(i_1,:)*reshape(Y1{2}(:,i_2,:),[r_Length(1),r_Length(2)])*...
reshape(Y1{3}(:,i_3,:),[r_Length(2),r_Length(3)])*reshape(Y1{4}(:,i_4,:),[r_Length(3),r_Length(4)])*...
reshape(Y1{5}(:,i_5,:),[r_Length(4),r_Length(5)])*reshape(Y1{6}(:,i_6,:),[r_Length(5),r_Length(6)])*...
reshape(Y1{7}(:,i_7,:),[r_Length(6),r_Length(7)])*reshape(Y1{8}(:,i_8,:),[r_Length(7),r_Length(8)])*...
reshape(Y1{9}(:,i_9,:),[r_Length(8),r_Length(9)])*reshape(Y1{10}(:,i_10,:),[r_Length(9),r_Length(10)])*...
reshape(Y1{11}(:,i_11,:),[r_Length(10),r_Length(11)])*reshape(Y1{12}(:,i_12,:),[r_Length(11),r_Length(12)])*...
reshape(Y1{13}(:,i_13,:),[r_Length(12),r_Length(13)])*Y1{14}(:,i_14))^2;
end
end
end
end
end
end
end
end
end
end
end
end
end
end

MSE2(9,ii_11)=MSE_CA_N/MSE_CA_D;
MSE3(9,ii_11)=MSE_CA_N1/MSE_CA_D;

end

%% Given a full tensor %Full tensor %15-order

%
for ii_11=1:NumberofIterations


n_TT = [2, 2, 2, 2, 2, 2, 2, 2,2,2,2,2,2,2,2];%the unmber of n_TT equals to d_TT
d_TT=15;
r_TT=[1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1];%the unmber of rank=d_TT+1,rank_0=1,rank_N=1,we choose other positions
A_low_rank_TT_Tensor=tt_random(n_TT,d_TT,r_TT);
A_low_rank_TT_Tensor_vector=full(A_low_rank_TT_Tensor);
A=reshape(A_low_rank_TT_Tensor_vector,n_TT); %From TT-Tensor to original Tensor
B=reshape(A,[2,2^(d_TT-1)]);
B_value=norm(B,'fro');
A=A/B_value;
%
LowRankError_Tensor=randn(2, 2, 2, 2, 2, 2,2,2,2,2,2,2,2,2,2);
C=reshape(LowRankError_Tensor,[2,2^(d_TT-1)]);
C_value=norm(C,'fro');
LowRankError_Tensor=LowRankError_Tensor/C_value;
%
MeasurementError_Tensor=zeros(n_TT);
for i_1=1:n_TT(1);
for i_2=1:n_TT(2);
for i_3=1:n_TT(3);
for i_4=1:n_TT(4);
for i_5=1:n_TT(5);
for i_6=1:n_TT(6);
for i_7=1:n_TT(7);  
for i_8=1:n_TT(8);   
for i_9=1:n_TT(9);  
for i_10=1:n_TT(10);  
for i_11=1:n_TT(11);  
for i_12=1:n_TT(12);  
for i_13=1:n_TT(13); 
for i_14=1:n_TT(14); 
for i_15=1:n_TT(15);
MeasurementError_Tensor(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12,i_13,i_14,i_15)=mu_set*randn(1,1)/sqrt((d_TT-2)*32+2*8-16);
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
%

nswp=100; % Maximum Number of iterations
eta=eta_set;
Length_r_max=Length_r_max_design;% Estimated rank =Length_r_max-1

%
B=A+eta*LowRankError_Tensor;
C=B+MeasurementError_Tensor;
fun = @(ind) C(ind(1), ind(2), ind(3), ind(4), ind(5), ind(6), ind(7), ind(8), ind(9), ind(10), ind(11), ind(12), ind(13), ind(14), ind(15) );
[y,Jyl,Jyr,ilocl,ilocr,evalcnt,Error_final]=greedy2_cross_Version_ZhenQin1(n_TT, fun, 1e-15, nswp, Length_r_max, []);

% Using Tau to truncate the diagonal matrix of SVD
tau=0;
tau1=Tau_design;
r_Length=zeros(length(ilocl)-2,1);
for iii=1:length(ilocl)-2
    r_Length(iii)=length(ilocl{iii+1});
end
Tensor=C;

[Y]=AddingTau(ilocl,ilocr,Tensor,n_TT,r_Length,tau);
[Y1]=AddingTau(ilocl,ilocr,Tensor,n_TT,r_Length,tau1);



MSE_CA_N=0;
MSE_CA_N1=0;
MSE_CA_D=0;
for i_1=1:n_TT(1);
for i_2=1:n_TT(2);
for i_3=1:n_TT(3);
for i_4=1:n_TT(4);
for i_5=1:n_TT(5);
for i_6=1:n_TT(6);
for i_7=1:n_TT(7);
for i_8=1:n_TT(8);
for i_9=1:n_TT(9);
for i_10=1:n_TT(10);
for i_11=1:n_TT(11);
for i_12=1:n_TT(12);
for i_13=1:n_TT(13);
for i_14=1:n_TT(14);
for i_15=1:n_TT(15);
%
MSE_CA_D=MSE_CA_D+B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12,i_13,i_14,i_15)^2;
%
MSE_CA_N=MSE_CA_N+(B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12,i_13,i_14,i_15)-Y{1}(i_1,:)*reshape(Y{2}(:,i_2,:),[r_Length(1),r_Length(2)])*...
reshape(Y{3}(:,i_3,:),[r_Length(2),r_Length(3)])*reshape(Y{4}(:,i_4,:),[r_Length(3),r_Length(4)])*...
reshape(Y{5}(:,i_5,:),[r_Length(4),r_Length(5)])*reshape(Y{6}(:,i_6,:),[r_Length(5),r_Length(6)])*...
reshape(Y{7}(:,i_7,:),[r_Length(6),r_Length(7)])*reshape(Y{8}(:,i_8,:),[r_Length(7),r_Length(8)])*...
reshape(Y{9}(:,i_9,:),[r_Length(8),r_Length(9)])*reshape(Y{10}(:,i_10,:),[r_Length(9),r_Length(10)])*...
reshape(Y{11}(:,i_11,:),[r_Length(10),r_Length(11)])*reshape(Y{12}(:,i_12,:),[r_Length(11),r_Length(12)])*...
reshape(Y{13}(:,i_13,:),[r_Length(12),r_Length(13)])*reshape(Y{14}(:,i_14,:),[r_Length(13),r_Length(14)])*Y{15}(:,i_15))^2;
%
MSE_CA_N1=MSE_CA_N1+(B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12,i_13,i_14,i_15)-Y1{1}(i_1,:)*reshape(Y1{2}(:,i_2,:),[r_Length(1),r_Length(2)])*...
reshape(Y1{3}(:,i_3,:),[r_Length(2),r_Length(3)])*reshape(Y1{4}(:,i_4,:),[r_Length(3),r_Length(4)])*...
reshape(Y1{5}(:,i_5,:),[r_Length(4),r_Length(5)])*reshape(Y1{6}(:,i_6,:),[r_Length(5),r_Length(6)])*...
reshape(Y1{7}(:,i_7,:),[r_Length(6),r_Length(7)])*reshape(Y1{8}(:,i_8,:),[r_Length(7),r_Length(8)])*...
reshape(Y1{9}(:,i_9,:),[r_Length(8),r_Length(9)])*reshape(Y1{10}(:,i_10,:),[r_Length(9),r_Length(10)])*...
reshape(Y1{11}(:,i_11,:),[r_Length(10),r_Length(11)])*reshape(Y1{12}(:,i_12,:),[r_Length(11),r_Length(12)])*...
reshape(Y1{13}(:,i_13,:),[r_Length(12),r_Length(13)])*reshape(Y1{14}(:,i_14,:),[r_Length(13),r_Length(14)])*Y1{15}(:,i_15))^2;
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end

MSE2(10,ii_11)=MSE_CA_N/MSE_CA_D;
MSE3(10,ii_11)=MSE_CA_N1/MSE_CA_D;

end

%% Given a full tensor %Full tensor %16-order

for ii_11=1:NumberofIterations

%
n_TT = [2, 2, 2, 2, 2, 2, 2, 2,2,2,2,2,2,2,2,2];%the unmber of n_TT equals to d_TT
d_TT=16;
r_TT=[1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1];%the unmber of rank=d_TT+1,rank_0=1,rank_N=1,we choose other positions
A_low_rank_TT_Tensor=tt_random(n_TT,d_TT,r_TT);
A_low_rank_TT_Tensor_vector=full(A_low_rank_TT_Tensor);
A=reshape(A_low_rank_TT_Tensor_vector,n_TT); %From TT-Tensor to original Tensor
B=reshape(A,[2,2^(d_TT-1)]);
B_value=norm(B,'fro');
A=A/B_value;
%
LowRankError_Tensor=randn(2, 2, 2, 2, 2, 2,2,2,2,2,2,2,2,2,2,2);
C=reshape(LowRankError_Tensor,[2,2^(d_TT-1)]);
C_value=norm(C,'fro');
LowRankError_Tensor=LowRankError_Tensor/C_value;
%
MeasurementError_Tensor=zeros(n_TT);
for i_1=1:n_TT(1);
for i_2=1:n_TT(2);
for i_3=1:n_TT(3);
for i_4=1:n_TT(4);
for i_5=1:n_TT(5);
for i_6=1:n_TT(6);
for i_7=1:n_TT(7);  
for i_8=1:n_TT(8);   
for i_9=1:n_TT(9);  
for i_10=1:n_TT(10);  
for i_11=1:n_TT(11);  
for i_12=1:n_TT(12);  
for i_13=1:n_TT(13); 
for i_14=1:n_TT(14); 
for i_15=1:n_TT(15);
for i_16=1:n_TT(16);
MeasurementError_Tensor(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12,i_13,i_14,i_15,i_16)=mu_set*randn(1,1)/sqrt((d_TT-2)*32+2*8-16);
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
%

nswp=100; % Maximum Number of iterations
eta=eta_set;
Length_r_max=Length_r_max_design;% Estimated rank =Length_r_max-1

%
B=A+eta*LowRankError_Tensor;
C=B+MeasurementError_Tensor;
fun = @(ind) C(ind(1), ind(2), ind(3), ind(4), ind(5), ind(6), ind(7), ind(8), ind(9), ind(10), ind(11), ind(12), ind(13), ind(14), ind(15), ind(16) );
[y,Jyl,Jyr,ilocl,ilocr,evalcnt,Error_final]=greedy2_cross_Version_ZhenQin1(n_TT, fun, 1e-15, nswp, Length_r_max, []);

% Using Tau to truncate the diagonal matrix of SVD
tau=0;
tau1=Tau_design;
r_Length=zeros(length(ilocl)-2,1);
for iii=1:length(ilocl)-2
    r_Length(iii)=length(ilocl{iii+1});
end
Tensor=C;

[Y]=AddingTau(ilocl,ilocr,Tensor,n_TT,r_Length,tau);
[Y1]=AddingTau(ilocl,ilocr,Tensor,n_TT,r_Length,tau1);



MSE_CA_N=0;
MSE_CA_N1=0;
MSE_CA_D=0;
for i_1=1:n_TT(1);
for i_2=1:n_TT(2);
for i_3=1:n_TT(3);
for i_4=1:n_TT(4);
for i_5=1:n_TT(5);
for i_6=1:n_TT(6);
for i_7=1:n_TT(7);
for i_8=1:n_TT(8);
for i_9=1:n_TT(9);
for i_10=1:n_TT(10);
for i_11=1:n_TT(11);
for i_12=1:n_TT(12);
for i_13=1:n_TT(13);
for i_14=1:n_TT(14);
for i_15=1:n_TT(15);
for i_16=1:n_TT(16);
%
MSE_CA_D=MSE_CA_D+B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12,i_13,i_14,i_15,i_16)^2;
%
MSE_CA_N=MSE_CA_N+(B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12,i_13,i_14,i_15,i_16)-Y{1}(i_1,:)*reshape(Y{2}(:,i_2,:),[r_Length(1),r_Length(2)])*...
reshape(Y{3}(:,i_3,:),[r_Length(2),r_Length(3)])*reshape(Y{4}(:,i_4,:),[r_Length(3),r_Length(4)])*...
reshape(Y{5}(:,i_5,:),[r_Length(4),r_Length(5)])*reshape(Y{6}(:,i_6,:),[r_Length(5),r_Length(6)])*...
reshape(Y{7}(:,i_7,:),[r_Length(6),r_Length(7)])*reshape(Y{8}(:,i_8,:),[r_Length(7),r_Length(8)])*...
reshape(Y{9}(:,i_9,:),[r_Length(8),r_Length(9)])*reshape(Y{10}(:,i_10,:),[r_Length(9),r_Length(10)])*...
reshape(Y{11}(:,i_11,:),[r_Length(10),r_Length(11)])*reshape(Y{12}(:,i_12,:),[r_Length(11),r_Length(12)])*...
reshape(Y{13}(:,i_13,:),[r_Length(12),r_Length(13)])*reshape(Y{14}(:,i_14,:),[r_Length(13),r_Length(14)])*...
reshape(Y{15}(:,i_15,:),[r_Length(14),r_Length(15)])*Y{16}(:,i_16))^2;
%
MSE_CA_N1=MSE_CA_N1+(B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12,i_13,i_14,i_15,i_16)-Y1{1}(i_1,:)*reshape(Y1{2}(:,i_2,:),[r_Length(1),r_Length(2)])*...
reshape(Y1{3}(:,i_3,:),[r_Length(2),r_Length(3)])*reshape(Y1{4}(:,i_4,:),[r_Length(3),r_Length(4)])*...
reshape(Y1{5}(:,i_5,:),[r_Length(4),r_Length(5)])*reshape(Y1{6}(:,i_6,:),[r_Length(5),r_Length(6)])*...
reshape(Y1{7}(:,i_7,:),[r_Length(6),r_Length(7)])*reshape(Y1{8}(:,i_8,:),[r_Length(7),r_Length(8)])*...
reshape(Y1{9}(:,i_9,:),[r_Length(8),r_Length(9)])*reshape(Y1{10}(:,i_10,:),[r_Length(9),r_Length(10)])*...
reshape(Y1{11}(:,i_11,:),[r_Length(10),r_Length(11)])*reshape(Y1{12}(:,i_12,:),[r_Length(11),r_Length(12)])*...
reshape(Y1{13}(:,i_13,:),[r_Length(12),r_Length(13)])*reshape(Y1{14}(:,i_14,:),[r_Length(13),r_Length(14)])*...
reshape(Y1{15}(:,i_15,:),[r_Length(14),r_Length(15)])*Y1{16}(:,i_16))^2;
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end

MSE2(11,ii_11)=MSE_CA_N/MSE_CA_D;
MSE3(11,ii_11)=MSE_CA_N1/MSE_CA_D;

end

%% Given a full tensor %Full tensor %17-order

for ii_11=1:NumberofIterations

%
n_TT = [2, 2, 2, 2, 2, 2, 2, 2,2,2,2,2,2,2,2,2,2];%the unmber of n_TT equals to d_TT
d_TT=17;
r_TT=[1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1];%the unmber of rank=d_TT+1,rank_0=1,rank_N=1,we choose other positions
A_low_rank_TT_Tensor=tt_random(n_TT,d_TT,r_TT);
A_low_rank_TT_Tensor_vector=full(A_low_rank_TT_Tensor);
A=reshape(A_low_rank_TT_Tensor_vector,n_TT); %From TT-Tensor to original Tensor
B=reshape(A,[2,2^(d_TT-1)]);
B_value=norm(B,'fro');
A=A/B_value;
%
LowRankError_Tensor=randn(2, 2, 2, 2, 2, 2,2,2,2,2,2,2,2,2,2,2,2);
C=reshape(LowRankError_Tensor,[2,2^(d_TT-1)]);
C_value=norm(C,'fro');
LowRankError_Tensor=LowRankError_Tensor/C_value;
%
MeasurementError_Tensor=zeros(n_TT);
for i_1=1:n_TT(1);
for i_2=1:n_TT(2);
for i_3=1:n_TT(3);
for i_4=1:n_TT(4);
for i_5=1:n_TT(5);
for i_6=1:n_TT(6);
for i_7=1:n_TT(7);  
for i_8=1:n_TT(8);   
for i_9=1:n_TT(9);  
for i_10=1:n_TT(10);  
for i_11=1:n_TT(11);  
for i_12=1:n_TT(12);  
for i_13=1:n_TT(13); 
for i_14=1:n_TT(14); 
for i_15=1:n_TT(15);
for i_16=1:n_TT(16);
for i_17=1:n_TT(17);
MeasurementError_Tensor(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12,i_13,i_14,i_15,i_16,i_17)=mu_set*randn(1,1)/sqrt((d_TT-2)*32+2*8-16);
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
%

nswp=100; % Maximum Number of iterations
eta=eta_set;
Length_r_max=Length_r_max_design;% Estimated rank =Length_r_max-1

%
B=A+eta*LowRankError_Tensor;
C=B+MeasurementError_Tensor;
fun = @(ind) C(ind(1), ind(2), ind(3), ind(4), ind(5), ind(6), ind(7), ind(8), ind(9), ind(10), ind(11), ind(12), ind(13), ind(14), ind(15), ind(16), ind(17) );
[y,Jyl,Jyr,ilocl,ilocr,evalcnt,Error_final]=greedy2_cross_Version_ZhenQin1(n_TT, fun, 1e-15, nswp, Length_r_max, []);

% Using Tau to truncate the diagonal matrix of SVD
tau=0;
tau1=Tau_design;
r_Length=zeros(length(ilocl)-2,1);
for iii=1:length(ilocl)-2
    r_Length(iii)=length(ilocl{iii+1});
end
Tensor=C;

[Y]=AddingTau(ilocl,ilocr,Tensor,n_TT,r_Length,tau);
[Y1]=AddingTau(ilocl,ilocr,Tensor,n_TT,r_Length,tau1);



MSE_CA_N=0;
MSE_CA_N1=0;
MSE_CA_D=0;
for i_1=1:n_TT(1);
for i_2=1:n_TT(2);
for i_3=1:n_TT(3);
for i_4=1:n_TT(4);
for i_5=1:n_TT(5);
for i_6=1:n_TT(6);
for i_7=1:n_TT(7);
for i_8=1:n_TT(8);
for i_9=1:n_TT(9);
for i_10=1:n_TT(10);
for i_11=1:n_TT(11);
for i_12=1:n_TT(12);
for i_13=1:n_TT(13);
for i_14=1:n_TT(14);
for i_15=1:n_TT(15);
for i_16=1:n_TT(16);
for i_17=1:n_TT(17);
%
MSE_CA_D=MSE_CA_D+B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12,i_13,i_14,i_15,i_16,i_17)^2;
%
MSE_CA_N=MSE_CA_N+(B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12,i_13,i_14,i_15,i_16,i_17)-Y{1}(i_1,:)*reshape(Y{2}(:,i_2,:),[r_Length(1),r_Length(2)])*...
reshape(Y{3}(:,i_3,:),[r_Length(2),r_Length(3)])*reshape(Y{4}(:,i_4,:),[r_Length(3),r_Length(4)])*...
reshape(Y{5}(:,i_5,:),[r_Length(4),r_Length(5)])*reshape(Y{6}(:,i_6,:),[r_Length(5),r_Length(6)])*...
reshape(Y{7}(:,i_7,:),[r_Length(6),r_Length(7)])*reshape(Y{8}(:,i_8,:),[r_Length(7),r_Length(8)])*...
reshape(Y{9}(:,i_9,:),[r_Length(8),r_Length(9)])*reshape(Y{10}(:,i_10,:),[r_Length(9),r_Length(10)])*...
reshape(Y{11}(:,i_11,:),[r_Length(10),r_Length(11)])*reshape(Y{12}(:,i_12,:),[r_Length(11),r_Length(12)])*...
reshape(Y{13}(:,i_13,:),[r_Length(12),r_Length(13)])*reshape(Y{14}(:,i_14,:),[r_Length(13),r_Length(14)])*...
reshape(Y{15}(:,i_15,:),[r_Length(14),r_Length(15)])*reshape(Y{16}(:,i_16,:),[r_Length(15),r_Length(16)])*Y{17}(:,i_17))^2;
%
MSE_CA_N1=MSE_CA_N1+(B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12,i_13,i_14,i_15,i_16,i_17)-Y1{1}(i_1,:)*reshape(Y1{2}(:,i_2,:),[r_Length(1),r_Length(2)])*...
reshape(Y1{3}(:,i_3,:),[r_Length(2),r_Length(3)])*reshape(Y1{4}(:,i_4,:),[r_Length(3),r_Length(4)])*...
reshape(Y1{5}(:,i_5,:),[r_Length(4),r_Length(5)])*reshape(Y1{6}(:,i_6,:),[r_Length(5),r_Length(6)])*...
reshape(Y1{7}(:,i_7,:),[r_Length(6),r_Length(7)])*reshape(Y1{8}(:,i_8,:),[r_Length(7),r_Length(8)])*...
reshape(Y1{9}(:,i_9,:),[r_Length(8),r_Length(9)])*reshape(Y1{10}(:,i_10,:),[r_Length(9),r_Length(10)])*...
reshape(Y1{11}(:,i_11,:),[r_Length(10),r_Length(11)])*reshape(Y1{12}(:,i_12,:),[r_Length(11),r_Length(12)])*...
reshape(Y1{13}(:,i_13,:),[r_Length(12),r_Length(13)])*reshape(Y1{14}(:,i_14,:),[r_Length(13),r_Length(14)])*...
reshape(Y1{15}(:,i_15,:),[r_Length(14),r_Length(15)])*reshape(Y1{16}(:,i_16,:),[r_Length(15),r_Length(16)])*Y1{17}(:,i_17))^2;
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end

MSE2(12,ii_11)=MSE_CA_N/MSE_CA_D;
MSE3(12,ii_11)=MSE_CA_N1/MSE_CA_D;


end
%% Given a full tensor %Full tensor %18-order

for ii_11=1:NumberofIterations
%
n_TT = [2, 2, 2, 2, 2,2, 2, 2, 2,2, 2, 2, 2, 2,2, 2, 2, 2];%the unmber of n_TT equals to d_TT
d_TT=18;
r_TT=[1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1];%the unmber of rank=d_TT+1,rank_0=1,rank_N=1,we choose other positions
A_low_rank_TT_Tensor=tt_random(n_TT,d_TT,r_TT);
A_low_rank_TT_Tensor_vector=full(A_low_rank_TT_Tensor);
A=reshape(A_low_rank_TT_Tensor_vector,n_TT); %From TT-Tensor to original Tensor
B=reshape(A,[2,2^(d_TT-1)]);
B_value=norm(B,'fro');
A=A/B_value;
%
LowRankError_Tensor=randn(2, 2, 2, 2, 2,2, 2, 2, 2,2, 2, 2, 2, 2,2, 2, 2, 2 );
C=reshape(LowRankError_Tensor,[2,2^(d_TT-1)]);
C_value=norm(C,'fro');
LowRankError_Tensor=LowRankError_Tensor/C_value;
%
MeasurementError_Tensor=zeros(n_TT);
for i_1=1:n_TT(1);
for i_2=1:n_TT(2);
for i_3=1:n_TT(3);
for i_4=1:n_TT(4);
for i_5=1:n_TT(5);
for i_6=1:n_TT(6);
for i_7=1:n_TT(7);  
for i_8=1:n_TT(8);   
for i_9=1:n_TT(9);  
for i_10=1:n_TT(10);  
for i_11=1:n_TT(11);  
for i_12=1:n_TT(12);  
for i_13=1:n_TT(13); 
for i_14=1:n_TT(14); 
for i_15=1:n_TT(15);
for i_16=1:n_TT(16);
for i_17=1:n_TT(17);
for i_18=1:n_TT(18);
MeasurementError_Tensor(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12,i_13,i_14,i_15,i_16,i_17,i_18)=mu_set*randn(1,1)/sqrt((d_TT-2)*32+2*8-16);
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
%

nswp=100; % Maximum Number of iterations
eta=eta_set;
Length_r_max=Length_r_max_design;% Estimated rank =Length_r_max-1

%
B=A+eta*LowRankError_Tensor;
C=B+MeasurementError_Tensor;
fun = @(ind) C(ind(1), ind(2), ind(3), ind(4), ind(5), ind(6), ind(7), ind(8), ind(9), ind(10), ind(11), ind(12), ind(13), ind(14), ind(15), ind(16), ind(17), ind(18) );
[y,Jyl,Jyr,ilocl,ilocr,evalcnt,Error_final]=greedy2_cross_Version_ZhenQin1(n_TT, fun, 1e-15, nswp, Length_r_max, []);

% Using Tau to truncate the diagonal matrix of SVD
tau=0;
tau1=Tau_design;
r_Length=zeros(length(ilocl)-2,1);
for iii=1:length(ilocl)-2
    r_Length(iii)=length(ilocl{iii+1});
end
Tensor=C;

[Y]=AddingTau(ilocl,ilocr,Tensor,n_TT,r_Length,tau);
[Y1]=AddingTau(ilocl,ilocr,Tensor,n_TT,r_Length,tau1);



MSE_CA_N=0;
MSE_CA_N1=0;
MSE_CA_D=0;
for i_1=1:n_TT(1);
for i_2=1:n_TT(2);
for i_3=1:n_TT(3);
for i_4=1:n_TT(4);
for i_5=1:n_TT(5);
for i_6=1:n_TT(6);
for i_7=1:n_TT(7);
for i_8=1:n_TT(8);
for i_9=1:n_TT(9);
for i_10=1:n_TT(10);
for i_11=1:n_TT(11);
for i_12=1:n_TT(12);
for i_13=1:n_TT(13);
for i_14=1:n_TT(14);
for i_15=1:n_TT(15);
for i_16=1:n_TT(16);
for i_17=1:n_TT(17);
for i_18=1:n_TT(18);
%
MSE_CA_D=MSE_CA_D+B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12,i_13,i_14,i_15,i_16,i_17,i_18)^2;
%
MSE_CA_N=MSE_CA_N+(B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12,i_13,i_14,i_15,i_16,i_17,i_18)-Y{1}(i_1,:)*reshape(Y{2}(:,i_2,:),[r_Length(1),r_Length(2)])*...
reshape(Y{3}(:,i_3,:),[r_Length(2),r_Length(3)])*reshape(Y{4}(:,i_4,:),[r_Length(3),r_Length(4)])*...
reshape(Y{5}(:,i_5,:),[r_Length(4),r_Length(5)])*reshape(Y{6}(:,i_6,:),[r_Length(5),r_Length(6)])*...
reshape(Y{7}(:,i_7,:),[r_Length(6),r_Length(7)])*reshape(Y{8}(:,i_8,:),[r_Length(7),r_Length(8)])*...
reshape(Y{9}(:,i_9,:),[r_Length(8),r_Length(9)])*reshape(Y{10}(:,i_10,:),[r_Length(9),r_Length(10)])*...
reshape(Y{11}(:,i_11,:),[r_Length(10),r_Length(11)])*reshape(Y{12}(:,i_12,:),[r_Length(11),r_Length(12)])*...
reshape(Y{13}(:,i_13,:),[r_Length(12),r_Length(13)])*reshape(Y{14}(:,i_14,:),[r_Length(13),r_Length(14)])*...
reshape(Y{15}(:,i_15,:),[r_Length(14),r_Length(15)])*reshape(Y{16}(:,i_16,:),[r_Length(15),r_Length(16)])*...
reshape(Y{17}(:,i_17,:),[r_Length(16),r_Length(17)])*Y{18}(:,i_18))^2;
%
MSE_CA_N1=MSE_CA_N1+(B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12,i_13,i_14,i_15,i_16,i_17,i_18)-Y1{1}(i_1,:)*reshape(Y1{2}(:,i_2,:),[r_Length(1),r_Length(2)])*...
reshape(Y1{3}(:,i_3,:),[r_Length(2),r_Length(3)])*reshape(Y1{4}(:,i_4,:),[r_Length(3),r_Length(4)])*...
reshape(Y1{5}(:,i_5,:),[r_Length(4),r_Length(5)])*reshape(Y1{6}(:,i_6,:),[r_Length(5),r_Length(6)])*...
reshape(Y1{7}(:,i_7,:),[r_Length(6),r_Length(7)])*reshape(Y1{8}(:,i_8,:),[r_Length(7),r_Length(8)])*...
reshape(Y1{9}(:,i_9,:),[r_Length(8),r_Length(9)])*reshape(Y1{10}(:,i_10,:),[r_Length(9),r_Length(10)])*...
reshape(Y1{11}(:,i_11,:),[r_Length(10),r_Length(11)])*reshape(Y1{12}(:,i_12,:),[r_Length(11),r_Length(12)])*...
reshape(Y1{13}(:,i_13,:),[r_Length(12),r_Length(13)])*reshape(Y1{14}(:,i_14,:),[r_Length(13),r_Length(14)])*...
reshape(Y1{15}(:,i_15,:),[r_Length(14),r_Length(15)])*reshape(Y1{16}(:,i_16,:),[r_Length(15),r_Length(16)])*...
reshape(Y1{17}(:,i_17,:),[r_Length(16),r_Length(17)])*Y1{18}(:,i_18))^2;
%                                     MSE_CA_N=MSE_CA_N+(A(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9)-Y{1}(i_1,:)*reshape(Y{2}(:,i_2,:),[r_TT(2),r_TT(3)])*...
% reshape(Y{3}(:,i_3,:),[r_TT(3),r_TT(4)])*reshape(Y{4}(:,i_4,:),[r_TT(4),r_TT(5)])*...
% reshape(Y{5}(:,i_5,:),[r_TT(5),r_TT(6)])*reshape(Y{6}(:,i_6,:),[r_TT(6),r_TT(7)])*...
% reshape(Y{7}(:,i_7,:),[r_TT(7),r_TT(8)])*reshape(Y{8}(:,i_8,:),[r_TT(8),r_TT(9)])*Y{9}(:,i_9))^2;
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end

MSE2(13,ii_11)=MSE_CA_N/MSE_CA_D;
MSE3(13,ii_11)=MSE_CA_N1/MSE_CA_D;

end

%% Given a full tensor %Full tensor %19-order
%
for ii_11=1:NumberofIterations

n_TT = [2, 2, 2, 2, 2,2, 2, 2, 2,2, 2, 2, 2, 2,2, 2, 2, 2,2];%the unmber of n_TT equals to d_TT
d_TT=19;
r_TT=[1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1];%the unmber of rank=d_TT+1,rank_0=1,rank_N=1,we choose other positions
A_low_rank_TT_Tensor=tt_random(n_TT,d_TT,r_TT);
A_low_rank_TT_Tensor_vector=full(A_low_rank_TT_Tensor);
A=reshape(A_low_rank_TT_Tensor_vector,n_TT); %From TT-Tensor to original Tensor
B=reshape(A,[2,2^(d_TT-1)]);
B_value=norm(B,'fro');
A=A/B_value;
%
LowRankError_Tensor=randn(2, 2, 2, 2, 2,2, 2, 2, 2,2, 2, 2, 2, 2,2, 2, 2, 2,2 );
C=reshape(LowRankError_Tensor,[2,2^(d_TT-1)]);
C_value=norm(C,'fro');
LowRankError_Tensor=LowRankError_Tensor/C_value;
%
MeasurementError_Tensor=zeros(n_TT);
for i_1=1:n_TT(1);
for i_2=1:n_TT(2);
for i_3=1:n_TT(3);
for i_4=1:n_TT(4);
for i_5=1:n_TT(5);
for i_6=1:n_TT(6);
for i_7=1:n_TT(7);  
for i_8=1:n_TT(8);   
for i_9=1:n_TT(9);  
for i_10=1:n_TT(10);  
for i_11=1:n_TT(11);  
for i_12=1:n_TT(12);  
for i_13=1:n_TT(13); 
for i_14=1:n_TT(14); 
for i_15=1:n_TT(15);
for i_16=1:n_TT(16);
for i_17=1:n_TT(17);
for i_18=1:n_TT(18);
for i_19=1:n_TT(19);
MeasurementError_Tensor(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12,i_13,i_14,i_15,i_16,i_17,i_18,i_19)=mu_set*randn(1,1)/sqrt((d_TT-2)*32+2*8-16);
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
%

nswp=100; % Maximum Number of iterations
eta=eta_set;
Length_r_max=Length_r_max_design;% Estimated rank =Length_r_max-1

%
B=A+eta*LowRankError_Tensor;
C=B+MeasurementError_Tensor;
fun = @(ind) C(ind(1), ind(2), ind(3), ind(4), ind(5), ind(6), ind(7), ind(8), ind(9), ind(10), ind(11), ind(12), ind(13), ind(14), ind(15), ind(16), ind(17), ind(18), ind(19) );
[y,Jyl,Jyr,ilocl,ilocr,evalcnt,Error_final]=greedy2_cross_Version_ZhenQin1(n_TT, fun, 1e-15, nswp, Length_r_max, []);

% Using Tau to truncate the diagonal matrix of SVD
tau=0;
tau1=Tau_design;
r_Length=zeros(length(ilocl)-2,1);
for iii=1:length(ilocl)-2
    r_Length(iii)=length(ilocl{iii+1});
end
Tensor=C;

[Y]=AddingTau(ilocl,ilocr,Tensor,n_TT,r_Length,tau);
[Y1]=AddingTau(ilocl,ilocr,Tensor,n_TT,r_Length,tau1);



MSE_CA_N=0;
MSE_CA_N1=0;
MSE_CA_D=0;
for i_1=1:n_TT(1);
for i_2=1:n_TT(2);
for i_3=1:n_TT(3);
for i_4=1:n_TT(4);
for i_5=1:n_TT(5);
for i_6=1:n_TT(6);
for i_7=1:n_TT(7);
for i_8=1:n_TT(8);
for i_9=1:n_TT(9);
for i_10=1:n_TT(10);
for i_11=1:n_TT(11);
for i_12=1:n_TT(12);
for i_13=1:n_TT(13);
for i_14=1:n_TT(14);
for i_15=1:n_TT(15);
for i_16=1:n_TT(16);
for i_17=1:n_TT(17);
for i_18=1:n_TT(18);
for i_19=1:n_TT(19);
%
MSE_CA_D=MSE_CA_D+B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12,i_13,i_14,i_15,i_16,i_17,i_18,i_19)^2;
%
MSE_CA_N=MSE_CA_N+(B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12,i_13,i_14,i_15,i_16,i_17,i_18,i_19)-Y{1}(i_1,:)*reshape(Y{2}(:,i_2,:),[r_Length(1),r_Length(2)])*...
reshape(Y{3}(:,i_3,:),[r_Length(2),r_Length(3)])*reshape(Y{4}(:,i_4,:),[r_Length(3),r_Length(4)])*...
reshape(Y{5}(:,i_5,:),[r_Length(4),r_Length(5)])*reshape(Y{6}(:,i_6,:),[r_Length(5),r_Length(6)])*...
reshape(Y{7}(:,i_7,:),[r_Length(6),r_Length(7)])*reshape(Y{8}(:,i_8,:),[r_Length(7),r_Length(8)])*...
reshape(Y{9}(:,i_9,:),[r_Length(8),r_Length(9)])*reshape(Y{10}(:,i_10,:),[r_Length(9),r_Length(10)])*...
reshape(Y{11}(:,i_11,:),[r_Length(10),r_Length(11)])*reshape(Y{12}(:,i_12,:),[r_Length(11),r_Length(12)])*...
reshape(Y{13}(:,i_13,:),[r_Length(12),r_Length(13)])*reshape(Y{14}(:,i_14,:),[r_Length(13),r_Length(14)])*...
reshape(Y{15}(:,i_15,:),[r_Length(14),r_Length(15)])*reshape(Y{16}(:,i_16,:),[r_Length(15),r_Length(16)])*...
reshape(Y{17}(:,i_17,:),[r_Length(16),r_Length(17)])*reshape(Y{18}(:,i_18,:),[r_Length(17),r_Length(18)])*Y{19}(:,i_19))^2;
%
MSE_CA_N1=MSE_CA_N1+(B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12,i_13,i_14,i_15,i_16,i_17,i_18,i_19)-Y1{1}(i_1,:)*reshape(Y1{2}(:,i_2,:),[r_Length(1),r_Length(2)])*...
reshape(Y1{3}(:,i_3,:),[r_Length(2),r_Length(3)])*reshape(Y1{4}(:,i_4,:),[r_Length(3),r_Length(4)])*...
reshape(Y1{5}(:,i_5,:),[r_Length(4),r_Length(5)])*reshape(Y1{6}(:,i_6,:),[r_Length(5),r_Length(6)])*...
reshape(Y1{7}(:,i_7,:),[r_Length(6),r_Length(7)])*reshape(Y1{8}(:,i_8,:),[r_Length(7),r_Length(8)])*...
reshape(Y1{9}(:,i_9,:),[r_Length(8),r_Length(9)])*reshape(Y1{10}(:,i_10,:),[r_Length(9),r_Length(10)])*...
reshape(Y1{11}(:,i_11,:),[r_Length(10),r_Length(11)])*reshape(Y1{12}(:,i_12,:),[r_Length(11),r_Length(12)])*...
reshape(Y1{13}(:,i_13,:),[r_Length(12),r_Length(13)])*reshape(Y1{14}(:,i_14,:),[r_Length(13),r_Length(14)])*...
reshape(Y1{15}(:,i_15,:),[r_Length(14),r_Length(15)])*reshape(Y1{16}(:,i_16,:),[r_Length(15),r_Length(16)])*...
reshape(Y1{17}(:,i_17,:),[r_Length(16),r_Length(17)])*reshape(Y1{18}(:,i_18,:),[r_Length(17),r_Length(18)])*Y1{19}(:,i_19))^2;
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end

MSE2(14,ii_11)=MSE_CA_N/MSE_CA_D;
MSE3(14,ii_11)=MSE_CA_N1/MSE_CA_D;

end

%% Given a full tensor %Full tensor %20-order

for ii_11=1:NumberofIterations

%
n_TT = [2, 2, 2, 2, 2,2, 2, 2, 2,2, 2, 2, 2, 2,2, 2, 2, 2,2,2];%the unmber of n_TT equals to d_TT
d_TT=20;
r_TT=[1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1];%the unmber of rank=d_TT+1,rank_0=1,rank_N=1,we choose other positions
A_low_rank_TT_Tensor=tt_random(n_TT,d_TT,r_TT);
A_low_rank_TT_Tensor_vector=full(A_low_rank_TT_Tensor);
A=reshape(A_low_rank_TT_Tensor_vector,n_TT); %From TT-Tensor to original Tensor
B=reshape(A,[2,2^(d_TT-1)]);
B_value=norm(B,'fro');
A=A/B_value;
%
LowRankError_Tensor=randn(2, 2, 2, 2, 2,2, 2, 2, 2,2, 2, 2, 2, 2,2, 2, 2, 2,2,2 );
C=reshape(LowRankError_Tensor,[2,2^(d_TT-1)]);
C_value=norm(C,'fro');
LowRankError_Tensor=LowRankError_Tensor/C_value;
%
MeasurementError_Tensor=zeros(n_TT);
for i_1=1:n_TT(1);
for i_2=1:n_TT(2);
for i_3=1:n_TT(3);
for i_4=1:n_TT(4);
for i_5=1:n_TT(5);
for i_6=1:n_TT(6);
for i_7=1:n_TT(7);  
for i_8=1:n_TT(8);   
for i_9=1:n_TT(9);  
for i_10=1:n_TT(10);  
for i_11=1:n_TT(11);  
for i_12=1:n_TT(12);  
for i_13=1:n_TT(13); 
for i_14=1:n_TT(14); 
for i_15=1:n_TT(15);
for i_16=1:n_TT(16);
for i_17=1:n_TT(17);
for i_18=1:n_TT(18);
for i_19=1:n_TT(19);
for i_20=1:n_TT(20);
MeasurementError_Tensor(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12,i_13,i_14,i_15,i_16,i_17,i_18,i_19,i_20)=mu_set*randn(1,1)/sqrt((d_TT-2)*32+2*8-16);
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
%

nswp=100; % Maximum Number of iterations
eta=eta_set;
Length_r_max=Length_r_max_design;% Estimated rank =Length_r_max-1

%
B=A+eta*LowRankError_Tensor;
C=B+MeasurementError_Tensor;
fun = @(ind) C(ind(1), ind(2), ind(3), ind(4), ind(5), ind(6), ind(7), ind(8), ind(9), ind(10), ind(11), ind(12), ind(13), ind(14), ind(15), ind(16), ind(17), ind(18), ind(19), ind(20) );
[y,Jyl,Jyr,ilocl,ilocr,evalcnt,Error_final]=greedy2_cross_Version_ZhenQin1(n_TT, fun, 1e-15, nswp, Length_r_max, []);

% Using Tau to truncate the diagonal matrix of SVD
tau=0;
tau1=Tau_design;
r_Length=zeros(length(ilocl)-2,1);
for iii=1:length(ilocl)-2
    r_Length(iii)=length(ilocl{iii+1});
end
Tensor=C;

[Y]=AddingTau(ilocl,ilocr,Tensor,n_TT,r_Length,tau);
[Y1]=AddingTau(ilocl,ilocr,Tensor,n_TT,r_Length,tau1);



MSE_CA_N=0;
MSE_CA_N1=0;
MSE_CA_D=0;
for i_1=1:n_TT(1);
for i_2=1:n_TT(2);
for i_3=1:n_TT(3);
for i_4=1:n_TT(4);
for i_5=1:n_TT(5);
for i_6=1:n_TT(6);
for i_7=1:n_TT(7);
for i_8=1:n_TT(8);
for i_9=1:n_TT(9);
for i_10=1:n_TT(10);
for i_11=1:n_TT(11);
for i_12=1:n_TT(12);
for i_13=1:n_TT(13);
for i_14=1:n_TT(14);
for i_15=1:n_TT(15);
for i_16=1:n_TT(16);
for i_17=1:n_TT(17);
for i_18=1:n_TT(18);
for i_19=1:n_TT(19);
for i_20=1:n_TT(20);
%
MSE_CA_D=MSE_CA_D+B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12,i_13,i_14,i_15,i_16,i_17,i_18,i_19,i_20)^2;
%
MSE_CA_N=MSE_CA_N+(B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12,i_13,i_14,i_15,i_16,i_17,i_18,i_19,i_20)-Y{1}(i_1,:)*reshape(Y{2}(:,i_2,:),[r_Length(1),r_Length(2)])*...
reshape(Y{3}(:,i_3,:),[r_Length(2),r_Length(3)])*reshape(Y{4}(:,i_4,:),[r_Length(3),r_Length(4)])*...
reshape(Y{5}(:,i_5,:),[r_Length(4),r_Length(5)])*reshape(Y{6}(:,i_6,:),[r_Length(5),r_Length(6)])*...
reshape(Y{7}(:,i_7,:),[r_Length(6),r_Length(7)])*reshape(Y{8}(:,i_8,:),[r_Length(7),r_Length(8)])*...
reshape(Y{9}(:,i_9,:),[r_Length(8),r_Length(9)])*reshape(Y{10}(:,i_10,:),[r_Length(9),r_Length(10)])*...
reshape(Y{11}(:,i_11,:),[r_Length(10),r_Length(11)])*reshape(Y{12}(:,i_12,:),[r_Length(11),r_Length(12)])*...
reshape(Y{13}(:,i_13,:),[r_Length(12),r_Length(13)])*reshape(Y{14}(:,i_14,:),[r_Length(13),r_Length(14)])*...
reshape(Y{15}(:,i_15,:),[r_Length(14),r_Length(15)])*reshape(Y{16}(:,i_16,:),[r_Length(15),r_Length(16)])*...
reshape(Y{17}(:,i_17,:),[r_Length(16),r_Length(17)])*reshape(Y{18}(:,i_18,:),[r_Length(17),r_Length(18)])*...
reshape(Y{19}(:,i_19,:),[r_Length(18),r_Length(19)])*Y{20}(:,i_20))^2;
%
MSE_CA_N1=MSE_CA_N1+(B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12,i_13,i_14,i_15,i_16,i_17,i_18,i_19,i_20)-Y1{1}(i_1,:)*reshape(Y1{2}(:,i_2,:),[r_Length(1),r_Length(2)])*...
reshape(Y1{3}(:,i_3,:),[r_Length(2),r_Length(3)])*reshape(Y1{4}(:,i_4,:),[r_Length(3),r_Length(4)])*...
reshape(Y1{5}(:,i_5,:),[r_Length(4),r_Length(5)])*reshape(Y1{6}(:,i_6,:),[r_Length(5),r_Length(6)])*...
reshape(Y1{7}(:,i_7,:),[r_Length(6),r_Length(7)])*reshape(Y1{8}(:,i_8,:),[r_Length(7),r_Length(8)])*...
reshape(Y1{9}(:,i_9,:),[r_Length(8),r_Length(9)])*reshape(Y1{10}(:,i_10,:),[r_Length(9),r_Length(10)])*...
reshape(Y1{11}(:,i_11,:),[r_Length(10),r_Length(11)])*reshape(Y1{12}(:,i_12,:),[r_Length(11),r_Length(12)])*...
reshape(Y1{13}(:,i_13,:),[r_Length(12),r_Length(13)])*reshape(Y1{14}(:,i_14,:),[r_Length(13),r_Length(14)])*...
reshape(Y1{15}(:,i_15,:),[r_Length(14),r_Length(15)])*reshape(Y1{16}(:,i_16,:),[r_Length(15),r_Length(16)])*...
reshape(Y1{17}(:,i_17,:),[r_Length(16),r_Length(17)])*reshape(Y1{18}(:,i_18,:),[r_Length(17),r_Length(18)])*...
reshape(Y1{19}(:,i_19,:),[r_Length(18),r_Length(19)])*Y1{20}(:,i_20))^2;
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end

MSE2(15,ii_11)=MSE_CA_N/MSE_CA_D;
MSE3(15,ii_11)=MSE_CA_N1/MSE_CA_D;

end

%% Given a full tensor %Full tensor %21-order

for ii_11=1:NumberofIterations

%
n_TT = [2, 2, 2, 2, 2,2, 2, 2, 2,2, 2, 2, 2, 2,2, 2, 2, 2,2,2,2];%the unmber of n_TT equals to d_TT
d_TT=21;
r_TT=[1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1];%the unmber of rank=d_TT+1,rank_0=1,rank_N=1,we choose other positions
A_low_rank_TT_Tensor=tt_random(n_TT,d_TT,r_TT);
A_low_rank_TT_Tensor_vector=full(A_low_rank_TT_Tensor);
A=reshape(A_low_rank_TT_Tensor_vector,n_TT); %From TT-Tensor to original Tensor
B=reshape(A,[2,2^(d_TT-1)]);
B_value=norm(B,'fro');
A=A/B_value;
%
LowRankError_Tensor=randn(2, 2, 2, 2, 2,2, 2, 2, 2,2, 2, 2, 2, 2,2, 2, 2, 2,2,2,2 );
C=reshape(LowRankError_Tensor,[2,2^(d_TT-1)]);
C_value=norm(C,'fro');
LowRankError_Tensor=LowRankError_Tensor/C_value;
%
MeasurementError_Tensor=zeros(n_TT);
for i_1=1:n_TT(1);
for i_2=1:n_TT(2);
for i_3=1:n_TT(3);
for i_4=1:n_TT(4);
for i_5=1:n_TT(5);
for i_6=1:n_TT(6);
for i_7=1:n_TT(7);  
for i_8=1:n_TT(8);   
for i_9=1:n_TT(9);  
for i_10=1:n_TT(10);  
for i_11=1:n_TT(11);  
for i_12=1:n_TT(12);  
for i_13=1:n_TT(13); 
for i_14=1:n_TT(14); 
for i_15=1:n_TT(15);
for i_16=1:n_TT(16);
for i_17=1:n_TT(17);
for i_18=1:n_TT(18);
for i_19=1:n_TT(19);
for i_20=1:n_TT(20);
for i_21=1:n_TT(21);
MeasurementError_Tensor(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12,i_13,i_14,i_15,i_16,i_17,i_18,i_19,i_20,i_21)=mu_set*randn(1,1)/sqrt((d_TT-2)*32+2*8-16);
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
%

nswp=100; % Maximum Number of iterations
eta=eta_set;
Length_r_max=Length_r_max_design;% Estimated rank =Length_r_max-1

%
B=A+eta*LowRankError_Tensor;
C=B+MeasurementError_Tensor;
fun = @(ind) C(ind(1), ind(2), ind(3), ind(4), ind(5), ind(6), ind(7), ind(8), ind(9), ind(10), ind(11), ind(12), ind(13), ind(14), ind(15), ind(16), ind(17), ind(18), ind(19), ind(20), ind(21) );
[y,Jyl,Jyr,ilocl,ilocr,evalcnt,Error_final]=greedy2_cross_Version_ZhenQin1(n_TT, fun, 1e-15, nswp, Length_r_max, []);

% Using Tau to truncate the diagonal matrix of SVD
tau=0;
tau1=Tau_design;
r_Length=zeros(length(ilocl)-2,1);
for iii=1:length(ilocl)-2
    r_Length(iii)=length(ilocl{iii+1});
end
Tensor=C;

[Y]=AddingTau(ilocl,ilocr,Tensor,n_TT,r_Length,tau);
[Y1]=AddingTau(ilocl,ilocr,Tensor,n_TT,r_Length,tau1);



MSE_CA_N=0;
MSE_CA_N1=0;
MSE_CA_D=0;
for i_1=1:n_TT(1);
for i_2=1:n_TT(2);
for i_3=1:n_TT(3);
for i_4=1:n_TT(4);
for i_5=1:n_TT(5);
for i_6=1:n_TT(6);
for i_7=1:n_TT(7);
for i_8=1:n_TT(8);
for i_9=1:n_TT(9);
for i_10=1:n_TT(10);
for i_11=1:n_TT(11);
for i_12=1:n_TT(12);
for i_13=1:n_TT(13);
for i_14=1:n_TT(14);
for i_15=1:n_TT(15);
for i_16=1:n_TT(16);
for i_17=1:n_TT(17);
for i_18=1:n_TT(18);
for i_19=1:n_TT(19);
for i_20=1:n_TT(20);
for i_21=1:n_TT(21);
%
MSE_CA_D=MSE_CA_D+B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12,i_13,i_14,i_15,i_16,i_17,i_18,i_19,i_20,i_21)^2;
%
MSE_CA_N=MSE_CA_N+(B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12,i_13,i_14,i_15,i_16,i_17,i_18,i_19,i_20,i_21)-Y{1}(i_1,:)*reshape(Y{2}(:,i_2,:),[r_Length(1),r_Length(2)])*...
reshape(Y{3}(:,i_3,:),[r_Length(2),r_Length(3)])*reshape(Y{4}(:,i_4,:),[r_Length(3),r_Length(4)])*...
reshape(Y{5}(:,i_5,:),[r_Length(4),r_Length(5)])*reshape(Y{6}(:,i_6,:),[r_Length(5),r_Length(6)])*...
reshape(Y{7}(:,i_7,:),[r_Length(6),r_Length(7)])*reshape(Y{8}(:,i_8,:),[r_Length(7),r_Length(8)])*...
reshape(Y{9}(:,i_9,:),[r_Length(8),r_Length(9)])*reshape(Y{10}(:,i_10,:),[r_Length(9),r_Length(10)])*...
reshape(Y{11}(:,i_11,:),[r_Length(10),r_Length(11)])*reshape(Y{12}(:,i_12,:),[r_Length(11),r_Length(12)])*...
reshape(Y{13}(:,i_13,:),[r_Length(12),r_Length(13)])*reshape(Y{14}(:,i_14,:),[r_Length(13),r_Length(14)])*...
reshape(Y{15}(:,i_15,:),[r_Length(14),r_Length(15)])*reshape(Y{16}(:,i_16,:),[r_Length(15),r_Length(16)])*...
reshape(Y{17}(:,i_17,:),[r_Length(16),r_Length(17)])*reshape(Y{18}(:,i_18,:),[r_Length(17),r_Length(18)])*...
reshape(Y{19}(:,i_19,:),[r_Length(18),r_Length(19)])*reshape(Y{20}(:,i_20,:),[r_Length(19),r_Length(20)])*Y{21}(:,i_21))^2;
%
MSE_CA_N1=MSE_CA_N1+(B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12,i_13,i_14,i_15,i_16,i_17,i_18,i_19,i_20,i_21)-Y1{1}(i_1,:)*reshape(Y1{2}(:,i_2,:),[r_Length(1),r_Length(2)])*...
reshape(Y1{3}(:,i_3,:),[r_Length(2),r_Length(3)])*reshape(Y1{4}(:,i_4,:),[r_Length(3),r_Length(4)])*...
reshape(Y1{5}(:,i_5,:),[r_Length(4),r_Length(5)])*reshape(Y1{6}(:,i_6,:),[r_Length(5),r_Length(6)])*...
reshape(Y1{7}(:,i_7,:),[r_Length(6),r_Length(7)])*reshape(Y1{8}(:,i_8,:),[r_Length(7),r_Length(8)])*...
reshape(Y1{9}(:,i_9,:),[r_Length(8),r_Length(9)])*reshape(Y1{10}(:,i_10,:),[r_Length(9),r_Length(10)])*...
reshape(Y1{11}(:,i_11,:),[r_Length(10),r_Length(11)])*reshape(Y1{12}(:,i_12,:),[r_Length(11),r_Length(12)])*...
reshape(Y1{13}(:,i_13,:),[r_Length(12),r_Length(13)])*reshape(Y1{14}(:,i_14,:),[r_Length(13),r_Length(14)])*...
reshape(Y1{15}(:,i_15,:),[r_Length(14),r_Length(15)])*reshape(Y1{16}(:,i_16,:),[r_Length(15),r_Length(16)])*...
reshape(Y1{17}(:,i_17,:),[r_Length(16),r_Length(17)])*reshape(Y1{18}(:,i_18,:),[r_Length(17),r_Length(18)])*...
reshape(Y1{19}(:,i_19,:),[r_Length(18),r_Length(19)])*reshape(Y1{20}(:,i_20,:),[r_Length(19),r_Length(20)])*Y1{21}(:,i_21))^2;
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end

MSE2(16,ii_11)=MSE_CA_N/MSE_CA_D;
MSE3(16,ii_11)=MSE_CA_N1/MSE_CA_D;

end

%% Given a full tensor %Full tensor %22-order

for ii_11=1:NumberofIterations
%
n_TT = [2, 2, 2, 2, 2,2, 2, 2, 2,2, 2, 2, 2, 2,2, 2, 2, 2,2,2,2,2];%the unmber of n_TT equals to d_TT
d_TT=22;
r_TT=[1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1];%the unmber of rank=d_TT+1,rank_0=1,rank_N=1,we choose other positions
A_low_rank_TT_Tensor=tt_random(n_TT,d_TT,r_TT);
A_low_rank_TT_Tensor_vector=full(A_low_rank_TT_Tensor);
A=reshape(A_low_rank_TT_Tensor_vector,n_TT); %From TT-Tensor to original Tensor
B=reshape(A,[2,2^(d_TT-1)]);
B_value=norm(B,'fro');
A=A/B_value;
%
LowRankError_Tensor=randn(2, 2, 2, 2, 2,2, 2, 2, 2,2, 2, 2, 2, 2,2, 2, 2, 2,2,2,2,2 );
C=reshape(LowRankError_Tensor,[2,2^(d_TT-1)]);
C_value=norm(C,'fro');
LowRankError_Tensor=LowRankError_Tensor/C_value;
%
MeasurementError_Tensor=zeros(n_TT);
for i_1=1:n_TT(1);
for i_2=1:n_TT(2);
for i_3=1:n_TT(3);
for i_4=1:n_TT(4);
for i_5=1:n_TT(5);
for i_6=1:n_TT(6);
for i_7=1:n_TT(7);  
for i_8=1:n_TT(8);   
for i_9=1:n_TT(9);  
for i_10=1:n_TT(10);  
for i_11=1:n_TT(11);  
for i_12=1:n_TT(12);  
for i_13=1:n_TT(13); 
for i_14=1:n_TT(14); 
for i_15=1:n_TT(15);
for i_16=1:n_TT(16);
for i_17=1:n_TT(17);
for i_18=1:n_TT(18);
for i_19=1:n_TT(19);
for i_20=1:n_TT(20);
for i_21=1:n_TT(21);
for i_22=1:n_TT(22);
MeasurementError_Tensor(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12,i_13,i_14,i_15,i_16,i_17,i_18,i_19,i_20,i_21,i_22)=mu_set*randn(1,1)/sqrt((d_TT-2)*32+2*8-16);
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
%

nswp=100; % Maximum Number of iterations
eta=eta_set;
Length_r_max=Length_r_max_design;% Estimated rank =Length_r_max-1

%
B=A+eta*LowRankError_Tensor;
C=B+MeasurementError_Tensor;
fun = @(ind) C(ind(1), ind(2), ind(3), ind(4), ind(5), ind(6), ind(7), ind(8), ind(9), ind(10), ind(11), ind(12), ind(13), ind(14), ind(15), ind(16), ind(17), ind(18), ind(19), ind(20),...
    ind(21),ind(22) );
[y,Jyl,Jyr,ilocl,ilocr,evalcnt,Error_final]=greedy2_cross_Version_ZhenQin1(n_TT, fun, 1e-15, nswp, Length_r_max, []);

% Using Tau to truncate the diagonal matrix of SVD
tau=0;
tau1=Tau_design;
r_Length=zeros(length(ilocl)-2,1);
for iii=1:length(ilocl)-2
    r_Length(iii)=length(ilocl{iii+1});
end
Tensor=C;

[Y]=AddingTau(ilocl,ilocr,Tensor,n_TT,r_Length,tau);
[Y1]=AddingTau(ilocl,ilocr,Tensor,n_TT,r_Length,tau1);



MSE_CA_N=0;
MSE_CA_N1=0;
MSE_CA_D=0;
for i_1=1:n_TT(1);
for i_2=1:n_TT(2);
for i_3=1:n_TT(3);
for i_4=1:n_TT(4);
for i_5=1:n_TT(5);
for i_6=1:n_TT(6);
for i_7=1:n_TT(7);
for i_8=1:n_TT(8);
for i_9=1:n_TT(9);
for i_10=1:n_TT(10);
for i_11=1:n_TT(11);
for i_12=1:n_TT(12);
for i_13=1:n_TT(13);
for i_14=1:n_TT(14);
for i_15=1:n_TT(15);
for i_16=1:n_TT(16);
for i_17=1:n_TT(17);
for i_18=1:n_TT(18);
for i_19=1:n_TT(19);
for i_20=1:n_TT(20);
for i_21=1:n_TT(21);
for i_22=1:n_TT(22);
%
MSE_CA_D=MSE_CA_D+B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12,i_13,i_14,i_15,i_16,i_17,i_18,i_19,i_20,i_21,i_22)^2;
%
MSE_CA_N=MSE_CA_N+(B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12,i_13,i_14,i_15,i_16,i_17,i_18,i_19,i_20,i_21,i_22)...
    -Y{1}(i_1,:)*reshape(Y{2}(:,i_2,:),[r_Length(1),r_Length(2)])*...
reshape(Y{3}(:,i_3,:),[r_Length(2),r_Length(3)])*reshape(Y{4}(:,i_4,:),[r_Length(3),r_Length(4)])*...
reshape(Y{5}(:,i_5,:),[r_Length(4),r_Length(5)])*reshape(Y{6}(:,i_6,:),[r_Length(5),r_Length(6)])*...
reshape(Y{7}(:,i_7,:),[r_Length(6),r_Length(7)])*reshape(Y{8}(:,i_8,:),[r_Length(7),r_Length(8)])*...
reshape(Y{9}(:,i_9,:),[r_Length(8),r_Length(9)])*reshape(Y{10}(:,i_10,:),[r_Length(9),r_Length(10)])*...
reshape(Y{11}(:,i_11,:),[r_Length(10),r_Length(11)])*reshape(Y{12}(:,i_12,:),[r_Length(11),r_Length(12)])*...
reshape(Y{13}(:,i_13,:),[r_Length(12),r_Length(13)])*reshape(Y{14}(:,i_14,:),[r_Length(13),r_Length(14)])*...
reshape(Y{15}(:,i_15,:),[r_Length(14),r_Length(15)])*reshape(Y{16}(:,i_16,:),[r_Length(15),r_Length(16)])*...
reshape(Y{17}(:,i_17,:),[r_Length(16),r_Length(17)])*reshape(Y{18}(:,i_18,:),[r_Length(17),r_Length(18)])*...
reshape(Y{19}(:,i_19,:),[r_Length(18),r_Length(19)])*reshape(Y{20}(:,i_20,:),[r_Length(19),r_Length(20)])*...
reshape(Y{21}(:,i_21,:),[r_Length(20),r_Length(21)])*Y{22}(:,i_22))^2;
%
MSE_CA_N1=MSE_CA_N1+(B(i_1,i_2,i_3,i_4,i_5,i_6,i_7,i_8,i_9,i_10,i_11,i_12,i_13,i_14,i_15,i_16,i_17,i_18,i_19,i_20,i_21,i_22)...
    -Y1{1}(i_1,:)*reshape(Y1{2}(:,i_2,:),[r_Length(1),r_Length(2)])*...
reshape(Y1{3}(:,i_3,:),[r_Length(2),r_Length(3)])*reshape(Y1{4}(:,i_4,:),[r_Length(3),r_Length(4)])*...
reshape(Y1{5}(:,i_5,:),[r_Length(4),r_Length(5)])*reshape(Y1{6}(:,i_6,:),[r_Length(5),r_Length(6)])*...
reshape(Y1{7}(:,i_7,:),[r_Length(6),r_Length(7)])*reshape(Y1{8}(:,i_8,:),[r_Length(7),r_Length(8)])*...
reshape(Y1{9}(:,i_9,:),[r_Length(8),r_Length(9)])*reshape(Y1{10}(:,i_10,:),[r_Length(9),r_Length(10)])*...
reshape(Y1{11}(:,i_11,:),[r_Length(10),r_Length(11)])*reshape(Y1{12}(:,i_12,:),[r_Length(11),r_Length(12)])*...
reshape(Y1{13}(:,i_13,:),[r_Length(12),r_Length(13)])*reshape(Y1{14}(:,i_14,:),[r_Length(13),r_Length(14)])*...
reshape(Y1{15}(:,i_15,:),[r_Length(14),r_Length(15)])*reshape(Y1{16}(:,i_16,:),[r_Length(15),r_Length(16)])*...
reshape(Y1{17}(:,i_17,:),[r_Length(16),r_Length(17)])*reshape(Y1{18}(:,i_18,:),[r_Length(17),r_Length(18)])*...
reshape(Y1{19}(:,i_19,:),[r_Length(18),r_Length(19)])*reshape(Y1{20}(:,i_20,:),[r_Length(19),r_Length(20)])*...
reshape(Y1{21}(:,i_21,:),[r_Length(20),r_Length(21)])*Y1{22}(:,i_22))^2;
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end
end

MSE2(17,ii_11)=MSE_CA_N/MSE_CA_D;
MSE3(17,ii_11)=MSE_CA_N1/MSE_CA_D;

end


%%

NumberofIterations1=NumberofIterations*ones(17,1);
NumberofIterations2=NumberofIterations*ones(17,1);
NumberofIterations3=NumberofIterations*ones(17,1);
NumberofIterations4=NumberofIterations*ones(17,1);
% for jjj=1:17
% for iii=1:NumberofIterations
%     if MSE(jjj,iii)<1000
%         MSE(jjj,iii)=MSE(jjj,iii);
%     else
%         MSE(jjj,iii)=0;
%         NumberofIterations1(jjj)=NumberofIterations1(jjj)-1;
%     end
% end
% end
% for jjj=1:17
% for iii=1:NumberofIterations
%     if MSE1(jjj,iii)<1000
%         MSE1(jjj,iii)=MSE1(jjj,iii);
%     else
%         MSE1(jjj,iii)=0;
%         NumberofIterations2(jjj)=NumberofIterations2(jjj)-1;
%     end
% end
% end
% for jjj=1:17
% for iii=1:NumberofIterations
%     if MSE2(jjj,iii)<1000
%         MSE2(jjj,iii)=MSE2(jjj,iii);
%     else
%         MSE2(jjj,iii)=0;
%         NumberofIterations3(jjj)=NumberofIterations3(jjj)-1;
%     end
% end
% end
% for jjj=1:17
% for iii=1:NumberofIterations
%     if MSE3(jjj,iii)<1000
%         MSE3(jjj,iii)=MSE3(jjj,iii);
%     else
%         MSE3(jjj,iii)=0;
%         NumberofIterations4(jjj)=NumberofIterations4(jjj)-1;
%     end
% end
% end

MSE_average_CUR_advance=sum(MSE,2)./NumberofIterations1;
MSE_tau_average_CUR_advance=sum(MSE1,2)./NumberofIterations2;
MSE_average_CUR_advance1=sum(MSE2,2)./NumberofIterations3;
MSE_tau_average_CUR_advance1=sum(MSE3,2)./NumberofIterations4;

MSE_average_CUR=10*log10(MSE_average_CUR_advance);
MSE_tau_average_CUR=10*log10(MSE_tau_average_CUR_advance);
MSE_average_CUR1=10*log10(MSE_average_CUR_advance1);
MSE_tau_average_CUR1=10*log10(MSE_tau_average_CUR_advance1);

figure(1)
X=6:1:22;
A=plot(X,MSE_average_CUR,'-kh',X,MSE_tau_average_CUR,'-r*',X,MSE_average_CUR1,'-bs',X,MSE_tau_average_CUR1,'-m^');
set(A,'LineWidth',2);
legend('\tau=0 ({\it{r}}=2)','\tau=10^{-7} ({\it{r}}=2)','\tau=0 ({\it{r}}=4)','\tau=10^{-7} ({\it{r}}=4)',...
    'FontSize',12,'FontName', 'Times New Roman','Interpreter','LaTex')
xlabel('$N$','FontSize',12,'FontName', 'Times New Roman','Interpreter','LaTex')
ylabel('MSE (dB) ')
grid on;

figure(2)
X=6:1:22;
A=plot(X,MSE_average_CUR_advance,'-kh',X,MSE_tau_average_CUR_advance,'-r*',X,MSE_average_CUR_advance1,'-bs',X,MSE_tau_average_CUR_advance1,'-m^');
set(A,'LineWidth',2);
legend('\tau=0 (r=2)','\tau=10^{-7} (r=2)','\tau=0 (r=4)','\tau=10^{-7} (r=4)')
xlabel('N')
ylabel('MSE ')
grid on;





