Code used for implementing the simulations in the paper "Anonymous Bandits for Multi-User Systems".

The script `generate_data.py` can either plot one run of data (using `plot_one_run`) or generate several runs of data and save them to disk (using `generate_many_runs`). The script `analyze_data.py` reads in data output by `generate_many_runs` and plots the cumulative regret of all algorithms used along with CIs. Both scripts can easily be modified by changing the parameters at the top of the script. 

Some other files of note:
- `framework.py` defines the general anonymous bandits learning framework that the learning algorithms interact with. It also contains code for instantiating specific classes of instance (e.g. uniform rewards and the linear model).
- `bandits.py` contains the code for the various bandits algorithms -- UCB, explore-then-commit, BaSE, and Algorithm 1 (minus the choice of decomposition algorithm).
- `decomposition.py` contains the code for the various decomposition algorithms -- greedy decomposition, randomized decomposition, and LP decomposition. 
- `parameters.py` contains some parameters used by various algorithms (e.g. the threshold for eliminating arms in BaSE).
- `tune_parameters.py` contains scripts for tuning the parameters in `parameters.py` (by grid search).