total_time = 1024; %1024
K = 50; 
T_range = round(logspace(log10(60),log10(4000),11)); %30 2000 60 4000
error_probs1 = zeros(length(T_range), 7);
for ii = 1 : length(T_range)
    T = T_range(ii);
    error_prob1 = zeros(total_time, 1);
    error_prob2 = zeros(total_time, 1);
    error_prob3 = zeros(total_time, 1);
    error_prob4 = zeros(total_time, 1);
    error_prob5 = zeros(total_time, 1);
    error_prob6 = zeros(total_time, 1);
    error_prob7 = zeros(total_time, 1);
    parfor jj = 1 : total_time
        %[theta, A] = usual_data_generator(d);
        %[theta, A] = sphere_data_generator(d, K);
        rng((T - 1) * total_time + jj);
        [theta, A] = many_sub_data_generator(K);
        [~ , I] = max(theta' * A);
        best_arm = myalgo(theta, A, T);
        if I ~= best_arm
            error_prob1(jj) = 1;
        end
        best_arm = Sequential_Halving(theta, A, T);
        if I ~= best_arm
            error_prob2(jj) = 1;
        end
        best_arm = BayesGap_Oracle(theta, A, T);
        if I ~= best_arm
            error_prob3(jj) = 1;
        end
        best_arm = BayesGap_Adaptive(theta, A, T);
        if I ~= best_arm
            error_prob4(jj) = 1;
        end
        best_arm = Peace(theta, A, T);
        if I ~= best_arm
            error_prob5(jj) = 1;
        end
        best_arm = LinearExploration(theta, A, T);
        if I ~= best_arm
            error_prob6(jj) = 1;
        end
        best_arm = GSE(theta, A, T);
        if I ~= best_arm
            error_prob7(jj) = 1;
        end
        [jj, T]
    end
    error_probs1(ii, :) = sum([error_prob1, error_prob2, error_prob3, error_prob4, error_prob5, error_prob6, error_prob7]) / total_time;
end


%figure('Position',[0 0 450 300]);
figure;
set(gcf,'PaperPositionMode','auto');
markers = {'none', '.', '*', 'x', 'o', '+', 's'};
for i = 1 : 7
    semilogx(T_range, error_probs1(:, i),'Linewidth', 1.2, 'Marker', markers{i});
    hold on;
end
grid;
xlabel('$T$', 'FontSize',16,'Interpreter','latex');
ylabel('Error probability', 'FontSize',16,'Interpreter','latex');
legend('OD-LinBAI', 'Sequential Halving', 'BayesGap-Oracle', 'BayesGap-Adaptive','Peace', 'LinearExploration', 'GSE', 'FontSize', 16, 'Interpreter','latex',  'Location', 'NorthWest');
ylim([0 1]);
% xlim([50 2000]);
% xticks([50 100 500 1000 2000]);
% xticklabels({'5\times10^1','10^2', '5\times10^2', '10^3','2\times10^3'});

save('K=50.mat','T_range', 'error_probs1');
