import numpy as np
import math

def icd_gauss(x, alpha, tol, nmax):

	m = x.shape[1] #/* dimension of input space might be greater than 1*/
	n = x.shape[0] #/* number of samples */

	diagG = np.zeros(n)
	diagK = np.zeros(n)

	G = np.zeros((n, nmax))

	pp = list(range(n)) # pivot

	itr=0
	trK = 0
	for i in range(n):
		diagK[i] = 1.0 #  /* diagonal of the Gaussian kernel is 1 */
		diagG[i] = diagK[i]
		trK += diagK[i]

	residual = trK
	jast = 0

	while ( ( residual > tol ) and ( itr < nmax ) ):
		#/* switches already calculated elements of G and order in pp */
		if (jast!=itr):
			i=pp[jast]
			pp[jast]=pp[itr]
			pp[itr]=i
			for i in range(itr+1): # pivotting
				tmp = G[jast, i]
				G[jast, i] = G[itr, i]
				G[itr, i] = tmp
			
		G[itr, itr] = np.sqrt(diagG[jast])
		a = -alpha


		for i in range(itr+1, n): 
			if (m<=1):
				b=(x[pp[itr]]-x[pp[i]])*(x[pp[itr]]-x[pp[i]])
			else:
				b=0.0
				for j in range(m):
					c=x[pp[itr], j]-x[pp[i], j]
					b+=c*c
			G[i, itr]=np.exp(a*b)

		if itr>0:
			for j in range(itr):
				for i in range(itr+1, n):
					G[i, itr]-=G[i, j]*G[itr, j]

		for i in range(itr+1, n):
			G[i, itr]/=G[itr, itr]


		# Compute the residual
	 
		residual = 0.0
		jast = itr+1
		maxdiagG = 0

		for i in range(itr+1, n):
			b=diagK[pp[i]]
			for j in range(itr + 1):
				b-=G[i, j]*G[i, j]
			diagG[i]=b
			if (b>maxdiagG):
				jast=i
				maxdiagG=b
			residual+=b
		itr+=1
	return G, pp, itr, residual/trK 



def icd_bern_s1(x, tol, nmax):

	m = 1 #/* dimension of input space is 1 (kernel on torus in 1d) */
	n = x.shape[0] #/* number of samples */

	diagG = np.zeros(n)
	diagK = np.zeros(n)

	G = np.zeros((n, nmax))

	pp = list(range(n)) # pivot

	itr=0
	trK = 0
	for i in range(n):
		diagK[i] = math.pi**2/3. + 1. #  /* diagonal of the Bernoulli s1 kernel is this */
		diagG[i] = diagK[i]
		trK += diagK[i]

	residual = trK
	jast = 0

	while ( ( residual > tol ) and ( itr < nmax ) ):
		#/* switches already calculated elements of G and order in pp */
		if (jast!=itr):
			i=pp[jast]
			pp[jast]=pp[itr]
			pp[itr]=i
			for i in range(itr+1): # pivotting
				tmp = G[jast, i]
				G[jast, i] = G[itr, i]
				G[itr, i] = tmp
			
		G[itr, itr] = np.sqrt(diagG[jast])
		

		for i in range(itr+1, n):
			u = x[pp[itr]]
			v = x[pp[i]]
			z = (u - v) - np.floor(u - v)
			G[i, itr] = 2.*math.pi**2 * z**2 - 2.*math.pi**2 * z + math.pi**2/3. + 1.
			

		if itr>0:
			for j in range(itr):
				for i in range(itr+1, n):
					G[i, itr]-=G[i, j]*G[itr, j]

		for i in range(itr+1, n):
			G[i, itr]/=G[itr, itr]


		# Compute the residual
	 
		residual = 0.0
		jast = itr+1
		maxdiagG = 0

		for i in range(itr+1, n):
			b=diagK[pp[i]]
			for j in range(itr + 1):
				b-=G[i, j]*G[i, j]
			diagG[i]=b
			if (b>maxdiagG):
				jast=i
				maxdiagG=b
			residual+=b
		itr+=1
	return G, pp, itr, residual/trK 


def icd_bern_s2(x, tol, nmax):

	m = 1 #/* dimension of input space is 1 (kernel on torus in 1d) */
	n = x.shape[0] #/* number of samples */

	diagG = np.zeros(n)
	diagK = np.zeros(n)

	G = np.zeros((n, nmax))

	pp = list(range(n)) # pivot

	itr=0
	trK = 0
	for i in range(n):
		diagK[i] = 1. + 1./24. * (2.*math.pi)**4 /30. #  /* diagonal of the Bernoulli s2 kernel is this */
		diagG[i] = diagK[i]
		trK += diagK[i]

	residual = trK
	jast = 0

	while ( ( residual > tol ) and ( itr < nmax ) ):
		#/* switches already calculated elements of G and order in pp */
		if (jast!=itr):
			i=pp[jast]
			pp[jast]=pp[itr]
			pp[itr]=i
			for i in range(itr+1): # pivotting
				tmp = G[jast, i]
				G[jast, i] = G[itr, i]
				G[itr, i] = tmp
			
		G[itr, itr] = np.sqrt(diagG[jast])
		

		for i in range(itr+1, n):
			u = x[pp[itr]]
			v = x[pp[i]]
			z = (u - v) - np.floor(u - v)
			G[i, itr] = 1. - 1./24. * (2.*math.pi)**4 * (z**4 - 2.*z**3 + z**2 - 1./30.)  
			

		if itr>0:
			for j in range(itr):
				for i in range(itr+1, n):
					G[i, itr]-=G[i, j]*G[itr, j]

		for i in range(itr+1, n):
			G[i, itr]/=G[itr, itr]


		# Compute the residual
	 
		residual = 0.0
		jast = itr+1
		maxdiagG = 0

		for i in range(itr+1, n):
			b=diagK[pp[i]]
			for j in range(itr + 1):
				b-=G[i, j]*G[i, j]
			diagG[i]=b
			if (b>maxdiagG):
				jast=i
				maxdiagG=b
			residual+=b
		itr+=1
	return G, pp, itr, residual/trK 

