# Emergence of Hierarchical Layers in Network of Self-Organizing Spiking Neurons

Generates neural topographic maps based on the self organization principles proposed in 
"Emergence of Hierarchical Layers in Network of Self-Organizing Spiking Neurons".
Please note that it includes the code needed for generating the basic topographic maps using standard fully connected weight matrices, 
but it does not include the optimized custom block-sparse datastructure for efficiently pruning and growing new connections 
and doing a sparse forward pass to generate the larger neural sheet. 
More details on this datastructure is given in the supplemental materials. 
After running the code, the resulting topographic map will be in the results directory.

#### Dependencies
- Pytorch
- Pytorch-vision
- Numpy
- Matplotlib 
- Seaborn

#### Requirements
- Ubuntu 18+
- CUDA 10.1+
- GPU 6GB+ memory 

#### How to run
Experiments can be run as follows: 

> Python main.py 

Parameters can be changed in main.py by setting the right string values. One can run either standard Spiking Neural Networks (SNN), Self-Organizing Maps (SOM), 
or the proposed Self-Organizing Neural Sheet (SONS). Please refer to the code for additional parameter settings and details. 
Results will be generated in the /results folder. 

#### Code details
- Main.py: Main entry to the code, constructs the neural sheet with given parameters
- NeuralSheet.py: Neural sheet class responsible for simulating the spiking neurons and generating resulting map (incl. STDP, weight normalization)
- ImageLoader.py: Loads images and converts them to ON/OFF cell responses
- GaussianConv.py: Helper class to apply gaussian convolutions
- WeightMatrix.py: Stores weights and computes forward pass  