ENGINE_BASE=curie:ANONYMIZED
ENGINE_GT=curie:ANONYMIZED
REDUCED=data/latest/reduced_ixs.txt
MAX_STEPS=25
N=10
NRUNS=3
ALPHA=0.75
TEMP=0.30
SPLIT=valid


# greedy-decoding
python gpt3ft/generate_greedy_stepwise.py --ckpt "$ENGINE_GT" --refs gtrefs --mode full --temperature 0.0 --split "$SPLIT" --reduced-idxs "$REDUCED" --n 1 --max-steps "$MAX_STEPS" --num-runs 1

# full proof sampling
python gpt3ft/generate_greedy_stepwise.py --ckpt "$ENGINE_GT" --refs gtrefs --mode full --temperature "$TEMP" --split "$SPLIT" --reduced-idxs "$REDUCED" --n "$N" --max-steps "$MAX_STEPS" --num-runs "$NRUNS" --alpha "$ALPHA"

# stepwise beam
python gpt3ft/generate_greedy_stepwise.py --ckpt "$ENGINE_GT" --refs gtrefs --mode stepwise_beam --split "$SPLIT" --reduced-idxs "$REDUCED"  --expansion multitemp --selection diversity  --temperature "$TEMP" --n "$N" --num-runs "$NRUNS" --max-steps "$MAX_STEPS" --alpha "$ALPHA"




