# Sparse Winning Tickets are Data-Efficient Image Recognizers

## Setup

```bash
pip install -r requirements.txt
```

## CIFAR10 Experiments - 100% to 1% data subsets

```bash
bash run_cifar10.sh sparse 1 imp
bash run_cifar10.sh sparse 0.5 imp
bash run_cifar10.sh sparse 0.2 imp
bash run_cifar10.sh sparse 0.1 imp
bash run_cifar10.sh sparse 0.02 imp
bash run_cifar10.sh sparse 0.01 imp
```

Corresponding robustness experiments can be run via `cifar_rob_a.py`, `cifar_rob_d.py` and `cifar_rob_a.py`.

## CIFAR100 long-tailed expts

```bash
bash run_cifar100_longtailed.sh
```

## Run other methods on CIFAR10 subsets

```bash
# cosine
python3 train.py --dset cifar10 --data_root data/ --data_size 0.01 --mode imp --out_dir resnet18_coslinear_cifar10_0.01 --rand_aug --cutout --cos_linear > resnet18_coslinear_cifar10_0.01.out &

python3 train.py --dset cifar10 --data_root data/ --data_size 0.02 --mode imp --out_dir resnet18_coslinear_cifar10_0.02 --auto_aug --cutout --cos_linear > resnet18_coslinear_cifar10_0.02.out 

# TVMF
python3 train.py --dset cifar10 --data_root data/ --data_size 0.01 --mode imp --out_dir resnet18_tvmflinear_cifar10_0.01 --rand_aug --cutout --tvmf_linear > resnet18_tvmflinear_cifar10_0.01.out

python3 train.py --dset cifar10 --data_root data/ --data_size 0.02 --mode imp --out_dir resnet18_tvmflinear_cifar10_0.02 --auto_aug --cutout --tvmf_linear > resnet18_tvmflinear_cifar10_0.02.out

# Harmonic
python3 train.py --dset cifar10 --data_root data/ --data_size 0.01 --mode imp --out_dir hresnet18_cifar10_0.01 --rand_aug --cutout --net hresnet18 > hresnet18_cifar10_0.01.out

python3 train.py --dset cifar10 --data_root data/ --data_size 0.02 --mode imp --out_dir hresnet18_cifar10_0.02 --auto_aug --cutout --net hresnet18 > hresnet18_cifar10_0.02.out

# Full Conv
python3 train.py --dset cifar10 --data_root data/ --data_size 0.01 --mode imp --out_dir fresnet18_cifar10_0.01 --rand_aug --cutout --net fresnet18

python3 train.py --dset cifar10 --data_root data/ --data_size 0.02 --mode imp --out_dir fresnet18_cifar10_0.02 --auto_aug --cutout --net fresnet18

# Pretrained (ImageNet)
python3 train.py --dset cifar10 --data_root data/ --data_size 0.01 --mode imp --out_dir preresnet18_cifar10_0.01 --rand_aug --cutout --lr 0.001 --pretrained

python3 train.py --dset cifar10 --data_root data/ --data_size 0.02 --mode imp --out_dir preresnet18_cifar10_0.02 --auto_aug --cutout --lr 0.001 --pretrained
```

## Run on other datasets

```bash
nohup bash run_otherdsets.sh eurosat_rgb few_shot_datasets/EUROSAT_RGB > eurosat_rgb.out
nohup bash run_otherdsets.sh isic few_shot_datasets/ISIC2018 > isic.out
nohup bash run_otherdsets.sh clamm few_shot_datasets/CLAMM > clamm.out
nohup bash run_otherdsets.sh eurosat_allband few_shot_datasets/EUROSAT_ALLBAND > eurosat_allband.out
```
