import pickle

five = pickle.load(open('results/census_partition.pkl', 'rb'))
ten = pickle.load(open('results/census_partition_10x10.pkl', 'rb'))
data_scales = set(five.keys()) & set(ten.keys())

fifteen = {}

for data_scale in data_scales:
	five_metrics, ten_metrics = five[data_scale], ten[data_scale]
	fifteen[data_scale] = {setting_name : {} for setting_name in five_metrics}
	for setting_name in five_metrics:
		five_metrics_dict = five_metrics[setting_name]
		ten_metrics_dict = ten_metrics[setting_name]
		for metric_name in five_metrics_dict:
			five_scores = five_metrics_dict[metric_name]
			ten_scores = ten_metrics_dict[metric_name]
			
			five_seeds, ten_seeds = five_scores['seeds'], ten_scores['seeds']
			fifteen_seeds = five_seeds + ten_seeds

			print(data_scale, setting_name, metric_name)

			print(five_seeds, ten_seeds, fifteen_seeds)

			five_mean, ten_mean = five_scores['mean'], ten_scores['mean']
			fifteen_mean = (five_mean * five_seeds + ten_mean * ten_seeds) / (fifteen_seeds) 

			print(five_mean, ten_mean, fifteen_mean)

			five_stdev, ten_stdev = five_scores['stdev'], ten_scores['stdev']
			fifteen_stdev_numerator = ((five_stdev ** 2) * five_seeds) + ((ten_stdev ** 2) * ten_seeds)
			fifteen_stdev = (fifteen_stdev_numerator / fifteen_seeds) ** (0.5)

			print(five_stdev, ten_stdev, fifteen_stdev)

			fifteen[data_scale][setting_name][metric_name] = {'mean' : fifteen_mean, 'stdev' : fifteen_stdev, 'seeds' : fifteen_seeds}

pickle.dump(fifteen, open('results/census_partition_15x15.pkl', 'wb'))