# Neural Surface Reconstruction of Dynamic Scenes with Monocular RGB-D Camera
The code is a part of the supplementary material for NeurIPS 2022 paper: Neural Surface Reconstruction of Dynamic Scenes with Monocular RGB-D Camera.

## Requirements
The code has been tested with Python 3.9, PyTorch 1.8.0 and Cuda 11.1:

    conda env create -f environment.yml

    conda activate ndr

    conda install pytorch==1.8.0 torchvision==0.9.0 torchaudio==0.8.0 cudatoolkit=11.1 -c pytorch -c conda-forge

## How to use the code:
Under root directory '[ProjectPath]/', run:
    bash run.sh

## Details:
We have selected several frames from a sequence (the DeepDeform dataset[1]) for evaluation, and have put them in the folder '[ProjectPath]/datasets/example'. After running the code, the results would be generated in the folder '[ProjectPath]/exp/example', including reconstructed ('validations_meshes/[0-29].ply') and rendered (the 1st row of 'validations_rgbs/[0-29].png') results.

## Hints:
The procedure may take up about 17,000 MiB GPU memory, you can decrease the value of 'test.test_batch_size' in the file '[ProjectPath]/confs/config.conf' if you need to reduce it.

The default GPU device is 0, you can change it to other index by modifying '--gpu' variable in the file '[ProjectPath]/run.sh'. Currently the code only supports a single GPU device.

## References:
[1] Bozic, Aljaz, Michael Zollhofer, Christian Theobalt, and Matthias Nießner. "Deepdeform: Learning non-rigid rgb-d reconstruction with semi-supervised data." In Proceedings of the IEEE/CVF Conference on Computer Vision and Pattern Recognition (CVPR), pp. 7002-7012. 2020.