import numpy as np
import time
import json
import os
from tqdm import tqdm

# Loading the model
import numpy as np
import time
import sys
import json
import tensorflow as tf
import tensorflow_addons as tfa
from tensorflow import keras
import tensorflow.keras.backend as K
from tensorflow.keras.models import model_from_json

from BesselConv2d import BesselConv2d
from GroupConv2d import GroupConv2d



model = keras.models.Sequential(name='AllGConv')
model.add(GroupConv2d(k=7, n_out=16, h_input='Z2', h_output='C4', activation='relu', name='GConv1', input_shape=(128, 128, 3)))
model.add(keras.layers.MaxPooling2D((3, 3), name='Maxpool1'))
model.add(GroupConv2d(k=5, n_out=16, h_input='C4', h_output='C4', activation='relu', name='GConv2'))
model.add(keras.layers.MaxPooling2D((2, 2), name='Maxpool2'))
model.add(GroupConv2d(k=5, n_out=32, h_input='C4', h_output='C4', activation='relu', name='GConv3'))
model.add(keras.layers.MaxPooling2D((2, 2), name='Maxpool3'))
model.add(GroupConv2d(k=5, n_out=32, h_input='C4', h_output='C4', activation='relu', name='GConv4'))
model.add(GroupConv2d(k=3, n_out=32, h_input='C4', h_output='C4', activation='relu', name='GConv5'))
model.add(keras.layers.Reshape((1,1,32,4)))
model.add(keras.layers.Lambda(lambda x: K.sum(x, axis=4), input_shape=(1,1,32,4)))
model.add(keras.layers.Flatten(name='Flatten'))
model.add(keras.layers.Dense(2, name='Output'))
model.summary()

model_json = model.to_json()

# Saving
with open('./models/AllGConv.json', 'w') as json_file:
    json_file.write(model_json)
    



model = keras.models.Sequential(name='AllConv')
model.add(keras.layers.Conv2D(32, (7,7), activation='relu', name='Conv1', input_shape=(128, 128, 3)))
model.add(keras.layers.MaxPooling2D((3, 3), name='Maxpool1'))
model.add(keras.layers.Conv2D(32, (5,5), activation='relu', name='Conv2'))
model.add(keras.layers.MaxPooling2D((2, 2), name='Maxpool2'))
model.add(keras.layers.Conv2D(64, (5,5), activation='relu', name='Conv3'))
model.add(keras.layers.MaxPooling2D((2, 2), name='Maxpool3'))
model.add(keras.layers.Conv2D(64, (5,5), activation='relu', name='Conv4'))
model.add(keras.layers.Conv2D(64, (3,3), activation='relu', name='Conv5'))
model.add(keras.layers.Flatten(name='Flatten'))
model.add(keras.layers.Dense(2, name='Output'))
model.summary()

model_json = model.to_json()

# Saving
with open('./models/AllConv.json', 'w') as json_file:
    json_file.write(model_json)
    


model = keras.models.Sequential(name='AllBConv')
m_max = 11 ; j_max = 11 ; k = 9 ; n_out = 32
model.add(BesselConv2d(m_max,j_max,k,n_out,padding='VALID',activation='tanh',name='BConv1', input_shape=(128, 128, 3)))
model.add(keras.layers.MaxPooling2D((3, 3), name='Maxpool1'))
m_max = 9 ; j_max = 9 ; k = 7 ; n_out = 16
model.add(BesselConv2d(m_max,j_max,k,n_out,padding='VALID',activation='tanh',name='BConv2'))
model.add(keras.layers.MaxPooling2D((2, 2), name='Maxpool2'))
m_max = 7 ; j_max = 7 ; k = 5 ; n_out = 16
model.add(BesselConv2d(m_max,j_max,k,n_out,padding='VALID',activation='tanh',name='BConv3'))
model.add(keras.layers.MaxPooling2D((2, 2),name='Maxpool3'))
m_max = 7 ; j_max = 7 ; k = 5 ; n_out = 32
model.add(BesselConv2d(m_max,j_max,k,n_out,padding='VALID',activation='tanh',name='BConv4'))
model.add(keras.layers.MaxPooling2D((2, 2),name='Maxpool4'))
model.add(keras.layers.Flatten(name='Flatten'))
model.add(keras.layers.Dense(2,name='output'))
model.summary()

model_json = model.to_json()

# Saving
with open('./models/AllBConv.json', 'w') as json_file:
    json_file.write(model_json)