#/bin/bash

#export PYTHONPATH="${PYTHONPATH}:/workspace/code"
#export GPU_ID=0,1
export GPU_ID=4

checkpoint_path=/mnt/efs/fs2/hzt/causal/Optimus/checkpoints/
output_path=/mnt/efs/fs2/hzt/causal/Optimus/outputs/
data_path=/mnt/efs/fs2/hzt/causal/Optimus/data/

## Yelp

debug=0

attribute_dim=50
if [ "$debug" -eq 1 ]
then
    TRAIN_FILE=data/datasets/yelp_data_tst/small/train.txt
    #TEST_FILE=data/datasets/yelp_data_tst/small/test.txt
    TEST_FILE=data/datasets/yelp_data_tst/small/train.txt
    logging_steps=1
    save_steps=20000
    per_gpu_train_batch_size=8
    per_gpu_eval_batch_size=8
    num_train_epochs=10
else
    TRAIN_FILE=/mnt/efs/fs2/hzt/causal/Optimus/data/multi_yelp_tst/full_5_15_clean_visible/yelp_text_attrs_5_15_cor90_train.txt.reformat.len20
    TEST_FILE=/mnt/efs/fs2/hzt/causal/Optimus/data/multi_yelp_tst/full_5_15_clean_visible/yelp_text_attrs_5_15_cor90_dev.txt.reformat.len20.sub.5689
    logging_steps=2000
    save_steps=2000
    per_gpu_train_batch_size=8
    per_gpu_eval_batch_size=8
    num_train_epochs=10
fi

    #--eval_self_accuracy \

CUDA_VISIBLE_DEVICES=$GPU_ID python3 code/examples/big_ae/run_lm_vae_clas_training_bak_bias.py \
    --multi_attribute \
    --eval_elbo \
    --beta 1.0 \
    --use_gumbel \
    --output_dir=${output_path}/finetune_lm/outputs-31250/multi/multi-beta1-gsfixed-newmask-t05_w0_wr1_lr5e5_gumbel_samelen_bz8_bak/outputs-31250-500000/multi-beta1-cont-gsfixed-newmask-t05_w05_wr01_lr1e5_gumbel_samelen_bz8_bak \
    --learning_rate 1e-5 \
    --temperature=0.5 \
    --lambda_clas=0.5 \
    --lambda_recon=0.1 \
    --temperature_anneal_factor=1 \
    --temperature_anneal_iters=20000 \
    --checkpoint_dir=${output_path}/finetune_lm/outputs-31250/multi/multi-beta1-gsfixed-newmask-t05_w0_wr1_lr5e5_gumbel_samelen_bz8_bak \
    --gloabl_step_eval 500000 \
    --attribute_dim $attribute_dim \
    --dataset Yelp \
    --encoder_model_type=bert \
    --encoder_model_name_or_path=bert-base-cased \
    --decoder_model_type=gpt2 \
    --decoder_model_name_or_path=gpt2 \
    --classifier_model_type=gpt2-clas \
    --classifier_model_name_or_path=gpt2 \
    --ratio_zero 0.5 \
    --ratio_increase 0.25 \
    --do_train \
    --fb_mode 1 \
    --dim_target_kl 0.5\
    --train_data_file=$TRAIN_FILE \
    --eval_data_file=$TEST_FILE \
    --num_train_epochs ${num_train_epochs} \
    --save_steps ${save_steps}\
    --logging_steps ${logging_steps} \
    --overwrite_output_dir \
    --block_size 100 \
    --length_weighted_loss \
    --use_pretrained_model \
    --use_pretrained_vae \
    --latent_size 768 \
    --evaluate_during_training \
    --per_gpu_train_batch_size ${per_gpu_train_batch_size} \
    --per_gpu_eval_batch_size ${per_gpu_eval_batch_size}


### VAE from scratch
#
#CUDA_VISIBLE_DEVICES=$GPU_ID python3 code/examples/big_ae/run_lm_vae_clas_training_bak_bias.py \
#    --eval_self_accuracy \
#    --multi_attribute \
#    --eval_elbo \
#    --beta 1.0 \
#    --use_gumbel \
#    --output_dir=${output_path}/finetune_lm/outputs-31250/multi/multi-beta1-gsfixed-newmask-t05_w0_wr1_lr5e5_gumbel_samelen_bz8_bak \
#    --learning_rate 5e-5 \
#    --temperature=0.5 \
#    --lambda_clas=0. \
#    --lambda_recon=1 \
#    --temperature_anneal_factor=1 \
#    --temperature_anneal_iters=20000 \
#    --checkpoint_dir=${checkpoint_path}/checkpoint-31250 \
#    --gloabl_step_eval 31250 \
#    --attribute_dim $attribute_dim \
#    --dataset Yelp \
#    --encoder_model_type=bert \
#    --encoder_model_name_or_path=bert-base-cased \
#    --decoder_model_type=gpt2 \
#    --decoder_model_name_or_path=gpt2 \
#    --classifier_model_type=gpt2-clas \
#    --classifier_model_name_or_path=gpt2 \
#    --ratio_zero 0.5 \
#    --ratio_increase 0.25 \
#    --do_train \
#    --do_eval \
#    --fb_mode 1 \
#    --dim_target_kl 0.5\
#    --train_data_file=$TRAIN_FILE \
#    --eval_data_file=$TEST_FILE \
#    --num_train_epochs ${num_train_epochs} \
#    --save_steps ${save_steps}\
#    --logging_steps ${logging_steps} \
#    --overwrite_output_dir \
#    --block_size 100 \
#    --length_weighted_loss \
#    --use_pretrained_model \
#    --use_pretrained_vae \
#    --latent_size 768 \
#    --evaluate_during_training \
#    --per_gpu_train_batch_size ${per_gpu_train_batch_size} \
#    --per_gpu_eval_batch_size ${per_gpu_eval_batch_size}
#


