#/bin/bash

#export PYTHONPATH="${PYTHONPATH}:/workspace/code"
#export GPU_ID=0,1
export GPU_ID=2

checkpoint_path=/mnt/efs/fs2/hzt/causal/Optimus/checkpoints/
output_path=/mnt/efs/fs2/hzt/causal/Optimus/outputs/
data_path=/mnt/efs/fs2/hzt/causal/Optimus/data/

## Yelp

debug=0

attribute_dim=50
if [ "$debug" -eq 1 ]
then
    TRAIN_FILE=data/datasets/yelp_data_tst/small/train.txt
    #TEST_FILE=data/datasets/yelp_data_tst/small/test.txt
    TEST_FILE=data/datasets/yelp_data_tst/small/train.txt
    logging_steps=1
    per_gpu_train_batch_size=12
    per_gpu_eval_batch_size=12
    num_train_epochs=10
else
    #TRAIN_FILE=data/datasets/yelp_data_tst/full/train.txt
    #TEST_FILE=data/datasets/yelp_data_tst/full/dev.txt.sub.0.10
    #TRAIN_FILE=${data_path}/multi_yelp_tst/full/yelp_text_attrs_10_15_cor80_train.txt
    #TEST_FILE=${data_path}/multi_yelp_tst/full/yelp_text_attrs_10_15_cor80_dev.txt.sub.5594
    #
    TRAIN_FILE=${data_path}/multi_yelp_tst/full_5_15_clean/yelp_text_attrs_5_15_cor90_train.txt.reformat.len20
    TEST_FILE=${data_path}/multi_yelp_tst/full_5_15_clean/yelp_text_attrs_5_15_cor90_dev.txt.reformat.sub.5771.len20
    #
    #TRAIN_FILE=${data_path}/multi_yelp_tst/full_5_15_clean_unbias/yelp_text_attrs_5_15_cor50_train.txt.reformat
    #TEST_FILE=${data_path}/multi_yelp_tst/full_5_15_clean_unbias/yelp_text_attrs_5_15_cor50_dev.txt.reformat.sub.5771
    logging_steps=3000
    save_steps=3000
    per_gpu_train_batch_size=16
    per_gpu_eval_batch_size=16
    num_train_epochs=10
fi


#--use_deterministic_connect \
#--output_dir=${output_path}/finetune_lm/bias_yelp_na${attribute_dim}_10ep_bz${per_gpu_train_batch_size}_vae/ \

CUDA_VISIBLE_DEVICES=$GPU_ID python3 code/examples/big_ae/run_lm_vae_clas_training_bak_basic.py \
    --output_dir=${output_path}/finetune_lm/bias_yelp_na${attribute_dim}_${num_train_epochs}ep_bz${per_gpu_train_batch_size}_vae_beta1/ \
    --checkpoint_dir=${checkpoint_path}/checkpoint-31250 \
    --gloabl_step_eval 31250 \
    --beta 1 \
    --attribute_dim $attribute_dim \
    --dataset Yelp \
    --encoder_model_type=bert \
    --encoder_model_name_or_path=bert-base-cased \
    --decoder_model_type=gpt2 \
    --decoder_model_name_or_path=gpt2 \
    --classifier_model_type=gpt2-clas \
    --classifier_model_name_or_path=gpt2 \
    --ratio_zero 0.5 \
    --ratio_increase 0.25 \
    --do_train \
    --do_eval \
    --fb_mode 1 \
    --dim_target_kl 0.5\
    --train_data_file=$TRAIN_FILE \
    --eval_data_file=$TEST_FILE \
    --num_train_epochs ${num_train_epochs} \
    --save_steps ${save_steps}\
    --logging_steps ${logging_steps} \
    --overwrite_output_dir \
    --block_size 100 \
    --length_weighted_loss \
    --use_pretrained_model \
    --use_pretrained_vae \
    --latent_size 768 \
    --evaluate_during_training \
    --per_gpu_train_batch_size ${per_gpu_train_batch_size} \
    --per_gpu_eval_batch_size ${per_gpu_eval_batch_size}


## ==== eval ====

#debug=0
#
#attribute_dim=50
#if [ "$debug" -eq 1 ]
#then
#    TRAIN_FILE=data/datasets/yelp_data_tst/small/train.txt
#    #TEST_FILE=data/datasets/yelp_data_tst/small/test.txt
#    TEST_FILE=data/datasets/yelp_data_tst/small/train.txt
#    logging_steps=1
#    per_gpu_train_batch_size=12
#    per_gpu_eval_batch_size=12
#    num_train_epochs=10
#else
#    TRAIN_FILE=${data_path}/multi_yelp_tst/full/yelp_text_attrs_10_15_cor80_train.txt
#    #TRAIN_FILE=data/datasets/yelp_data_tst/full/train.txt
#    #TEST_FILE=${data_path}/multi_yelp_tst/full/yelp_text_attrs_10_15_cor80_dev.txt.sub.5594
#    TEST_FILE=${data_path}/multi_yelp_tst/full/yelp_text_attrs_10_15_cor80_dev.txt.sub.5594.reformat
#    #TEST_FILE=data/datasets/yelp_data_tst/full/dev.txt.sub.0.10
#    logging_steps=4000
#    save_steps=4000
#    per_gpu_train_batch_size=8
#    per_gpu_eval_batch_size=8
#    num_train_epochs=10
#fi
#
#
#CUDA_VISIBLE_DEVICES=$GPU_ID python3 code/examples/big_ae/run_lm_vae_clas_training_bak_basic.py \
#    --use_deterministic_connect \
#    --output_dir=${output_path}/finetune_lm/yelp_na50_10ep/checkpoint-31250-69000 \
#    --checkpoint_dir=${output_path}/finetune_lm/yelp_na50_10ep/checkpoint-31250-69000 \
#    --gloabl_step_eval 69000 \
#    --attribute_dim $attribute_dim \
#    --dataset Yelp \
#    --encoder_model_type=bert \
#    --encoder_model_name_or_path=bert-base-cased \
#    --decoder_model_type=gpt2 \
#    --decoder_model_name_or_path=gpt2 \
#    --classifier_model_type=gpt2-clas \
#    --classifier_model_name_or_path=gpt2 \
#    --beta 0.0 \
#    --ratio_zero 0.5 \
#    --ratio_increase 0.25 \
#    --do_eval \
#    --fb_mode 1 \
#    --dim_target_kl 0.5\
#    --train_data_file=$TRAIN_FILE \
#    --eval_data_file=$TEST_FILE \
#    --num_train_epochs ${num_train_epochs} \
#    --save_steps ${save_steps}\
#    --logging_steps ${logging_steps} \
#    --overwrite_output_dir \
#    --block_size 100 \
#    --length_weighted_loss \
#    --use_pretrained_model \
#    --use_pretrained_vae \
#    --latent_size 768 \
#    --evaluate_during_training \
#    --per_gpu_train_batch_size ${per_gpu_train_batch_size} \
#    --per_gpu_eval_batch_size ${per_gpu_eval_batch_size}


