#!/usr/bin/env bash

dir=$1

[[ -d ${dir} ]] || { echo "Cannot open directory '${dir}'"; exit 1; }

source ~/rotorenv/bin/activate
echo Running

python3 simulate.py -s "500" -b 16 -n resnet inception > ${dir}/simulate_results_others &
python3 simulate.py -s "500" -b 16 -n densenet -d 121 > ${dir}/simulate_results_d121 &
python3 simulate.py -s "500" -b 16 -n densenet -d 161 > ${dir}/simulate_results_d161 &
python3 simulate.py -s "500" -b 16 -n densenet -d 169 > ${dir}/simulate_results_d169 &

wait

cat ${dir}/simulate_results_others ${dir}/simulate_results_d121 ${dir}/simulate_results_d161 ${dir}/simulate_results_d169 > ${dir}/simulate_results
