# pylint: disable=g-bad-file-header
# Copyright 2019 DeepMind Technologies Limited. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or  implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# ============================================================================
"""Pycolab human player."""

from __future__ import absolute_import
from __future__ import division
from __future__ import print_function

import curses

from absl import app
from absl import flags
from pycolab import human_ui

from environments.empty_room import gym_maze, pycolab_maze

FLAGS = flags.FLAGS

flags.DEFINE_enum('game', 'zhang_et_al',
                  ['zhang_et_al'],
                  'The name of the game')


def main(unused_argv):
    import argparse
    parser = argparse.ArgumentParser()
    parser.add_argument('--seed', help='Random seed.', type=int, default=42)
    args = parser.parse_args()

    if FLAGS.game == 'zhang_et_al':
        game = gym_maze.MazeEnv(args.seed)
    else:
        raise ValueError('Unsupported game "%s".' % FLAGS.game)
    episode = game.make_episode()

    ui = human_ui.CursesUi(
        keys_to_actions={
            curses.KEY_UP: pycolab_maze.ACTION_NORTH,
            curses.KEY_DOWN: pycolab_maze.ACTION_SOUTH,
            curses.KEY_LEFT: pycolab_maze.ACTION_WEST,
            curses.KEY_RIGHT: pycolab_maze.ACTION_EAST,
            -1: pycolab_maze.ACTION_DELAY,
            'q': pycolab_maze.ACTION_QUIT,
            'Q': pycolab_maze.ACTION_QUIT},
        delay=-1,
        colour_fg=game.colours
    )
    ui.play(episode)


if __name__ == '__main__':
    app.run(main)
