clear all
close all
clc

%% Figure
figure('Renderer', 'painters', 'Position', [10 10 1400 300]);

%% first time
t1 = 1;

%% subplot 1 : time t1=1
subplot(1,4,1)
dt = 1e-4;
t2 = 5;
t = t1:dt:t2;


b = 6; %high sharpness
for C =2:0.5:5
    fc=C*(bessely(1,sqrt(b)*t)./t)-C*((bessely(1,sqrt(b)*t1)*besselj(1,sqrt(b)*t))./(besselj(1,sqrt(b)*t1)*t));
    if C==2
        h1=plot(t,fc,'linewidth',2,'color',[0.694 0.259 1.0]);hold on
    else
        plot(t,fc,'linewidth',2,'color',[0.694 0.259 1.0]);hold on 
    end
end

b = 2; %mid sharpness
for C =2:0.5:5
    fc=C*(bessely(1,sqrt(b)*t)./t)-C*((bessely(1,sqrt(b)*t1)*besselj(1,sqrt(b)*t))./(besselj(1,sqrt(b)*t1)*t));
    if C==2
        h2=plot(t,fc,'linewidth',2,'color',[0.845 0.477 0.199]);hold on
    else
        plot(t,fc,'linewidth',2,'color',[0.845 0.477 0.199]);hold on 
    end
end

b = 1; %low sharpness
for C =2:0.5:5
    fc=C*(bessely(1,sqrt(b)*t)./t)-C*((bessely(1,sqrt(b)*t1)*besselj(1,sqrt(b)*t))./(besselj(1,sqrt(b)*t1)*t));
    if C==2
        h3=plot(t,fc,'linewidth',2,'color',[0.314 0.459 0.78]);hold on
    else
        plot(t,fc,'linewidth',2,'color',[0.314 0.459 0.78]);hold on 
    end
end

legend([h1,h2,h3],{'$\beta = 6$','$\beta = 2$','$\beta = 1$'},'Fontsize',20,'location','best','interpreter','latex');
xlabel('time $t$','Fontsize',20,'interpreter','latex')
ylabel('Solution to Jacobi $h(t)$','Fontsize',20,'interpreter','latex')
title(['$t_1=',num2str(t1),'$'],'Fontsize',18,'interpreter','latex')

set(gca,'box','off')
grid on


%% subplot 2 : time t1=1, conjugate points computation

t1 = 1;
dt = 1e-3;
t2 = 10;
t = t1:dt:t2;


BF = 1e4;
dB = 0.25;
B0 = 0.25;
C=1;
b = B0:dB:BF;
conj_t=0*b;
for idx_b = 1:length(b)
    fc=C*(bessely(1,sqrt(b(idx_b))*t)./t)-C*((bessely(1,sqrt(b(idx_b))*t1)*besselj(1,sqrt(b(idx_b))*t))./(besselj(1,sqrt(b(idx_b))*t1)*t));
    if abs(max(fc))>abs(min(fc))
        conj_t(idx_b)=t(find(fc<-0.001,1,'first')); 
    else
        conj_t(idx_b)=t(find(fc>0.001,1,'first')); 
    end
end

subplot(1,4,2)
semilogx(b,conj_t,'linewidth',2,'color',[0.667 0.569 0.157]);hold on
semilogx(b,t1+0*conj_t,'--','linewidth',2,'color',[0.667 0.569 0.157])
xlabel('sharpness $\beta$','Fontsize',20,'interpreter','latex')
ylabel('First conjugate point','Fontsize',20,'interpreter','latex')
title(['$t_1=',num2str(t1),'$'],'Fontsize',18,'interpreter','latex')
set(gca,'box','off')
grid on
ylim([0,6])




%% first time
t1 = 4;


%% subplot 3 : time t1=4, conjugate points computation

dt = 1e-4;
t2 = 10;
t = t1:dt:t2;


b = 6;

subplot(1,4,3)

for C =2:0.5:5
    fc=C*(bessely(1,sqrt(b)*t)./t)-C*((bessely(1,sqrt(b)*t1)*besselj(1,sqrt(b)*t))./(besselj(1,sqrt(b)*t1)*t));
    if C==2
        h1=plot(t,fc,'linewidth',2,'color',[0.694 0.259 1.0]);hold on
    else
        plot(t,fc,'linewidth',2,'color',[0.694 0.259 1.0]);hold on 
    end
end

b = 2;
for C =2:0.5:5
    fc=C*(bessely(1,sqrt(b)*t)./t)-C*((bessely(1,sqrt(b)*t1)*besselj(1,sqrt(b)*t))./(besselj(1,sqrt(b)*t1)*t));
    if C==2
        h2=plot(t,fc,'linewidth',2,'color',[0.845 0.477 0.199]);hold on
    else
        plot(t,fc,'linewidth',2,'color',[0.845 0.477 0.199]);hold on 
    end
end


b = 1;
for C =2:0.5:5
    fc=C*(bessely(1,sqrt(b)*t)./t)-C*((bessely(1,sqrt(b)*t1)*besselj(1,sqrt(b)*t))./(besselj(1,sqrt(b)*t1)*t));
    if C==2
        h3=plot(t,fc,'linewidth',2,'color',[0.314 0.459 0.78]);hold on
    else
        plot(t,fc,'linewidth',2,'color',[0.314 0.459 0.78]);hold on 
    end
end

legend([h1,h2,h3],{'$\beta = 6$','$\beta = 2$','$\beta = 1$'},'Fontsize',20,'location','best','interpreter','latex');
xlabel('time $t$','Fontsize',20,'interpreter','latex')
ylabel('Solution to Jacobi $h(t)$','Fontsize',20,'interpreter','latex')
title(['$t_1=',num2str(t1),'$'],'Fontsize',18,'interpreter','latex')

set(gca,'box','off')
grid on


%% subplot 4 : time t1=4, conjugate points computation

dt = 1e-3;
t2 = 15;
t = t1:dt:t2;


BF = 1e4;
dB = 0.25;
B0 = 0.25;
C=1;
b = B0:dB:BF;
conj_t=0*b;
for idx_b = 1:length(b)
    fc=C*(bessely(1,sqrt(b(idx_b))*t)./t)-C*((bessely(1,sqrt(b(idx_b))*t1)*besselj(1,sqrt(b(idx_b))*t))./(besselj(1,sqrt(b(idx_b))*t1)*t));
    if abs(max(fc))>abs(min(fc))
        conj_t(idx_b)=t(find(fc<-0.001,1,'first')); 
    else
        conj_t(idx_b)=t(find(fc>0.001,1,'first')); 
    end
end

subplot(1,4,4)
semilogx(b,conj_t,'linewidth',2,'color',[0.667 0.569 0.157]);hold on
semilogx(b,t1+0*conj_t,'--','linewidth',2,'color',[0.667 0.569 0.157])
xlabel('sharpness $\beta$','Fontsize',20,'interpreter','latex')
ylabel('First conjugate point','Fontsize',20,'interpreter','latex')
title(['$t_1=',num2str(t1),'$'],'Fontsize',18,'interpreter','latex')
set(gca,'box','off')
grid on
ylim([0,6])

%% saving the figure
saveas(gcf,'jacobi_equations','epsc');




