from scipy.optimize import minimize
import math
import numpy as np 
import matplotlib.pyplot as plt 
import random as rn
import time



def  Norm(x):
	squares = [y**2 for y in x]
	a = sum(squares)
	return a**(1/2) 


def  pNorm(x):
	powers = [np.abs(y)**p for y in x]
	a = sum(powers)
	return a**(1/p) 


def dot(x,y):
	return sum(   [x[i]*y[i] for i in range(0,len(x)) ]   )  


def ExpectedLoss(x):
	return sum(   [x[i]*Expectation[i] for i in range(0,len(x)) ]   ) 



def dotCC(x):
	return sum(   [x[i]*CCost[i] for i in range(0,len(x)) ]   ) 


def  Distance(x):			
	a=sum(  [ (x[i]-y[i])**2  for i in range(0,len(x)) ]   )  # takes x as vector
	return a**(1/2)

def SchattenNorm(x,p):                                   # Schatten norm of matrix x with parameter p, takes x as vector
	x = np.reshape( x,(n,n) ) 	
	sv = np.linalg.svd(x)[0][0]
	a =  sum( [ np.abs(x)**p  for x in sv  ])
	return a**(1/p)	



def Subgradient(Costs,eta): 

	global CCost
	global y	
	Benchmarks = [0]
	Regret = [0]
	ObservedCosts = [[0]*d]
	CCost = np.array([0]*d)    # cumulative cost
	y = np.array( [0] )
	Actions = [ [0]*d] 
	Losses =   [0]  
	for i in range(1,N):
		#print("New cost =", Costs[i-1])
		#global CCost		
		CCost = np.add(CCost, Costs[i-1])
		#print("CumulativeCost=",CCost)
		#ObservedCosts = ObservedCosts + [list(Costs[i-1])]
		#print("ObservedCosts=",ObservedCosts)
		y = -eta*CCost*(1/np.sqrt(i))
		#print("y=",y)
		#x0 = [0]*d	
		cons= ({'type': 'ineq', 'fun': lambda x: -pNorm( x ) +1})  	
		res = minimize( Distance, Actions[i-1], constraints=cons)
		X = list(res.x)
		#print("Action =", X, "\n" )
		Actions = Actions + [X]
	return Actions


def regret(Costs,Actions): 
	
	Regret = [0]
	cons= ({'type': 'ineq', 'fun': lambda x: -pNorm( x ) +1})  
	global CCcost	
	CCost = np.array([0]*d)
	Benchmark = np.array([0]*d)
	for n in range(1, len(Actions)):
		CCost = np.add( CCost, Costs[n])
		res = minimize( dotCC, Benchmark, constraints=cons)
		Benchmark = list(res.x)
		r = [ dot( Actions[i], Costs[i] ) - dot( Benchmark, Costs[i] ) for i in range(0,n)]
		R = sum(r)
		Regret = Regret + [R]
	return Regret
		#Benchmarks = Benchmarks + [B]
		
		 


def ExpectedCosts(r):	                       
	a = [ (x/(d-1))**r for x in range(0,d)] 
	norm = Norm(a)	
	a = [x/norm for x in a]
	#a=[-1,1]	
	return a

def Noise(NoiseSize):
	N = [rn.choice([-1,1]) for x in range(0,d)]
	norm = Norm(N)
	N =  [NoiseSize*x/norm for x in N]
	return N

def EndNoise(NoiseSize):
	N = [0]*(d-1) + [rn.choice([-1,1])]
	return N
	
def CostHistory(r):
	a = ExpectedCosts(r)
	H = [np.add(a,Noise(NoiseSize)) for x in range(0,N)] # Change to EndNoise(NoiseSize) to get noise type (2), or Noise(NoiseSize)  to get noise type (1)
	return H
 
def SumSquares1(x):
	squares = [ (x[0]* np.sqrt(n) + x[1] - Average[n] )**2 for n in range(10,N)]
	return sum(squares)


def SumSquares2(x):
	squares = [ (x[0]* np.log(n+1) + x[1] - Average[n] )**2 for n in range(10,N)]
	return sum(squares)

	 
 
start_time = time.time()


NoiseSize = 1

p = 1.5

r = 0

d = 10

N = 500

eta = 1
 
S = 25
 

print("\n \n \n \n \n Expectation =", ExpectedCosts(r) )

Total = [0]*N
 
for r in [1]:#,1,2,4,8]: # use this to loop over parameters
 
	Total = [0]*N
	print("Starting r = ", r)	
	for n in range (0,S):
		print("Starting Sample Number", n)
		C = CostHistory(r)
		X = Subgradient(C,1)
		R = regret(C,X)
		Total = [Total[i] + R[i] for i in range(0,N) ]
	
	Average = [x/S for x in Total]
	plt.plot(Average,label = " r = "+str(r))

	#sqrtfit = [(Average[199]/math.sqrt(199))*math.sqrt(x) for x in range(1,N)]
	#logfit =  [(Average[199]/math.log(199))*math.log(x) for x in range(1,N)]

	#plt.plot(sqrtfit,label = " r = "+str(r)+"sqrtfit")
	#plt.plot(logfit,label = " r = "+str(r)+"logfit")
 

	#C1 = 0.241421*(Average[199] - Average[100]);
	#D1 = 3.41421*Average[100] -2.41421*Average[199];

	#C2 = 1.4427*(Average[199] - Average[100]);
	#D2 = 7.64386*Average[100] -6.64386*Average[199];

	#sqrtfit = [C1*math.sqrt(x) + D1 for x in range(1,N)]
	#logfit =  [C2*math.log(x) + D2 for x in range(1,N)]

	#plt.plot(sqrtfit,label = " r = "+str(r)+"sqrtfit")
	#plt.plot(logfit,label = " r = "+str(r)+"logfit")


	res = minimize( SumSquares1, [0,0])
	answer = list(res.x)
	print(answer)
	C1 = answer[0]
	D1 = answer[1]
	sqrtfit = [C1*math.sqrt(x) + D1 for x in range(0,N)]	
	plt.plot(sqrtfit,label = " r = "+str(r)+" sqrtfit")


	res = minimize( SumSquares2, [0,0])
	answer = list(res.x)
	print(answer)
	C2 = answer[0]
	D2 = answer[1]
	logfit = [C2*math.log(x+1) + D2 for x in range(0,N)]	
	plt.plot(logfit,label = " r = "+str(r)+" logfit")
 
end_time = time.time()




print("\n execution time = ",    end_time-start_time, "\n")

#plt.title("dimension = " +str(d)+", p = "+str(p)+", Samples = " +str(S)+ ", r = " +str(r))
plt.title("dimension = " +str(d)+  ", r = " +str(r)+  ", Samples = " +str(S)+", Noise Type  (2)" )
plt.ylabel("Regret")
plt.xlabel("Number of turns")
  

plt.legend(loc = 'lower right')
plt.show()
 
