function Kp = Robustify_Zeroth_K_1_Point(K0,A,B,C,Q,Ru,Rv)

max_iter = 1000;
eta = 0.0000000005;
Kp = K0;

[M,N] = size(K0);

sys_ini = ss((A-B*K0),C,(Q+K0'*Ru*K0)^(1/2),0,[]);
HinfNK_ini = hinfnorm(sys_ini,1e-6);


i = 1;
HinfNK_ini_tt = zeros(max_iter,1);
HinfNK_ini_tt(1) = HinfNK_ini;

r = 0.0001;
sig_Hinf = 1;
MC_num = 1;
est_grad_K_tt = zeros(M,N,MC_num);

while (i <= max_iter) && (HinfNK_ini^2>Rv(1,1))
    
    for j = 1:MC_num
        Delta_K = randn(M,N);
        Delta_K = Delta_K./norm(Delta_K,'fro');
        
        Kpri = Kp+r*Delta_K;
        sys_ini_pr = ss((A-B*Kpri),C,(Q+Kpri'*Ru*Kpri)^(1/2),0,[]);
        HinfNK_ini_pr = hinfnorm(sys_ini_pr,1e-6)+sig_Hinf*randn(1);
        
        est_grad_K_tt(:,:,j) = HinfNK_ini_pr*M*N*Delta_K./r;
    end
    
    est_grad_K = mean(est_grad_K_tt,3);
    Kp = Kp - eta*est_grad_K;
    i = i + 1;
    
    sys_ini = ss((A-B*Kp),C,(Q+Kp'*Ru*Kp)^(1/2),0,[]);
    HinfNK_ini_tt(i) = hinfnorm(sys_ini,1e-6);
    
    if (HinfNK_ini_tt(i)<=sqrt(Rv(1,1))*(1-1e-1))
        break;
    end
    
    
end

figure
plot(1:i,HinfNK_ini_tt(1:i)./sqrt(Rv(1,1)),'-*','MarkerSize',15,'LineWidth',2);
set(gca,'FontSize', 24,'FontName', 'Times New Roman');
xlabel('Iterations','Interpreter','Latex')
ylabel('$\|\mathcal{T}(K)\|_\infty$','Interpreter','Latex')






