clear all; close all
randn('seed',1);rand('seed',1); 
%% setup
n = 50; ro = 5;
outlier_ratio = 0.3;
m = ceil(outlier_ratio*n^2);
Uo = randn(n,ro);
L = Uo*Uo';
E = zeros(n,n);
indx = randperm(n^2);
E(indx(1:m)) = 10*randn(m,1);
X = L + E;
r = n; % over-parameterization for the low-rank matrix
U_0 = 1e-4*randn(n,r);
maxiter = 2e4;
Sp_0 = 1e-4*randn(n); %
Sm_0 = Sp_0; %Sm_0 = 0.0001*randn(n);
%% gradient descent
mu_multiplier = linspace(1 / (2*sqrt(n)), 2*sqrt(n), 10);
low_rank_err = zeros(1, 10);
sparse_err = zeros(1, 10);

for ii = 1:10
    mu_U = .0001; mu_S = mu_U*mu_multiplier(ii);
    U = U_0; Sp = Sp_0; Sm = Sm_0;
    error_lr(1) = norm(U*U' - L,'fro');
    for i = 2:maxiter+1
        
        % compute gradient
        temp = U*U' + Sp.*Sp - Sm.*Sm - X;
        gradU = (temp + temp')*U;
        gradSp = 2*temp.*Sp;
        gradSm = -2*temp.*Sm;
        
        %gradient descent
        U = U - mu_U*gradU;
        Sp = Sp - mu_S*gradSp;
        Sm = Sm - mu_S*gradSm;
        
        % compute distance for the low-rank matrix
        error_lr(i) = norm(U*U' - Uo*Uo','fro');
    end
    S = Sp.*Sp - Sm.*Sm;
    low_rank_err(ii) = norm(U*U' - Uo*Uo','fro')/norm(Uo*Uo','fro');
    sparse_err(ii) = norm(S - E,'fro')/norm(E,'fro');
    
    fprintf(['gd with different step size: low rank error:', num2str(norm(U*U' - Uo*Uo','fro')/norm(Uo*Uo','fro')),'\n'])
    fprintf(['gd with different step size: sparse error:', num2str(norm(S - E,'fro')/norm(E,'fro')),'\n'])
    
end

%%
fontsize = 26;
plotStyle = {'b-','k--','r:','g--','g:'};
figure
plot(mu_multiplier, low_rank_err,plotStyle{1},'linewidth',2)
legendInfo{1} = ['$\|{\bf X}_\star - \hat {\bf X}\|_F/\|{\bf X}_\star\|_F$']; hold on
hold on
plot(mu_multiplier, sparse_err,plotStyle{2},'linewidth',2)
legendInfo{2} = ['$\|{\bf S}_\star - \hat {\bf S}\|_F/\|{\bf X}_\star\|_F$']; hold on
xlim([min(mu_multiplier) max(mu_multiplier)])
legend(legendInfo,'Interpreter','LaTex','Location','Best')
xlabel('$\alpha$','FontSize',fontsize,'FontName','Times New Roman','Interpreter','LaTex');
set(gca, ...
    'LineWidth'  , 2                      , ...
    'FontSize'   , fontsize               , ...
    'FontName'   , 'Times New Roman'      , ...
    'Color'      , 'white'                 );
set(gcf, 'Color', 'white');
