# -*- coding: utf-8 -*-

# In this code, we test on Friedman1 with neural nets. 

import numpy as np
import sklearn
import pandas as pd
import random
import matplotlib.pyplot as plt
import math
from sklearn.linear_model import LinearRegression
from sklearn.ensemble.gradient_boosting import GradientBoostingRegressor
from sklearn import datasets
from sklearn.tree import DecisionTreeRegressor
from sklearn import preprocessing
from sklearn import neural_network
from sklearn.neural_network import MLPRegressor


def oracle():
# -*- coding: utf-8 -*-
  import torch

# N is batch size; D_in is input dimension;
# H is hidden dimension; D_out is output dimension.
  N, D_in, H, D_out = 100, 5, 4, 1

# Create random Tensors to hold inputs and outputs

  x1, y1 = datasets.make_friedman1(n_samples=10000, n_features=5, noise=1)
  x1, y1 = x1.astype(np.float32), y1.astype(np.float32)
  x1,y1 = torch.from_numpy(x1),torch.from_numpy(y1)
  #x = x.float()
  y1 =y1.view(10000,1)

# Use the nn package to define our model as a sequence of layers. nn.Sequential
# is a Module which contains other Modules, and applies them in sequence to
# produce its output. Each Linear Module computes output from input using a
# linear function, and holds internal Tensors for its weight and bias.
  model = torch.nn.Sequential(
    torch.nn.Linear(D_in, H),
    torch.nn.ReLU(),
    torch.nn.Linear(H, D_out)
   )

# The nn package also contains definitions of popular loss functions; in this
# case we will use Mean Squared Error (MSE) as our loss function.
  loss_fn = torch.nn.MSELoss(reduction='sum')


  error_toa = []
  for i in range(50):
   x, y = datasets.make_friedman1(n_samples=100, n_features=5, noise=1)
   x, y = x.astype(np.float32), y.astype(np.float32)
   x,y = torch.from_numpy(x),torch.from_numpy(y)
   #x = x.float()
   y  =y.view(100,1)
   error = []
   model = torch.nn.Sequential(
    torch.nn.Linear(D_in, H),
    torch.nn.ReLU(),
    torch.nn.Linear(H, D_out)
   )
   loss_fn = torch.nn.MSELoss(reduction='sum')
   learning_rate = 1e-4
   for t in range(200):
    # Forward pass: compute predicted y by passing x to the model. Module objects
    # override the __call__ operator so you can call them like functions. When
    # doing so you pass a Tensor of input data to the Module and it produces
    # a Tensor of output data.
    y_pred = model(x)

    # Compute and print loss. We pass Tensors containing the predicted and true
    # values of y, and the loss function returns a Tensor containing the
    # loss.
    loss = loss_fn(y_pred, y)
    #if t % 100 == 99:
        #print(t, loss.item()/100)

    # Zero the gradients before running the backward pass.
    model.zero_grad()

    # Backward pass: compute gradient of the loss with respect to all the learnable
    # parameters of the model. Internally, the parameters of each Module are stored
    # in Tensors with requires_grad=True, so this call will compute gradients for
    # all learnable parameters in the model.
    loss.backward()

    # Update the weights using gradient descent. Each parameter is a Tensor, so
    # we can access its gradients like we did before.
    with torch.no_grad():
        for param in model.parameters():
            param -= learning_rate * param.grad
    y1_pred = model(x1)
    print(y1_pred)
    # Compute and print loss. We pass Tensors containing the predicted and true
    # values of y, and the loss function returns a Tensor containing the
    # loss.
    loss = loss_fn(y1_pred, y1)
    print(np.sqrt(loss.item()/10000))
    error.append(np.sqrt(loss.item()/10000))
   error_toa.append(error)   
  return error_toa

def al():

  import torch

# N is batch size; D_in is input dimension;
# H is hidden dimension; D_out is output dimension.
  N, D_in, H, D_out = 100, 5, 4, 1

# Create random Tensors to hold inputs and outputs

#x = x.float()
  x1, y1 = datasets.make_friedman1(n_samples=10000, n_features=5, noise=1)
  x1, y1 = x1.astype(np.float32), y1.astype(np.float32)
  x1,y1 = torch.from_numpy(x1),torch.from_numpy(y1)
#x = x.float()
  y1 =y1.view(10000,1)

# Use the nn package to define our model as a sequence of layers. nn.Sequential
# is a Module which contains other Modules, and applies them in sequence to
# produce its output. Each Linear Module computes output from input using a
# linear function, and holds internal Tensors for its weight and bias.

  error_toa1 = []
  for i in range(50):
   x, y = datasets.make_friedman1(n_samples=100, n_features=5, noise=1)
   x, y = x.astype(np.float32), y.astype(np.float32)
   x,y = torch.from_numpy(x),torch.from_numpy(y)
   y  =y.view(100,1)
   error1 = []
   model = torch.nn.Sequential(
    torch.nn.Linear(D_in, H),
    torch.nn.ReLU(),
    torch.nn.Linear(H, D_out)
  )

# The nn package also contains definitions of popular loss functions; in this
# case we will use Mean Squared Error (MSE) as our loss function.
   loss_fn = torch.nn.MSELoss(reduction='sum')
   learning_rate = 1e-4
   for t in range(200):
    # Forward pass: compute predicted y by passing x to the model. Module objects
    # override the __call__ operator so you can call them like functions. When
    # doing so you pass a Tensor of input data to the Module and it produces
    # a Tensor of output data.
    y_pred = model(x)

    # Compute and print loss. We pass Tensors containing the predicted and true
    # values of y, and the loss function returns a Tensor containing the
    # loss.
    loss = loss_fn(y_pred, y)
    #if t % 100 == 99:
        #print(t, loss.item()/100)

    # Zero the gradients before running the backward pass.
    model.zero_grad()

    # Backward pass: compute gradient of the loss with respect to all the learnable
    # parameters of the model. Internally, the parameters of each Module are stored
    # in Tensors with requires_grad=True, so this call will compute gradients for
    # all learnable parameters in the model.
    loss.backward()

    # Update the weights using gradient descent. Each parameter is a Tensor, so
    # we can access its gradients like we did before.
    it = 0
    with torch.no_grad():
        for param in model.parameters():
            if it == 0:
                if t %3 == 0:
                  param.T[0] -= learning_rate * param.grad.T[0]
                  param.T[1] -= learning_rate * param.grad.T[1]
                  param.T[4] -= learning_rate * param.grad.T[4]
                if t %3 == 1:
                  param.T[3] -= learning_rate * param.grad.T[3]
                else: 
                  param.T[2] -= learning_rate * param.grad.T[2]
            else: 
                  param -= learning_rate * param.grad
            it = it + 1
    y1_pred = model(x1)

    # Compute and print loss. We pass Tensors containing the predicted and true
    # values of y, and the loss function returns a Tensor containing the
    # loss.
    loss = loss_fn(y1_pred, y1)
    print(np.sqrt(loss.item()/10000))
    error1.append(np.sqrt(loss.item()/10000))
   error_toa1.append(error1)   
  return error_toa1

def plot_al(error_toa, error_toa1):
  mean = []
  for i in range(200):
    p = 0
    for k in range(50):
        p = p + error_toa[k][i]
    mean.append(p/50)
  mean1 = []
  for i in range(200):
    p = 0
    for k in range(50):
        p = p + error_toa1[k][i]
    mean1.append(p/50)
  std = np.std(error_toa, axis = 0)
  std1 = np.std(error_toa1, axis = 0)
  mean = np.array(mean)
  mean1 = np.array(mean1)
  fig = plt.figure(figsize = (10,8))
  plt.plot(mean1,'r',label = 'Assisted Learning',linewidth = 3,linestyle = '--')
  plt.plot(mean, 'b', label = 'Oracle',linewidth = 3,linestyle = '-.')
  plt.xlabel('Rounds of Assistance',fontsize = 25)
  plt.ylabel('Prediction Error',fontsize = 25)
  legend = plt.legend(loc='upper right', shadow=True, fontsize='x-large')
  font = {'family' : 'normal',
        'weight' : 'normal',
        'size'   : 22}
  plt.rc('font', **font)
#ax.set(ylim=(160,240))
#ax.set(xlim=(0,10))
  legend = plt.legend(loc='upper right', shadow=True, fontsize='x-large')
  plt.fill_between(np.arange(200),mean1-std1,mean1+std1,alpha=0.1, color = 'red')
  plt.fill_between(np.arange(200),mean-std,mean+std,alpha=0.1, color = 'blue')
  plt.show()

if __name__ == '__main__':
     test_error, oracle = al(), oracle()
     plot_al(oracle,test_error)





