#!/bin/bash

set -x -e -u -o pipefail
cd ..

PATIENCE=8
DROPOUT=0.4
WARMUP=0
ENC_LAYERS=1

if [ ${SCALES} == "8+12" ]; then
    LEVEL0=i3d-features/span=8_stride=2
    LEVEL1=i3d-features/span=12_stride=2
    MULTILV_ARGS='{"span_lengths": [8, 12], "level_links": [[1, 0]], "stride": 2, "eye": true, "same_level_links": true, "symmetric": true}' 
elif [ ${SCALES} == "8+16" ]; then
    LEVEL0=i3d-features/span=8_stride=2
    LEVEL1=i3d-features/span=16_stride=2
    MULTILV_ARGS='{"span_lengths": [8, 16], "level_links": [[1, 0]], "stride": 2, "eye": true, "same_level_links": true, "symmetric": true}' 
elif [ ${SCALES} == "12+16" ]; then
    LEVEL0=i3d-features/span=12_stride=2
    LEVEL1=i3d-features/span=16_stride=2
    MULTILV_ARGS='{"span_lengths": [12, 16], "level_links": [[1, 0]], "stride": 2, "eye": true, "same_level_links": true, "symmetric": true}' 
fi


VOCAB=25000
CUDA_VISIBLE_DEVICES=0 python test_scripts/test_sign_local.py data-bin/phoenix2014T/sp${VOCAB} \
        --task translation_sign \
        --target-lang de \
        --max-tokens 4096 \
        --num-levels 2 \
        --multilv-args "${MULTILV_ARGS}" \
        --src-lv0-body-feat-root ${LEVEL0} \
        --src-lv1-body-feat-root ${LEVEL1} \
        --arch transformer_sign \
        --encoder-embed-dim 1024 \
        --decoder-embed-dim 300 \
        --warmup-updates ${WARMUP} \
        --lr 1e-04 \
        --lr-shrink 0.5 \
        --lr-patience ${PATIENCE} \
        --lr-scheduler reduce_lr_on_plateau \
        --lr-mode max \
        --optimizer adam \
        --activation-fn gelu \
        --criterion label_smoothed_cross_entropy \
        --valid-subset test \
        --label-smoothing 0.1 \
        --weight-decay 0.0001 \
        --dropout ${DROPOUT} \
        --max-epoch 200 \
        --save-interval 1 \
        --eval-bleu \
        --eval-bleu-args '{"beam": 10, "max_len_a": 1.2, "max_len_b": 10}' \
        --eval-tokenized-bleu \
        --eval-bleu-remove-bpe sentencepiece \
        --eval-bleu-detok space \
        --best-checkpoint-metric bleu \
        --maximize-best-checkpoint-metric \
        --decoder-embed-path data-bin/phoenix2014T/sp${VOCAB}/emb \
        --decoder-attention-heads 10 \
        --validate-interval 1 \
        --encoder-layers 1 \
        --no-epoch-checkpoints \
        --no-last-checkpoints \
        --encoder-learned-pos \
        --decoder-learned-pos \
        --restore-file ${CHECKPOINT}


