% Recover sparse factors B and C from transposed KRP matrix X_o_est
% X_o is the true X_o_est if available. It is only used to calculate the
% error. J and K are the dimensions (# of columns) in B and C respectively.
% This is a SVD-based algorithm.
% Sirisha Rambhatla, 2019 
% sirishar@usc.edu

function [B, C] = recover_krp(X_o_est, X_o, J, K)
Mat = X_o_est';
f = size(Mat,2);

B = zeros(J, f);
C = zeros(K, f);

for i = 1:f
    temp = reshape(Mat(:,i),J,K);
    [b, s, c] = svds(temp,1);
    if size(b,2)
        B(:,i) = s*b;
        C(:,i) = c;
    end
end
X_r = KRP(C, B)';
display(['Resulting error between KRPs = ', num2str(norm(X_r - full(X_o))/norm(full(X_o)),4)])
