# Gibbs Sampling with People

This repository provides raw code for the experiments reported in the paper **Gibbs Sampling with People**.

## PsyNet

We implemented all experiments in PsyNet, our new framework for implementing complex experiment paradigms such as GSP and MCMCP. This framework builds on the Dallinger platform for experiment hosting and deployment. Participants interact with the experiment via their web browser, which communicates with a back-end Python server cluster responsible for organizing the timeline of the experiment (Figure 1 in Supplementary Materials). This cluster is mostly managed by Heroku, and comprises a customizable collection of virtual instances that share the experiment management and stimulus generation workload, as well as a PostgreSQL database instance for storing results. In some experiments we additionally used Amazon Web Services (AWS) S3 storage for hosting stimuli, and an AWS Elasic Compute Cloud (EC2) instance with an NVIDIA K80 GPU for deep neural network synthesis.

## Requirements

The dependencies for each experiment are provided in `requirements.txt`,
with the exception of PsyNet, which must be already installed on
the target system.

PsyNet is still in alpha, and its API has yet to solidify completely.
The codebase was in flux throughout the described experiments.
Moreover, it depends on the fairly complex Dallinger stack, which has
its own fairly complex installation process (http://docs.dallinger.io/en/latest/index.html).
Reproducing these experiments would therefore likely involve some detailed debugging;
the enclosed code is therefore more intended for reading than for running.
However, please contact the authors if you would like advice about
running one of these experiments.
We plan to release a properly supported version of PsyNet in the coming months.

### Experiments

Refer to Table 1 and Table 2 in the Supplementary Materials for more information about the experiments.
In this repository, we provide the code for the following experiments:

- 1c Color (GSP with aggregation).
- 1d Color (validation for 1a, 1b, 1c)
- 2a Prosody (within)
- 2b Prosody (across)
- 2c Prosody (validation for 2a)
- 2d Prosody (validation for 2b)
- 3a Musical chords
- 3b Musical chords (validation)
- 4a Faces US (GSP with mean aggregation)
- 4b Faces (validation for 4a)

The remaining experiments can be reproduced by trivial parameter changes
in the source files.
