bruck_mr= importdata('bruck_mean_in_modest_nip_new.mat');
bruck_sd = importdata('bruck_std_in_modest_nip_new.mat');
bisect_mr = importdata('bisect_mean_in_modest_nip_new.mat');
bisect_sd = importdata('bisect_std_in_modest_nip_ew.mat');
size_range = [100, 200, 300, 400, 500, 600, 700, 800, 900, 1000, 1100, 1200];
%size_range = [100, 200, 300, 400, 500, 600, 700, 800];

bruck_conf = zeros(size(size_range, 1), 1);
bisect_conf = zeros(size(size_range, 1), 1);

N = 10;
SEM_bruck = bruck_sd/ sqrt(N);
SEM_bisect = bisect_sd / sqrt(N);
CI95 = tinv(0.975, N-1);

for i=1:size(bruck_mr, 1)
   bruck_conf(i, 1) = SEM_bruck(i,1) * CI95;
   bisect_conf(i, 1) = SEM_bisect(i, 1) * CI95;
end

fig = figure(1);
%subplot(2,2,1);
subplot(1, 2, 1);
hold on
grid on;
xlabel('m');
ylabel('Running time (seconds)');
errorbar(size_range, bruck_mr, bruck_conf, 'LineStyle',  '--',  'color', 'blue');
errorbar(size_range, bisect_mr, bisect_conf, 'LineStyle', '-.', 'color', '#77AC30');
legend('Interior Point', 'Bisection SDP')

%-----

bruck_mr= importdata('bruck_mean_in_severe_nip_new.mat');
bruck_sd = importdata('bruck_std_in_severe_nip_new.mat');
bisect_mr = importdata('bisect_mean_in_severe_nip_new.mat');
bisect_sd = importdata('bisect_std_in_severe_nip_new.mat');
size_range = [100, 200, 300, 400, 500, 600, 700, 800, 900, 1000, 1100, 1200];
%size_range = [100, 200, 300, 400, 500, 600, 700, 800];

bruck_conf = zeros(size(size_range, 1), 1);
bisect_conf = zeros(size(size_range, 1), 1);

N = 10;
SEM_bruck = bruck_sd/ sqrt(N);
SEM_bisect = bisect_sd / sqrt(N);
CI95 = tinv(0.975, N-1);

for i=1:size(bruck_mr, 1)
   bruck_conf(i, 1) = SEM_bruck(i,1) * CI95;
   bisect_conf(i, 1) = SEM_bisect(i, 1) * CI95;
end

subplot(1,2,2);
hold on
grid on;
xlabel('m');
ylabel('Running time (seconds)');
errorbar(size_range, bruck_mr, bruck_conf, 'LineStyle',  '--',  'color', 'blue');
errorbar(size_range, bisect_mr, bisect_conf, 'LineStyle', '-.', 'color', '#77AC30');
legend('Interior Point', 'Bisection SDP')

%-------

%bruck_mr= importdata('bruck_mean_wine_modest.mat');
%bruck_sd = importdata('bruck_std_wine_modest.mat');
%bisect_mr = importdata('bisect_mean_wine_modest.mat');
%bisect_sd = importdata('bisect_std_wine_modest.mat');
%size_range = [100, 200, 300, 400, 500, 600, 700, 800];

%bruck_conf = zeros(size(size_range, 1), 1);
%bisect_conf = zeros(size(size_range, 1), 1);

%N = 10;
%SEM_bruck = bruck_sd/ sqrt(N);
%SEM_bisect = bisect_sd / sqrt(N);
%CI95 = tinv(0.975, N-1);

%for i=1:size(bruck_mr, 1)
   %bruck_conf(i, 1) = SEM_bruck(i,1) * CI95;
   %bisect_conf(i, 1) = SEM_bisect(i, 1) * CI95;
%end

% subplot(2,2,3);
% hold on
% grid on;
% xlabel('m');
% ylabel('Running time (seconds)');
% errorbar(size_range, bruck_mr, bruck_conf, 'LineStyle',  '--',  'color', 'blue');
% errorbar(size_range, bisect_mr, bisect_conf, 'LineStyle', '-.', 'color', '#77AC30');
% legend('Interior Point', 'Bisection SDP')

%-------

% bruck_mr= importdata('bruck_mean_wine_severe.mat');
% bruck_sd = importdata('bruck_std_wine_severe.mat');
% bisect_mr = importdata('bisect_mean_wine_severe.mat');
% bisect_sd = importdata('bisect_std_wine_severe.mat');
% size_range = [100, 200, 300, 400, 500, 600, 700, 800];
% 
% bruck_conf = zeros(size(size_range, 1), 1);
% bisect_conf = zeros(size(size_range, 1), 1);
% 
% N = 10;
% SEM_bruck = bruck_sd/ sqrt(N);
% SEM_bisect = bisect_sd / sqrt(N);
% CI95 = tinv(0.975, N-1);
% 
% for i=1:size(bruck_mr, 1)
%    bruck_conf(i, 1) = SEM_bruck(i,1) * CI95;
%    bisect_conf(i, 1) = SEM_bisect(i, 1) * CI95;
% end

% subplot(2,2,4);
% hold on
% grid on;
% xlabel('m');
% ylabel('Running time (seconds)');
% errorbar(size_range, bruck_mr, bruck_conf, 'LineStyle',  '--',  'color', 'blue');
% errorbar(size_range, bisect_mr, bisect_conf, 'LineStyle', '-.', 'color', '#77AC30');
% legend('Interior Point', 'Bisection SDP')

%-------