# Fast MRI

### Python configuration

Create a python3 conda environment if you don't already have one
```
conda create -n pyenv python=3
```

Install pytorch 1.0 into that environment,
```
conda install pytorch torchvision cudatoolkit=9.0 -c pytorch
```
then pip-install the requirements file for this project
```
pip install -r requirements.txt
```

Then use the following in your `.profile` file
```
module load tmux/2.8/gcc.7.3.0
module load anaconda3/5.0.1
module load cuda/9.0
module load NCCL/2.2.13-cuda.9.0
module load cudnn/v7.0-cuda.9.0

source activate pyenv
```

Source the profile file with `source ~/.profile` to activate it. Add any new packages
to the requirements file if you add code that needs them.

### Boiler plate

#### Scripts

The repo is setup as one big python package so that everybody can use common code.
In order for this to work, you need to add 3 lines to the top of any python script you want to run directly.
```
import sys
sys.path.append(sys.path[0] + "/..") # Use "/../.." as needed so that this path is the top level of the repo
__package__ = "foldername" # foldername should be your module/folder name containing the script.
```

With this boiler plate you can access code using the project directory structure, for instance,
to use a function in `fastmri/common/imagenet_loader.py`, use `import fastmri.common.imagenet_loader`.

#### Modules

Every folder should have an `__init__.py` file, so that python treats it as a module.

### Running a script (debugging/testing etc.)

make sure you have the above boiler-plate. Then at the top level you can do any of:
```
ipython scripts/examples/public_example.py
OR
ipython -m scripts.examples.public_example
OR
cd scripts/examples
ipython public_example.py
```

### Relative imports
Under your own directory, you need to import your own code with relative imports, for instance
```
from .models import named_models
```
instead of just `from models import named_models`.

You also need to have a `__init__.py` file (it can be blank), so that python knows it's a module.

### Unit tests

We use the [pytest](http://pytest.readthedocs.io/en/latest/getting-started.html) testing framework. Running the tests is as easy as:
```
	pytest
```

It fully supports unittest tests, so if that's what you are familiar with you can continue to use them.
