import matlab.engine
import sys
sys.path.append('..')
import numpy as np 
import torch
from hyperbox import Hyperbox
from interval_analysis import HBoxIA
from relu_nets import ReLUNet
from lipMIP import LipProblem
from other_methods import CLEVER, FastLip, LipLP, LipSDP, NaiveUB, RandomLB, SeqLip
from neural_nets import train
from neural_nets import data_loaders as dl
from experiment import Experiment, InstanceGroup, Result, ResultList, MethodNest
from utilities import Factory
import math
import neural_nets.data_loaders as dl 
import neural_nets.train as train
import pickle

box_methods = [CLEVER, FastLip, LipLP, LipSDP, NaiveUB, RandomLB, LipProblem, SeqLip]
local_methods = [LipProblem, LipLP, FastLip, RandomLB, CLEVER]
global_methods = [SeqLip, LipSDP, NaiveUB]
NUM_THREADS = 1


def test_random(layer_sizes, k_trials):
    # Good parameters are [16, 16, 16, 2]
    c_vector = np.array([1.0])
    global_results = []
    for _ in range(k_trials):
        random_net = ReLUNet(layer_sizes=layer_sizes)
        global_exp = Experiment([LipProblem], network=random_net, primal_norm='l1', c_vector=c_vector, num_threads=2, verbose=True)
        global_exp.do_large_radius_eval(1000.0)
        global_results.append(global_exp.do_unit_hypercube_eval())
    return global_results


if __name__ == '__main__':
	LAYERS = [10,10,10, 1]
	TRIALS = 5000
	FILENAME = 'l1_exp_random_10-3.pkl'

	results = test_random(LAYERS, TRIALS)
	with open(FILENAME, 'wb') as f:
		pickle.dump(results, f)

