import numpy as np
import pandas as pd
import networkx as nx

ground_truth = {
    "asia": [(0, 1), (1, 0), (1, 5), (2, 3), (2, 4), (3, 2), (3, 5), (4, 2), (4, 7), (7, 4)],
    "cancer": [(0, 2), (1, 2), (2, 3), (4, 2)],
    "earthquake": [(0, 2), (1, 2), (2, 3), (2, 4)],
    "survey": [(2, 3), (2, 4), (4, 2), (4, 5), (5, 3), (5, 4)],
}

def bn_data(name, feature=None, size=10000):
    data = pd.read_csv("../data/"+name+".csv")
    data = data.drop("Unnamed: 0", axis=1)
    data = data.astype('category')
    data = data.apply(lambda x: x.cat.codes)
    data = np.array(data)
    data = data.astype(int)

    node_size = data.shape[1]
    g_answer = nx.DiGraph()
    g_answer.add_nodes_from(np.arange(node_size))
    g_answer.add_edges_from(ground_truth[name])

    if feature is None:
        feature = data.shape[1]

    return data[:size, :feature], g_answer
