import torch
import matplotlib
import matplotlib.pyplot as plt
import numpy as np
import imageio

def plot_gif(before_project, after_project, arrow, name = '0'):
    def generate_one_frame(data, pred, arrow, xy_max = 2):

        fig, ax = plt.subplots(figsize=(10,10))

        X, Y, U, V = zip(*[arrow])
        ax.quiver(X, Y, U, V, angles='xy', scale_units='xy', scale=1)

        ax.scatter(data[:,0], data[:,1], c = 'y')
        ax.scatter(pred[:,0], pred[:,1], c = 'b')       
        ax.grid()
        ax.set(xlabel='X', ylabel='Y', title='yellow: points before projection; blue: after projection.')
        ax.set_xlim(-xy_max, xy_max)
        ax.set_ylim(-xy_max, xy_max)
        fig.canvas.draw()     

        image = np.frombuffer(fig.canvas.tostring_rgb(), dtype='uint8')
        image  = image.reshape(fig.canvas.get_width_height()[::-1] + (3,))
        
        return image
    
    imageio.mimsave('./visulization_' + name + '.gif', [
        generate_one_frame(before_project[i], after_project[i], arrow[i]) 
        for i in range(len(before_project))
        ], fps=10)

class Proj():
    def __init__(self):
        model_path = 'models/checkpoint _350.pt'
        self.model = torch.load(model_path).cpu()
        print(self.model.iter)
    def project(self, data):
        d = torch.Tensor(data[None, :, :])
        pred = self.model(d)
        pred = pred[0,:,:]
        return pred.detach().numpy()

def test(te = 0):
    data = np.zeros([16,2])
    dx = 1.0/4
    for i in range(4):
        for j in range(4):
            data[i*4+j, 0] = i * dx
            data[i*4+j, 1] = j * dx
    if te == 0:
        force = lambda t: np.array([np.sin(t*2), np.cos(t*2)]) * 10
    else :
        force = lambda t: np.array([np.sin(t*2), -np.cos(t*2)]) * 10
    force2 = lambda t: np.array([np.sin(t*2), -np.cos(t/0.5)]) * 10
    vel = np.array(data)*0
    timestamp = 0.1
    data_list = []
    proj_list = []
    force_list = []
    pr = Proj()
    for ite in range(50):
        new_data = np.array(data)
        
        f_0 = force(ite * timestamp)
        vel[0, :] += f_0 * timestamp

        if te >= 2:
            f_15 = force2(ite * timestamp)
            vel[15, :] += f_15 * timestamp

        for i in range (len(data)):
            new_data[i, :] = data[i,:] + vel[i,:] * timestamp   

        data_list.append(np.array(new_data))

        if te < 2:
            force_list.append(np.array([new_data[0,0], new_data[0,1], f_0[0]/20, f_0[1]/20]))
        else :
            force_list.append(np.array([[new_data[0,0], new_data[15,0]], 
                                        [new_data[0,1], new_data[15,1]],
                                        [f_0[0]/20, f_15[0]/20],
                                        [f_0[1]/20, f_15[1]/20]]))

        new_data = pr.project(new_data)
        proj_list.append(np.array(new_data))
        
        for i in range (len(data)):
            vel[i,:] = (new_data[i,:] - data[i,:]) / timestamp
        data = np.array(new_data)

    plot_gif(data_list, proj_list, force_list, 'rigid_16_' + str(te))




if __name__ == '__main__':
    test(0)
    test(1)
    test(2)