import torch
import matplotlib
import matplotlib.pyplot as plt
import numpy as np
import imageio
from cal_constraints import *
from proj_io_adapter_io_adapter import *

DEMO = "rope_short_nn"
MODEL_PATH = 'models/rope_8_nn.pt' 

# MODEL_PATH = 'models/rope_8_soft_bend.pt' 
# DEMO = "rope_short"


def plot_gif(before_project, after_project, arrow, name = '0'):
    def generate_one_frame(data, pred, arrow, xy_max = 2):

        fig, ax = plt.subplots(figsize=(10,10))

        X, Y, U, V = zip(*[arrow])
        ax.quiver(X, Y, U, V, angles='xy', scale_units='xy', scale=1)

        ax.scatter(data[:,0], data[:,1], c = 'y')
        ax.scatter(pred[:,0], pred[:,1], c = 'b')       
        ax.grid()
        ax.set(xlabel='X', ylabel='Y', title='yellow: points before projection; blue: after projection.')
        ax.set_xlim(-xy_max, xy_max)
        ax.set_ylim(-xy_max, xy_max)
        fig.canvas.draw()     
        # fig.show()

        image = np.frombuffer(fig.canvas.tostring_rgb(), dtype='uint8')
        image  = image.reshape(fig.canvas.get_width_height()[::-1] + (3,))


        return image
    
    imageio.mimsave('./gif/' + name + '.gif', [
        generate_one_frame(before_project[i], after_project[i], arrow[i]) 
        for i in range(len(before_project))
        ], fps=10)

def show_one_frame(data, pred, arrow, xy_max = 1):
    X, Y, U, V = zip(*[arrow])
    plt.quiver(X, Y, U, V, angles='xy', scale_units='xy', scale=1)

    plt.scatter(data[:,0], data[:,1], c = 'y')
    plt.scatter(pred[:,0], pred[:,1], c = 'b')       
    plt.grid()
    plt.title('yellow: points before projection; blue: after projection.')
    plt.xlim(-xy_max, xy_max)
    plt.ylim(-xy_max, xy_max)
    plt.show()


# def check_ground(pos):
#     if pos[1] > 1e-4:
#         return np.array([0,-2])
#     else:
#         return np.array([0,0])
    

class Proj():
    def __init__(self):
        model_path = MODEL_PATH
        self.model = torch.load(model_path).cpu()
        # print(self.model.iter)
        # self.model.iter = 1
        # print(self.model.iter)
    def project(self, data):
        d = torch.Tensor(data[None, :, :])
        pred = self.model(d)
        pred = pred[0,:,:]
        return pred.detach().numpy()

def test(te = 0):
    data = np.zeros([8,2])
    dx = 0.1
    timestamp = 0.1

    for i in range(data.shape[0]):
        data[i, 0] = i * dx
        data[i, 1] = 0

    if te == 0:
        # force0 = np.array([-2.0, 0.0]) 
        # force3 = np.array([0, 0]) 
        # force7 = np.array([2.0, 6.0])         
        # g = np.array([0, 0])        
        force0 = np.array([-2.0, 8.0]) 
        force3 = np.array([0, 0]) 
        force7 = np.array([2.0, 8.0])         
        g = np.array([0, -2])
    


    vel = np.array(data)*0
    data_list = [np.array(data)]
    proj_list = [np.array(data)]
    force_list = []

    force_list.append(np.array([
            [data[7,0], data[3,0], data[0,0]],
            [data[7,1], data[3,1], data[0,1]],
            [0, 0, 0], 
            [0, 0, 0]
            ]))

    pr = Proj()
    for ite in range(100):
        new_data = np.array(data)
        vel[7, :] += force7 * timestamp
        vel[3, :] += force3 * timestamp
        vel[0, :] += force0 * timestamp

        for i in range (0, len(data)):
            vel[i, :] += timestamp * g            
            # vel[i,:] += check_ground(data[i,:]) * timestamp
            new_data[i, :] = data[i,:] + vel[i,:] * timestamp 

        data_list.append(np.array(new_data))
        force_list.append(np.array([
            [new_data[7,0], new_data[3,0], new_data[0,0]],
            [new_data[7,1], new_data[3,1], new_data[0,1]],
            [force7[0]/20, force3[0]/20, force0[0]/20 ], 
            [force7[1]/20, force3[1]/20, force0[1]/20 ]
            ]))

        new_data = pr.project(new_data) 
        

        proj_list.append(np.array(new_data))
        
        for i in range (len(data)):
           vel[i,:] =  (new_data[i,:] - data[i,:]) / timestamp # vel[i,:] * 0.5 + 0.5 *
        # print(new_data); print(data); print(vel)
        # show_one_frame(data_list[-1], proj_list[-1], force_list[-1])

        data = (np.array(new_data))
        # aaaaaaaaaaaaaaaaaaaa

    plot_gif(data_list, proj_list, force_list, DEMO)
    run(proj_list, [0,1,1,0,0], None, DEMO)
    write_viewer(proj_list, output_dir = "output_" + DEMO)
    cal_mse(proj_list, 4, DEMO)




if __name__ == '__main__':
    test()