% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampling.R
\name{sample_causal}
\alias{sample_causal}
\title{Sample conditional Gaussian variables following a causal chain graph with do-calculus.}
\usage{
sample_causal(
  index_given,
  n_samples,
  mu,
  cov_mat,
  m,
  x_test,
  ordering = list(c(seq(m))),
  confounding = rep(FALSE, length(ordering))
)
}
\arguments{
\item{index_given}{Integer vector. The indices of the features to condition upon. Note that
\code{min(index_given) >= 1} and \code{max(index_given) <= m}.}

\item{m}{Positive integer. The total number of features.}

\item{x_test}{Numeric matrix. Contains the features of the observation whose
predictions ought to be explained (test data).}
}
\value{
data.table
}
\description{
Sample conditional Gaussian variables following a causal chain graph with do-calculus.
}
\examples{
m <- 10
n_samples <- 50
mu <- rep(1, m)
cov_mat <- cov(matrix(rnorm(n_samples * m), n_samples, m))
x_test <- matrix(MASS::mvrnorm(1, mu, cov_mat), nrow = 1)
cnms <- paste0("x", seq(m))
colnames(x_test) <- cnms
index_given <- c(4, 7)
ordering <- list(c(1:3), c(4:6), c(7:10))
confounding <- c(TRUE, FALSE, TRUE)
r <- shapr:::sample_causal(index_given, n_samples, mu, cov_mat, m, x_test, ordering, confounding)

}
\keyword{internal}
