MakePopulationLevelPlots <- function(dataPath, plotsPath){
  load(dataPath)
  treatmentLevelExposure <- ggplot(modelParametersWithTreatment, aes(x = treatmentLevelExposure, color = treatment)) + 
    geom_histogram(fill="white", alpha=0.5, position ="dodge", bins = 100) 
  firstOrderEffect <- ggplot(response, aes(x = firstOrderEffect,  color = treatment)) + 
    geom_histogram(fill="white", alpha=0.5, position = "dodge", bins = 100) + xlab("first order effect W(i)")
  noiseFreeSecondOrderEffect <- ggplot(response, aes(x = noiseFreeSecondOrderEffect,  color = treatment)) + 
    geom_histogram(fill="white", alpha=0.5, position = "dodge", bins = 100) + xlab("noise free second order effect Z(i)")
  secondOrderEffectWithNoise <- ggplot(response, aes(x = secondOrderEffectWithNoise,  color = treatment)) + 
    geom_histogram(fill="white", alpha=0.5, position = "dodge", bins = 100) + xlab("observed second order effect X(i)")
  noiseFreeresponse <- ggplot(response, aes(x = noiseFree,  color = treatment)) + 
    geom_histogram(fill="white", alpha=0.5, position = "dodge", bins = 100) + xlab("noise free response") 
  responseWithNoise <- ggplot(response, aes(x = withNoise,  color = treatment)) + 
    geom_histogram(fill="white", alpha=0.5, position = "dodge", bins = 100) + xlab("response Y(i)") 
  noiseFreeFeedback <- ggplot(feedback, aes(x = noiseFree, color = treatment)) + 
    geom_histogram(fill="white", alpha=0.5, position = "dodge", bins = 100) +  xlab("noise free individual feedback Z(i, j)")
  feedbackWithNoise <- ggplot(feedback, aes(x = withNoise,  color = treatment)) + 
    geom_histogram(fill="white", alpha=0.5, position = "dodge", bins = 100) +  xlab("observed individual feedback X(i, j)")
  
  fileName <- paste0(plotsPath, "population_delta=", delta, "_beta=", beta, ".pdf")
  pdf(file = fileName, width = 12, height = 18)
  grid.arrange(treatmentLevelExposure, firstOrderEffect, 
               noiseFreeSecondOrderEffect, secondOrderEffectWithNoise, 
               noiseFreeresponse, responseWithNoise,
               noiseFreeFeedback, feedbackWithNoise, ncol = 2)
  dev.off()
  
}