GetClusterBasedMeanEstimate <- function(experimentData){
  estimate <- experimentData %>% group_by(producerInTreatment) %>%
    summarise(clusterBased = mean(withNoise))
}

GetClusterBasedEstimate <- function(experimentId, GetExperimentDataPath, beta, delta, nBootIter = 100, nCores = 1){
  cat(paste0("Computing cluster based estimates for delta = ", delta, ", beta = ", beta, " and experimentId = ", experimentId, "\n"))
  load(GetExperimentDataPath(experimentId, delta, beta))
  experimentData <- experimentData %>% filter(!is.na(producerInTreatment))
  estimate <- GetClusterBasedMeanEstimate(experimentData)
  bootstrapEstimates <- mclapply(1:nBootIter, 
                                 function (i) GetClusterBasedMeanEstimate(experimentData[sample(nrow(experimentData), 
                                                                                    replace = TRUE), ]), mc.cores = nCores)
  bootstrapEstimates <- do.call("rbind", bootstrapEstimates)
  bootstrapVar <- bootstrapEstimates %>% group_by(producerInTreatment) %>% 
    summarise(clusterBasedBootVar = var(clusterBased))
  estimate <- estimate %>% left_join(bootstrapVar, "producerInTreatment")
  estimate$experimentId <- experimentId
  estimate$delta <- delta
  estimate$beta <- beta
  return(estimate)
}