# function for generating an undirected graph of size p = clusterSize * nClusters, 
# by combining an Erdos-Renyi graph and a union of nClusters Barabasi-Albert grahs 
GenerateNetwork <- function(clusterSize, nClusters = 1, avgDegree, power = 1, avgDegreeRatio = 1, seed = sample.int(10000, 1)){
  set.seed(seed)
  withinClusterAvgDegree <- avgDegree * avgDegreeRatio / (1 + avgDegreeRatio) # average degree for each Barabasi-Albert cluster
  betweenClusterAvgDegree <- avgDegree - withinClusterAvgDegree # average degree for the Erdos-Renyi graph
  if (nClusters == 1){
    network <- sample_pa(clusterSize, power, 
                     out.seq = c(0, sapply(1:(clusterSize - 1), function(i) rbinom(1, round(avgDegree, 0), 0.5))),
                     directed = FALSE)
  }else{
    network <- lapply(1:nClusters, 
                      function(i) GenerateNetwork(clusterSize, nClusters = 1, withinClusterAvgDegree, power, seed = seed * i))
    network <- disjoint_union(network)
    networkSize <- clusterSize * nClusters
    network <- network %u% sample_gnp(networkSize, betweenClusterAvgDegree / (networkSize -1))
  }
  return(network)
}