GenerateExperimentData <- function(experimentId, designPath, deltaSeq, betaSeq, outputPath, seed = sample.int(10000, 1)){
  set.seed(seed * experimentId)
  load(designPath[experimentId])
  experimentDataPathList <- list()
  cat(paste0("Generating data for experiment ", experimentId, "\n"))
  for (delta in deltaSeq){
    for (beta in betaSeq){
      parameters <- fullDesign %>% select(consumer, producer, edgeStrength, producerInTreatment, consumerInTreatment,
                                          treatmentLevelExposure = experimentLevelExposure)
      experimentData <- GenerateData(parameters %>% mutate(treatment = "TStar"),
                                     delta = delta, beta = beta, feedbackNoise = feedbackNoise, responseNoise = responseNoise)
      producerInTreatment <- fullDesign %>% group_by(producer) %>% summarise(producerInTreatment = first(producerInTreatment))
      experimentData$response <- experimentData$response %>% select(-treatment) %>% left_join(producerInTreatment, by = "producer") %>% 
        filter(!is.na(producerInTreatment))
      experimentData$feedback <- experimentData$feedback  %>% select(-treatment) %>% 
        filter(!is.na(producerInTreatment) & consumerInTreatment > 0) %>%
        filter(producerInTreatment == consumerInTreatment) %>% group_by(producer) %>% 
        summarise(treatment = first(producerInTreatment), pureTreatmentDegree = n(),
                  noiseFreeFeedbackSum = sum(noiseFree), noiseFreeFeedbackSquaredSum = sum(noiseFree^2),
                  feedbackWithNoiseSum = sum(withNoise), feedbackWithNoiseSquaredSum = sum(withNoise^2))
      experimentData <- experimentData$response %>% left_join(experimentData$feedback, by = "producer")
      fileName <- paste0(outputPath, "experiment=", experimentId, "_delta=", delta, "_beta=", beta, ".Rdata")
      save(experimentData, file = fileName)
      experimentDataPathList <- c(experimentDataPathList, fileName)
    }
  }
  return(experimentDataPathList)
}