ResponseFunction <- function(firstOrderEffect, secondOrderEffect, beta){
  return(10 * plogis(firstOrderEffect + beta * secondOrderEffect * (1 + firstOrderEffect), scale = 10))
}

GenerateData <- function(parameters, delta = 1, beta = 1,
                         feedbackNoise = function(producer, consumer) return(rep(0, length(producer))),
                         responseNoise = function(producer) return(rep(0, length(producer)))){
  parametersWithFeedback <- parameters %>% 
    mutate(noiseFreeFeedback = edgeStrength * treatmentLevelExposure^{delta}) %>%
    mutate(feedbackWithNoise = noiseFreeFeedback + feedbackNoise(producer, consumer))
  
  paremetersWithFirstOrderEffect <- parameters %>% group_by(consumer) %>% 
    summarize(firstOrderEffect = mean(edgeStrength * treatmentLevelExposure) /  
                (mean(edgeStrength) * mean(treatmentLevelExposure)))
  
  response <- parametersWithFeedback %>% group_by(producer) %>%
    summarize(noiseFreeSecondOrderEffect = sum(noiseFreeFeedback),  
              secondOrderEffectWithNoise = sum(feedbackWithNoise), treatment = first(treatment)) %>%
    left_join(paremetersWithFirstOrderEffect, by = c("producer" = "consumer")) %>%
    mutate(noiseFree = ResponseFunction(firstOrderEffect, noiseFreeSecondOrderEffect, beta)) %>%
    mutate(withNoise = noiseFree + responseNoise(producer))
  
  parametersWithFeedback <- parametersWithFeedback %>% 
    rename(noiseFree = noiseFreeFeedback, withNoise = feedbackWithNoise)
  
  return(list(feedback = parametersWithFeedback, response = response))
}