# function for generating edge strengths and normalized base level exposures
AssignStrengthAndExposure <- function(j, strengthLim, exposureLim, seed){
  set.seed(seed * j)
  if (degree(network, j) > 0){
    strength <- runif(degree(network, j), min = strengthLim[1], max = strengthLim[2]) 
    exposure <- runif(degree(network, j), min = exposureLim[1], max = exposureLim[2])
    # normalize strength and exposure
    strength <- strength / degree(network, j)
    exposure <- exposure / sum(exposure)
    
    strengthAndexposure <- cbind(rep(j, degree(network, j)), neighbors(network, j), strength, exposure)
    colnames(strengthAndexposure) <- c("consumer", "producer", "edgeStrength", "baseLevelExposure")
    rownames(strengthAndexposure) <- as.character(neighbors(network, j))
    return(strengthAndexposure)
  }else{
    return(NULL)
  }
}

GenerateStrengthAndExposure <- function(network, strengthLim, exposureLim, nCores = 1, seed = sample.int(10000, 1)){
  strengthAndExposure <- mclapply(V(network), function(j) AssignStrengthAndExposure(j, strengthLim, exposureLim, seed),
                                   mc.cores = nCores)
  return(strengthAndExposure)
}
