# Unsupervised Meta Learning for Few-Shot Image Classification
The code for Unsupervised Meta Learning for Few-Shot Image Classification submission to Neurips

Here is an example of how to run the code on your computer:
You need to put your dataset in a directory. Each class should be in a separte directory containing all of the samples of that class.

In order to run MAML you just need to create a configuration and then run the algorithm on it:

```
omniglot_dataset = OmniglotDataset()
config = Configuration(
    model=SimpleModel,
    meta_learning_dataset=omniglot_dataset.get_train_dataset(),
    meta_learning_val_dataset=omniglot_dataset.get_validation_dataset(),
    meta_learning_iterations=15001,
    meta_learning_save_after_iterations=5000,
    meta_learning_log_after_iterations=100,
    meta_learning_summary_after_iterations=100,
    training_dataset=omniglot_dataset.get_test_dataset(),
    num_updates_meta_learning=5,
    num_updates_training=15,
    meta_batch_size=1,
    meta_learning_rate=0.001,
    learning_rate_meta_learning=0.1,
    learning_rate_training=0.1,
    n=5,
    k_meta_learning=1,
    k_training=1,
    meta_learning_log_dir='config',
    evaluation_log_dir='config',
    meta_learning_saving_path='config',
  training_saving_path=None,
  task_type='MAML_Supervised',
)
config.meta_learning()
config.evaluate()
```
Please refer to configuration.py file to see how it works.
Some of the settings are in settings.py
