/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.meteor.scorer;

import edu.cmu.meteor.aligner.Alignment;
import java.util.ArrayList;
import java.util.Scanner;

public class MeteorStats {
    public static final int STATS_LENGTH = 23;
    public double testLength;
    public double referenceLength;
    public double testFunctionWords;
    public double referenceFunctionWords;
    public double testTotalMatches;
    public double referenceTotalMatches;
    public ArrayList<Double> testStageMatchesContent;
    public ArrayList<Double> referenceStageMatchesContent;
    public ArrayList<Double> testStageMatchesFunction;
    public ArrayList<Double> referenceStageMatchesFunction;
    public double chunks;
    public double testWordMatches;
    public double referenceWordMatches;
    public double testWeightedMatches;
    public double referenceWeightedMatches;
    public double testWeightedLength;
    public double referenceWeightedLength;
    public double precision;
    public double recall;
    public double f1;
    public double fMean;
    public double fragPenalty;
    public double score;
    public Alignment alignment;

    public MeteorStats() {
        this.testLength = 0.0;
        this.referenceLength = 0.0;
        this.testFunctionWords = 0.0;
        this.referenceFunctionWords = 0.0;
        this.testTotalMatches = 0.0;
        this.referenceTotalMatches = 0.0;
        this.testStageMatchesContent = new ArrayList();
        this.referenceStageMatchesContent = new ArrayList();
        this.testStageMatchesFunction = new ArrayList();
        this.referenceStageMatchesFunction = new ArrayList();
        this.chunks = 0.0;
        this.testWordMatches = 0.0;
        this.referenceWordMatches = 0.0;
        this.testWeightedMatches = 0.0;
        this.referenceWeightedMatches = 0.0;
        this.testWeightedLength = 0.0;
        this.referenceWeightedLength = 0.0;
    }

    public void addStats(MeteorStats meteorStats) {
        int n;
        this.testLength += meteorStats.testLength;
        this.referenceLength += meteorStats.referenceLength;
        this.testFunctionWords += meteorStats.testFunctionWords;
        this.referenceFunctionWords += meteorStats.referenceFunctionWords;
        this.testTotalMatches += meteorStats.testTotalMatches;
        this.referenceTotalMatches += meteorStats.referenceTotalMatches;
        int n2 = meteorStats.referenceStageMatchesContent.size() - this.referenceStageMatchesContent.size();
        for (n = 0; n < n2; ++n) {
            this.testStageMatchesContent.add(0.0);
            this.referenceStageMatchesContent.add(0.0);
            this.testStageMatchesFunction.add(0.0);
            this.referenceStageMatchesFunction.add(0.0);
        }
        for (n = 0; n < meteorStats.testStageMatchesContent.size(); ++n) {
            this.testStageMatchesContent.set(n, this.testStageMatchesContent.get(n) + meteorStats.testStageMatchesContent.get(n));
        }
        for (n = 0; n < meteorStats.referenceStageMatchesContent.size(); ++n) {
            this.referenceStageMatchesContent.set(n, this.referenceStageMatchesContent.get(n) + meteorStats.referenceStageMatchesContent.get(n));
        }
        for (n = 0; n < meteorStats.testStageMatchesFunction.size(); ++n) {
            this.testStageMatchesFunction.set(n, this.testStageMatchesFunction.get(n) + meteorStats.testStageMatchesFunction.get(n));
        }
        for (n = 0; n < meteorStats.referenceStageMatchesFunction.size(); ++n) {
            this.referenceStageMatchesFunction.set(n, this.referenceStageMatchesFunction.get(n) + meteorStats.referenceStageMatchesFunction.get(n));
        }
        if (meteorStats.testTotalMatches != meteorStats.testLength || meteorStats.referenceTotalMatches != meteorStats.referenceLength || meteorStats.chunks != 1.0) {
            this.chunks += meteorStats.chunks;
        }
        this.testWordMatches += meteorStats.testWordMatches;
        this.referenceWordMatches += meteorStats.referenceWordMatches;
    }

    public String toString(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.testLength + string);
        stringBuilder.append(this.referenceLength + string);
        stringBuilder.append(this.testFunctionWords + string);
        stringBuilder.append(this.referenceFunctionWords + string);
        for (int i = 0; i < 4; ++i) {
            if (i < this.testStageMatchesContent.size()) {
                stringBuilder.append(this.testStageMatchesContent.get(i) + string);
                stringBuilder.append(this.referenceStageMatchesContent.get(i) + string);
                stringBuilder.append(this.testStageMatchesFunction.get(i) + string);
                stringBuilder.append(this.referenceStageMatchesFunction.get(i) + string);
                continue;
            }
            stringBuilder.append(0.0 + string);
            stringBuilder.append(0.0 + string);
            stringBuilder.append(0.0 + string);
            stringBuilder.append(0.0 + string);
        }
        stringBuilder.append(this.chunks + string);
        stringBuilder.append(this.testWordMatches + string);
        stringBuilder.append(this.referenceWordMatches + string);
        return stringBuilder.toString().trim();
    }

    public String toString() {
        return this.toString(" ");
    }

    public MeteorStats(String string) {
        Scanner scanner = new Scanner(string);
        this.testLength = scanner.nextDouble();
        this.referenceLength = scanner.nextDouble();
        this.testFunctionWords = scanner.nextDouble();
        this.referenceFunctionWords = scanner.nextDouble();
        this.testTotalMatches = 0.0;
        this.referenceTotalMatches = 0.0;
        this.testStageMatchesContent = new ArrayList();
        this.referenceStageMatchesContent = new ArrayList();
        this.testStageMatchesFunction = new ArrayList();
        this.referenceStageMatchesFunction = new ArrayList();
        for (int i = 0; i < 4; ++i) {
            double d = scanner.nextDouble();
            double d2 = scanner.nextDouble();
            this.testTotalMatches += d;
            this.referenceTotalMatches += d2;
            this.testStageMatchesContent.add(d);
            this.referenceStageMatchesContent.add(d2);
            double d3 = scanner.nextDouble();
            double d4 = scanner.nextDouble();
            this.testTotalMatches += d3;
            this.referenceTotalMatches += d4;
            this.testStageMatchesFunction.add(d3);
            this.referenceStageMatchesFunction.add(d4);
        }
        this.chunks = scanner.nextDouble();
        this.testWordMatches = scanner.nextDouble();
        this.referenceWordMatches = scanner.nextDouble();
    }
}

