"""
"""

import numpy as np
import scipy as sp


def clip(p):
    return np.maximum(np.minimum(p, (1.0 - 10**-8)), 10**-8)


def sigmoid(x):
    return clip(sp.special.expit(x))


def plogdet(x):
    sign, logdet = np.linalg.slogdet(x)
    if not (sign > 0):
        print(sign, logdet)
    assert(sign > 0)
    return logdet
