// Copyright 2004-present XXX. All Rights Reserved.

#ifndef CAFFE2_OPERATORS_BATCH_BUCKETIZE_OP_H_
#define CAFFE2_OPERATORS_BATCH_BUCKETIZE_OP_H_

#include "caffe2/core/context.h"
#include "caffe2/core/operator.h"
#include "caffe2/utils/math.h"

namespace caffe2 {

template <class Context>
class BatchBucketizeOp final : public Operator<Context> {
 public:
  USE_OPERATOR_CONTEXT_FUNCTIONS;

  BatchBucketizeOp(const OperatorDef& operator_def, Workspace* ws)
      : Operator<Context>(operator_def, ws) {}

  bool RunOnDevice() override;

 protected:
  INPUT_TAGS(FEATURE, INDICES, BOUNDARIES, LENGTHS);
  OUTPUT_TAGS(O);
};

} // namespace caffe2

#endif // CAFFE2_OPERATORS_BATCH_BUCKETIZE_OP_H_
