library("rjson")
library("rstudioapi")
library("ggpubr")
library("tidyverse")

current_path = rstudioapi::getActiveDocumentContext()$path 
setwd(dirname(current_path))
files <- list.files("./delta")

frame <- data.frame(epsilon=c(), value=c(), time=c(), algorithm=c(),
                    dimensions=c(), points=c(), k=c(), centers=c(), assignment=c())
c <- 0
acc <- 0
for (file in files) {
  json_data <- fromJSON(file=paste(getwd(), "/delta/", file, sep=""))

  epsilon <- json_data$data$epsilon
  number_points <- json_data$data$lengths
  number_dimensions <- json_data$data$dimension
  values <- list(json_data$without_rp$value, 
                 json_data$with_rp$value)
  k <- json_data$data$k
  times <- list(json_data$without_rp$`running-time`, json_data$with_rp$`running-time`)
  assignments <- list(json_data$without_rp$assignment, json_data$with_rp$assignment)
  centers <- list(json_data$without_rp$centers, json_data$with_rp$centers)
  
  c <- c + 1
  if (length(centers[[1]][!(centers[[1]] %in% centers[[2]])]) > 0) {
    acc <- acc + 1
  }
  if (k == 6) {
    assi <- assignments
  }
  # data <- list(datanames, values, times_searches, number_searches, times_bounds, epsilon)
  # key <- paste(datanames, epsilon)
  # print(paste("found data:", key))
  frame <- rbind(frame, data.frame(epsilon=epsilon, value=values[[1]],
                                   time=times[[1]]/60,
                                   algorithm="parallel",
                                   dimensions=number_dimensions,
                                   points=number_points,
                                   k=k))
  frame <- rbind(frame, data.frame(epsilon=epsilon, value=values[[2]],
                                   time=times[[2]]/60,
                                   algorithm="parallel_rp",
                                   dimensions=number_dimensions,
                                   points=number_points,
                                   k=k))
}

 data <- frame %>%
   group_by_at(vars(k, epsilon, algorithm))
 
 data_worp <- data %>%
   filter(algorithm=="parallel")
 
 data_wrp <- data %>%
   filter(algorithm=="parallel_rp")
 
 data_real_cluster <- data %>%
  filter(k==5)
 
 p1 <- ggplot(data, aes(factor(epsilon), time)) +  
   #ggtitle("DELTA Clustering Running-Time") +
   theme(legend.position="none") +
   scale_x_discrete(name = "epsilon") +
   scale_y_continuous(name = "running-time [min]") +
   #scale_fill_brewer(palette = "Set1") +
   geom_boxplot(aes(fill = algorithm), coef = 0, outlier.alpha = 0) +
   geom_boxplot(aes(color = algorithm),
                fatten = NULL, fill = NA, coef = 0, outlier.alpha = 0,
                show.legend = F) +
   facet_wrap(~k)

 p2 <- ggplot(data_wrp, aes(fill=algorithm)) +
   #ggtitle("DELTA Clustering Objective") +
   scale_x_discrete(name = "k") +
   scale_y_continuous(name = "objective value") +
   geom_boxplot(aes(factor(k), value), coef=0, outlier.alpha = 0.1) +
   geom_point(data=data_worp, aes(factor(k), value, color=algorithm), size=2) +
   theme(legend.position="none") 
 
 ggarrange(p2, ncol=1, nrow=1, common.legend = TRUE)
 
 #ggarrange(p1, p2, ncol=2, nrow=1, common.legend = TRUE)