#!/usr/bin/env python

import os
import sys
import re
import csv

arguments = sys.argv[1:]

for argument in arguments:

    os.system("cat {} | grep -- '->' > {}.stage1".format(argument, argument))

    with open("{}.stage1".format(argument), "r") as f:
        with open("{}.stage2".format(argument), "w") as g:
            for line in f:
                g.write(line[5:])
    with open("{}.stage2".format(argument), "r") as f:
        with open("{}.csv".format(argument), "w") as csvf:
            fieldnames = ["distance", "decision", "time", "querytime", "c1", "c2"]
            writer = csv.DictWriter(csvf, fieldnames = fieldnames)
            writer.writeheader()
            dist = -1
            for line in f:
                if line.startswith("Distance:"):
                    dist = re.findall("\d+\.\d+", line)
                else:
                    decision = re.findall("True|False", line)
                    data = re.findall("\d+\.\d+", line)
                    writer.writerow({'distance': dist[0], 'decision': decision[0], 'time': data[0], 'querytime': data[1], 'c1': data[2], 'c2': data[3]})
                
