library(tidyverse)

create_scores <- function(frame) {
  frame <- frame %>%
    group_by(sample_num) %>%
    arrange(t) %>%
    filter(row_number() == n()) %>%
    ungroup() %>%
    arrange(sample_num) %>%
    mutate(score = scale_to_unit_interval(-y_hat)) %>%
    select(sample_num, score) %>%
    arrange(sample_num)
  frame
}

create_roc <- function(frame, threshold) {
  frame <- frame %>%
    group_by(sample_num) %>%
    arrange(t) %>%
    filter(row_number() == n()) %>%
    ungroup() %>%
    arrange(sample_num)

  outcome <- (frame$y <= threshold)
  score <- scale_to_unit_interval(-frame$y_hat)

  pROC::roc(outcome, score)
}

scale_to_unit_interval <- function(x) {
  (x - min(x)) / (max(x) - min(x))
}

base1 <- read_csv("prediction_output/base_predictions1.csv")
prop1 <- read_csv("prediction_output/prop_predictions1.csv")

base1 %>% create_scores %>% write_csv("prediction_output/base1_scores.csv")
prop1 %>% create_scores %>% write_csv("prediction_output/prop1_scores.csv")

base2 <- read_csv("prediction_output/base_predictions2.csv")
prop2 <- read_csv("prediction_output/prop_predictions2.csv")

base2 %>% create_scores %>% write_csv("prediction_output/base2_scores.csv")
prop2 %>% create_scores %>% write_csv("prediction_output/prop2_scores.csv")

base3 <- read_csv("prediction_output/base_predictions3.csv")
prop3 <- read_csv("prediction_output/prop_predictions3.csv")

base3 %>% create_scores %>% write_csv("prediction_output/base3_scores.csv")
prop3 %>% create_scores %>% write_csv("prediction_output/prop3_scores.csv")

threshold <- 0.0

base1_roc <- create_roc(base1, threshold)
prop1_roc <- create_roc(prop1, threshold)

base2_roc <- create_roc(base2, threshold)
prop2_roc <- create_roc(prop2, threshold)

base3_roc <- create_roc(base3, threshold)
prop3_roc <- create_roc(prop3, threshold)

print(base1_roc)
print(prop1_roc)

print(base2_roc)
print(prop2_roc)

print(base3_roc)
print(prop3_roc)
