clear;
close all;

% Constants from experiments
H  = 30;
QX = 200;
QY = 200;
S  = 5;
NX = 3;
NY = 3;
Seed = 0:50;

for FG = [0 1]
  [ multi, alternative, circuit, forward, backward ] = aggregate_multi2(H, QX, QY, S, NX, NY, FG, Seed);
  multi = sort(multi);
  alternative = sort(alternative);
  circuit = sort(circuit);
  forward = sort(forward);
  backward = sort(backward);
  
  x = 100 * (Seed - min(Seed)) / (max(Seed) - min(Seed));
  
  f = figure('Position', [100, 100, 250, 200]);
  hold on;
  plot(x, multi,       'LineWidth', 2);
  plot(x, alternative + 0.25, 'LineWidth', 2);    % Need to get lines off of each other
  plot(x, circuit,     'LineWidth', 2);
  if (FG == 0)
    plot(x, forward + 0.50,     'LineWidth', 2);
    plot(x, backward,    'LineWidth', 2);
  else
    plot(x, forward,     'LineWidth', 2);
    plot(x, backward + 0.50,    'LineWidth', 2);
  end

  if (FG == 0)
    title(['Cost for Setting B']);
  else
    title(['Cost for Setting C']);
  end
  xlabel('Percentile');
  ylabel('Cost');
  xlim([min(x) max(x)]);
  ylim([20 35]);
  if (FG == 0)
    save2pdf(['comparisonF.pdf']);
  else
    save2pdf(['comparisonG.pdf']);
  end
  %legend('Multiple Threshold (Def 4.4)', 'Alternative (Def D.1)', 'Circuit (Def D.6)', 'Forward (Sec D.1)', 'Backward (Sec D.1)', 'Location', 'EastOutside');

end

